

#ifndef _WIDGETS_H_
#define _WIDGETS_H_

#include <wraster.h>
#include <X11/Xlib.h>

typedef void WMCallBack(); 
typedef void WMEventProc(XEvent *event, void *clientData);

/* self is set to the widget from where the callback is being called and
 * clientData to the data passed when the callback was registered */
typedef void WMSimpleCallback(void *self, void *clientData);


typedef struct {
    unsigned int width;
    unsigned int height;
} WMSize;


#define ClientMessageMask	(1L<<30)

typedef void *WMValue;


/* argument types */
typedef enum {
    WARG_X,
	WARG_Y,
	WARG_WIDTH,
	WARG_HEIGHT,
	WARG_CAPTION,
	WARG_ALT_CAPTION,
	WARG_RELIEF,
	WARG_ALIGNMENT,
	WARG_FONT,
	WARG_IMAGE,
	WARG_ALT_IMAGE,
	WARG_IMAGE_POSITION,
	WARG_TEXT,
	WARG_TITLE_POSITION,
	WARG_BORDERED,
	WARG_SELECTED,
	WARG_DISABLED,
	WARG_TAG
} WMArgumentType;


typedef struct WMArgument {
    WMArgumentType argument;
    WMValue *value;
} WMArgument;


/* event types */
typedef enum {
    WEV_CLICK
} WMEventType;


/* button types */
typedef enum {
        WBTMomentaryPush,
	WBTPushOnPushOff,
	WBTToggle,
	WBTSwitch,
	WBTRadio,
	WBTMomentaryChange,
	WBTOnOff,
	WBTMomentaryLight
} WMButtonType;


/* frame title positions */
typedef enum {
    WTPNoTitle,
	WTPAboveTop,
	WTPAtTop,
	WTPBelowTop,
	WTPAboveBottom,
	WTPAtBottom,
	WTPBelowBottom
} WMTitlePosition;


/* relief types */
typedef enum {
        WRFlat,
	WRSimple,
	WRRaised,
	WRSunken,
	WRGroove,
	WRRidge
} WMReliefType;


/* alignment types */
typedef enum {
        WALeft,
	WACenter,
	WARight
} WMAlignment;


/* image position */
typedef enum {
    WIPNoImage,
    WIPImageOnly,
    WIPLeft,
    WIPRight,
    WIPBelow,
    WIPAbove,
    WIPOverlaps
} WMImagePosition;


/* matrix types */
typedef enum {
        WMMRadioMode,
	WMMHighlightMode,
	WMMListMode,
	WMMTrackMode
} WMMatrixTypes;


/* alert panel return values */

enum {
        WAPRDefault = 0,
	WAPRAlternate = 1,
	WAPROther = -1,
	WAPRError = -2
};


typedef struct W_View {
    struct W_Screen *screen;

    Window window;

    WMSize size;

    struct {
	int x;
	int y;	
    } pos;
    
    int req_width;
    int req_height;
    
    struct W_View *parent;	       /* parent WMView */
    
    struct W_View *childrenList;       /* first in list of child windows */
    
    struct W_View *nextSister;	       /* next on parent's children list */
    
    struct W_EventHandler *handlerList;/* list of event handlers for this window */

    unsigned long attribFlags;
    XSetWindowAttributes attribs;
    
    void *hangedData;		       /* data for the client */

#ifdef WMAKER
    Window wmakerParent;
#endif
    
    struct {
	unsigned int realized:1;
	unsigned int mapped:1;
	unsigned int parentDying:1;
	unsigned int dying:1;
    } flags;
} W_View;


typedef int W_Class;

#define WC_Window 	1
#define WC_Frame 	2
#define WC_Label 	3
#define WC_Button	4
#define WC_TextField	5


/* All widgets must start with the following structure
 * in that order. Used for typecasting to get some generic data */
typedef struct W_WidgetType {
    W_Class widgetClass;
    W_View *view;
    
} W_WidgetType;


#define W_CLASS(widget)   	(((W_WidgetType*)(widget))->widgetClass)
#define W_VIEW(widget)   	(((W_WidgetType*)(widget))->view)

#define W_SCREEN(widget)	(W_VIEW(widget))->screen

#define W_WIDTH(widget)		(W_VIEW(widget))->size.width
#define W_HEIGHT(widget)	(W_VIEW(widget))->size.height


typedef void WMWidget;

typedef struct W_Pixmap WMPixmap;
typedef struct W_Font	WMFont;

typedef struct W_Screen WMScreen;

typedef struct W_View WMView;

typedef struct W_Window WMWindow;
typedef struct W_Frame WMFrame;
typedef struct W_Button WMButton;
typedef struct W_Label WMLabel;
typedef struct W_TextField WMTextField;






#ifdef WMAKER
WMScreen *WMCreateScreen(Display *display, int screen, RContext *context);
#else
WMScreen *WMCreateScreen(Display *display, int screen);
#endif

void WMSetApplicationIcon(WMScreen *scrPtr, WMPixmap *icon);

int WMHandleEvent(XEvent *event);


WMFont *WMLoadFont(WMScreen *scrPtr, char *font_name);

WMFont *WMRetainFont(WMFont *font);

void WMReleaseFont(WMFont *font);


WMPixmap *WMRetainPixmap(WMPixmap *pixmap);

void WMReleasePixmap(WMPixmap *pixmap);

WMPixmap *WMCreatePixmapFromXPixmaps(WMScreen *scrPtr, Pixmap pixmap, 
				     Pixmap mask, int width, int height,
				     int depth);


WMPixmap *WMCreatePixmapFromFile(WMScreen *scrPtr, char *fileName);


#ifdef WMAKER
WMWindow *WMCreateWindow(WMScreen *screen, Window parent, WMArgument *argv, 
			 int argc);
#else
WMWindow *WMCreateWindow(WMScreen *screen, WMArgument *argv, int argc);
#endif

void WMUnmapWidget(WMWidget *w);

void WMMapWidget(WMWidget *w);

void WMMapSubwidgets(WMWidget *w);

void WMDestroyWidget(WMWidget *widget);

void WMHangData(WMWidget *widget, void *data);

void *WMGetHangedData(WMWidget *widget);


void WMBindEvent(WMWidget *widget, WMEventType eventType, WMCallBack *callback,
		 void *clientData);


#define WMCreateCommandButton(parent, argv, argc) \
	WMCreateButton((parent), WBTMomentaryPush, (argv), (argc))

#define WMCreateRadioButton(parent, argv, argc) \
	WMCreateButton((parent), WBTRadio, (argv), (argc))

#define WMCreateSwitchButton(parent, argv, argc) \
	WMCreateButton((parent), WBTSwitch, (argv), (argc))

WMButton *WMCreateButton(WMWidget *parent, WMButtonType type, 
			 WMArgument *argv, int argc);

WMLabel *WMCreateLabel(WMWidget *parent, WMArgument *argv, int argc);


WMFrame *WMCreateFrame(WMWidget *parent, WMArgument *argv, int argc);

WMTextField *WMCreateTextField(WMWidget *parent, WMArgument *argv, int argc);


int WMConfigureWindow(WMWindow *wPtr, WMArgument *argv, int argc);

int WMConfigureFrame(WMFrame *fPtr, WMArgument *argv, int argc);

int WMConfigureButton(WMButton *bPtr, WMArgument *argv, int argc);

int WMConfigureLabel(WMLabel *lPtr, WMArgument *argv, int argc);

int WMConfigureTextField(WMTextField *tPtr, WMArgument *argv, int argc);


int WMGetButtonState(WMButton *bPtr);


void WMPlaceWidget(WMWidget *widget, int x, int y);

void WMCreateEventHandler(WMView *view, unsigned long mask,
			  WMEventProc *eventProc, void *clientData);

void WMDeleteEventHandler(WMView *view, unsigned long mask,
			  WMEventProc *eventProc, void *clientData);


void WMInsertTextInTextField(WMTextField *tPtr, char *text, int position);

void WMDeleteRangeFromTextField(WMTextField *tPtr, int position, int count);

char *WMGetTextFromTextField(WMTextField *tPtr);


#ifdef WMAKER
int
WMRunAlertPanel(WMScreen *scrPtr, Window parent, char *title, char *msg, char *defaultButton,
		char *alternateButton, char *otherButton);
char*
WMInputBox(WMScreen *scrPtr, Window parent, char *title, char *msg,
	      char *defaultText, char *okButton, char *cancelButton);
#else
int 
WMRunAlertPanel(WMScreen *scrPtr, char *title, char *msg, char *defaultButton,
		char *alternateButton, char *otherButton);
char*
WMInputBox(WMScreen *scrPtr, char *title, char *msg, char *defaultText, 
	      char *okButton, char *cancelButton);
#endif

void WMPerformButtonClick(WMButton *bPtr);



#endif
