/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 *
 * MailBox Status
 * !!! this should be external module (replacable for POP,IMAP,...)
 */

#include "icewm.h"

MailBoxStatus::MailBoxStatus(const char *mailBox, const char *mailCommand, YWindow *aParent): YWindow(aParent) {
    char *mail = getenv("MAIL");


    // this seems too much, getenv("MAIL") should do the trick... ?
    if (mail) {
        fMailBox = strdup(mail);
    } else if ((mailBox == 0 || mailBox[0] == 0) && getenv("LOGNAME") != 0) {
        char buf[1024];

        strcpy(buf, MAIL_SPOOL);
        strcat(buf, getenv("LOGNAME"));
        fMailBox = strdup(buf);
    } else if (mailBox && mailBox[0] != 0 && mailBox[strlen(mailBox) - 1] == '/' && getenv("LOGNAME") != 0) {
        char buf[1024];
	
	strcpy(buf, mailBox);
        strcat(buf, getenv("LOGNAME"));
        fMailBox = strdup(buf);
    } else
	fMailBox = mailBox;

    if (fMailBox)
        fprintf(stderr, "Using MailBox: '%s'\n", fMailBox);
    fMailCommand = mailCommand;
    fLastCheckTime = 0;
    fLastSize = 0;
    setSize(16, 16);
    mailBoxStatus = this;
    fState = mbxNoMail;
    checkMail();
}

MailBoxStatus::~MailBoxStatus() {
}

void MailBoxStatus::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    switch (fState) {
    case mbxHasMail:
        g.drawPixmap(mailPixmap, 0, 0);
        break;
    case mbxHasNewMail:
        g.drawPixmap(newMailPixmap, 0, 0);
        break;
    case mbxHasUnreadMail:
        g.drawPixmap(unreadMailPixmap, 0, 0);
        break;
    default:
        g.setColor(taskBarBg);
        g.fillRect(0, 0, width(), height());
        break;
    }
}

void MailBoxStatus::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (down.button == 1 && up.button == 1) {
        if (count == 1) {
            fLastCheckTime = 0;
            checkMail();
        } else if (count == 2) {
            if (fMailCommand != 0)
                runCommand(fMailCommand);
        }
    }
}

void MailBoxStatus::checkMail() {
    if ((time(NULL) - fLastCheckTime < 15) || fMailBox == 0)
        return ;

    struct stat st;
    MailBoxState fNewState = fState;

    if (stat(fMailBox, &st) == -1) {
        fNewState = mbxNoMail;
        fLastSize = 0;
    } else {
        if (st.st_size == 0)
            fNewState = mbxNoMail;
        else {
            fNewState = mbxHasMail;
            if (st.st_mtime > st.st_atime) {
                fNewState = mbxHasUnreadMail;
                if ((unsigned long)st.st_size > fLastSize) {
                    fNewState = mbxHasNewMail;
                    newMailArrived();
                }
            }
        }
        fLastSize = st.st_size;
    }

    if (fNewState != fState) {
        fState = fNewState;
        repaint();
    }
    fLastCheckTime = time(NULL);
}

void MailBoxStatus::newMailArrived() {
    if (beepOnNewMail)
        XBell(app->display(), 100);
}
