/*
**	SWISH++
**	string_set.h
**
**	Copyright (C) 1998  Paul J. Lucas
**
**	This program is free software; you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation; either version 2 of the License, or
**	(at your option) any later version.
** 
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
** 
**	You should have received a copy of the GNU General Public License
**	along with this program; if not, write to the Free Software
**	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef string_set_H
#define string_set_H

// standard
#include <set>

// local
#include "fake_ansi.h"
#include "less.h"

//*****************************************************************************
//
// SYNOPSIS
//
	class string_set
//
// DESCRIPTION
//
//	A string_set is used to contain a set of strings that can be
//	searched.  Note that C-style strings are used and that no string data
//	is actually copied.
//
// SEE ALSO
//
//	less.h
//
//*****************************************************************************
{
public:
	typedef char const* key_type;

	void insert( key_type s ) { set_.insert( s ); }
	bool find( key_type s ) const { return set_.find( s ) != set_.end(); }
private:
	typedef std::set< key_type > set_type;
	set_type set_;
};

#endif	/* string_set_H */
