#ifndef ___ARENA_TYPES_H___
#  define ___ARENA_TYPES_H___


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#ifdef __hpux
#  include <X11/HPkeysym.h>
#endif

#include "arena.h"
#include "colour_types.h"
#include "defs.h"
#include "display_types.h"
#include "dither_types.h"
#include "forms_types.h"
#include "history.h"
#include "image_types.h"
#include "neweditor.h"
#include "style_types.h"


#ifndef Byte
typedef unsigned char Byte;
#endif


typedef enum { INSTALL, INHIBIT, IFNECESSARY } InstallOwnColourMap;


/*
 * Document states.
 */
typedef enum
{
 DOC_NOTREGISTERED = 0,
 DOC_PENDING       = 1,
 DOC_ABORTED       = 2,
 DOC_LOADED        = 3,
 DOC_EXTERNAL      = 4,   /* externally viewed */
 DOC_PARSING_LOCK  = 5,	  /* doc is currently been parsing, hence locked */
 DOC_PROCESSED     = 6,
 DOC_REJECTED      = 7    /* e.g. if image can't be decoded */
} DocStatus;


/*
 * Graphic button.
 */
typedef struct s_button
{
 int x;
 int y;

 unsigned int w;
 unsigned int h;

 char* label;
 Image* icon;

} Button;


/*
 * Block structure used to simulate file access
 */
typedef struct memblock_struct
{
  char *buffer;
  size_t next;
  size_t size;
} Block;


typedef struct
{
 int x;
 int y;
 int width;
 int height;
} box;


typedef struct box_struct_
{
 box* box;
 struct box_struct_ *next;
} box_link;




/* parameters in frame-like objects:

   Each object starts with an 8 bit tag and ends with a 2 byte
   size field that permits moving back up the list of objects.
   The size is set to the number of bytes from the tag up to
   the size field itself.

      tag = BEGIN_FRAME
      offset (long)
      indent (int)
      width  (int)
      height (long)
      style  (1 byte)
      border (1 byte)

#ifdef STYLE_COLOUR_BORDER
      colour_border (1 byte)
#endif

#ifdef STYLE_BACKGROUND
      background pointer (pointer)
#endif
      length (int)
      zero or more elements
      size   (int)

   The length parameter gives the number of bytes until
   the end of the frame's data. It is used to skip quickly
   to objects following this frame. This requires a simple
   stack in DisplayHTML() to handle nested frames.

   The pixel offset for the end of the frame is marked by
   the END_FRAME object which specifies the number of bytes
   back to the corresponding BEGIN_FRAME object.

      tag = END_FRAME
      start  (int)
      size   (int)

   A frame for a line of text composed of multiple elements:

   TEXTLINE:

      tag == TEXTLINE
      offset (long)
      baseline (int)
      indent (int)
      height (int)
      zero or more elements
      1 byte marker (= 0)
      size (int)
*/

/*
   When parsing, we need to defer printing the END_FRAME marker
   until we come to print an object with the same or larger offset
   and at the same level of frame nesting. We also need to examine
   the widths and position of active frames to decide where to flow
   text and graphics. In this phase the Frame struct only uses
   the next, nesting, info and offset fields.

   When displaying, we need a list of frames which intersect the
   top of the window, plus a pointer to the background flow. Once
   this list has been dealt with, display continues in the background
   flow and subsequent frames are dealt with one at a time.

   When scrolling towards the start of the document, the code needs
   to take care in case a text line object intersects the top of
   the window, otherwise the first fully visible line will do.
*/

struct frame_struct
{
 struct frame_struct *next;  /* linked list of peer frames */
 struct frame_struct *child; /* linked list of nested frames */
 unsigned char *top;         /* where to start displaying from */
 long offset;                /* from start of document */
 unsigned int indent;        /* from left of document */
 long height;                /* documents can be very long */
 unsigned int width;
 int leftmargin;             /* indent from lhs of frame */
 int rightmargin;            /* indent from rhs of frame */
 unsigned int info;          /* to BEGIN_FRAME object in paint stream */
 unsigned int length;        /* byte count of frame's data */
 unsigned int lastrow;       /* used in parsing tables */
 unsigned char style;        /* frame's background style */
 unsigned char border;       /* frame's border style */
 int flow;                   /* ALIGN_LEFT, ALIGN_RIGHT,
				ALIGN_CENTER or ALIGN_NOTE */
 int oldmargin;              /* previous value of parent's margin */
 int pushcount;              /* save count value for restore */
 int leftcount;              /* of frames with ALIGN_LEFT or ALIGN_NOTE */
 int rightcount;             /* of frames with ALIGN_RIGHT */
 box_link* box_list;         /* a generalization of the previous
				push/restore margin */
#ifdef STYLE_COLOUR
 Byte cb_ix; 	             /* howcome 15/3/95:
				the index to the forgrround colour of
				tables etc */
#endif
};

typedef struct frame_struct Frame;


/* stack of nested frames starting after top of windo */

typedef struct sframe_struct
{
 unsigned char *p_next;
 unsigned char *p_end;
} StackFrame;

/* Used by Doc structure to record 1 instance of <a name= > tagging
 * within a document.  These are create by ParseHTML() for use by display 
 */
typedef struct _doc_named_anchor_fragment_ptrs
{
 char *Name;
 int   NameLen;
 long  NamePixelsFromTop;
} FragmentAnchor;


/* Doc structure used for new and current document
 * The main document structure
 */
typedef struct s_doc
{
 HTRequest* request;
 HTParentAnchor* anchor;
 char* href;		     /* as found in the <a href > construct,
				must be freed */
 char* url;		     /* points into anchor structure */
 char* tag;		     /* current tag pointing into history stack */
 char* base;                 /* Base URL (from <base href=""> if available) */
 char* title;
 char* link_style;
 char* head_style;
 char* content_buffer;
 Image* image;               /* if doc is an image */
 StyleSheet* style;
 long loaded_length;
 DocStatus state;            /* DOC_NOREGISTER, DOC_PENDING, DOC_LOADED ... */

 Bool pending_reload;        /* the document is being reloaded and
				should be freed when the fresh copy
				comes in */
 Bool nofree;
 Bool main_doc;              /* main doc, as opposed to inline doc */
 Bool user_style; 	     /* the document contains
				the user's preferred style sheet */
 HTList* host_documents;     /* if inline:
				list of hosts where referenced */
 HTList* inline_documents;   /* if host doc: list of inline docs,
				if   inline: list of hosts */
 HTList* bad_flags;

 char*   Fragment;          /* When libGetDocument()  = Fragment name to get */
 int     FragmentCounter;   /* from ParseHTML()... # of <a name= > tags      */
 HTList* FragmentPtr;       /* Linked list of name= tag pointers             */


#if 1	/* QingLong.30.01-98 */ /* this stuff should go to `DocView' */
 Bool already_displayed;

 Bool   show_raw;	/* for html docs, show raw data? */
 long  parsed_length;
 char*  paint_stream;
 long   paint_length;
 unsigned int  width;
 unsigned int height;

 Field*        edited_field;
 EditorBuffer* field_editor;
#endif

#if 1	/* QingLong.22-02-98 */ /* where should this stuff go to? */
 HTArray*    style_stack;
 StyleFlat*  current_flat;
 StyleSheet* current_sheet;
#endif
} Doc;



/*
 * Structures
 */

typedef struct s_context
{
  HTList* conversions;
  HTList* encodings;
  HTParentAnchor* home_anchor;
  StyleSheet* style;
  HTList* history;
  int history_pos;             /* Position in linked list.
                                  Probably obsolete now that list has
				  both previous and next */
  History* current_history;
} Context;



#endif	/* ifndef ___ARENA_TYPES_H___ */
