/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Routines for (General) MIDI device identification
 */

#include "libgus.h"
#include "libgus_local.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *gus_midi_device_info_manufacture( gus_midi_device_t *device )
{
  char text[ 81 ];

  if ( !device -> midi_id_number )
    return strdup( "not detected" );
  if ( device -> midi_id_number == 0xffff )
    return strdup( "inquiry sysex failed" );
  switch ( device -> midi_id_number ) {
    case 0x41:
      strcpy( text, "Roland Corporation" );
      break;
    case 0x100:
      strcpy( text, "Advanced Gravis Technologies" );
      break;
    default:
      sprintf( text, "unknown 0x%x\n", device -> midi_id_number );
  }
  return strdup( text );
}

char *gus_midi_device_info_family( gus_midi_device_t *device )
{
  char text[ 128 ];

  if ( !device -> midi_id_number )
    return strdup( "not detected" );
  if ( device -> midi_id_number == 0xffff )
    return strdup( "inquiry sysex failed" );
  text[ 0 ] = 0;
  switch ( device -> midi_id_number ) {
    case 0x41:			/* Roland */
      if ( device -> midi_family_code == 0x4200 )
        strcpy( text, "General MIDI + GS compatible" );
      break;
    case 0x100:
      return strdup( "General MIDI + GS compatible" );
      break;
  }
  if ( !text[ 0 ] )
    sprintf( text, "uknown 0x%x\n", device -> midi_family_code );
  return strdup( text );
}

char *gus_midi_device_info_product( gus_midi_device_t *device )
{
  char text[ 128 ];

  if ( !device -> midi_id_number )
    return strdup( "not detected" );
  if ( device -> midi_id_number == 0xffff )
    return strdup( "inquiry sysex failed" );
  text[ 0 ] = 0;
  switch ( device -> midi_id_number ) {
    case 0x41:			/* Roland */
      if ( device -> midi_family_code == 0x4200 &&
           device -> midi_family_number_code == 0x0201 )
        strcpy( text, "XP-10 multitimbral synthesizer" );
      break;
    case 0x100:
      switch ( device -> midi_family_number_code ) {
        case 0x0001:
          strcpy( text, "SoundCard - GF1 chip" );
          break;
        case 0x0002:
          strcpy( text, "SoundCard - InterWave chip" );
          break;
      }
      
      {
        gus_info_t info;
      
        if ( gus_midi_synth_info( device -> device, &info ) >= 0 )
          strcpy( text, info.flags & GUS_STRU_INFO_F_ENHANCED ? "SoundCard - InterWave chip" : "SoundCard - GF1 chip" );
         else
          strcpy( text, "SoundCard - error" );
      }
      break;
  }
  if ( !text[ 0 ] )
    sprintf( text, "uknown 0x%x\n", device -> midi_family_code );
  return strdup( text );
}

