/*  VER 009   TAB P   $Id: rnews.c,v 1.2 1997/08/14 13:39:45 src Exp $
 *
 *  handle rnews
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"

/*
 *  initiate rnews pipe
 */
FILE *
open_rnews(int *pidp)
{
    FILE *f;

    progtitle("pipe to rnews");
#if HAVE_RNEWS
    log_msg(L_DEBUG4,"forking...");
    if (!(f=fork_write(RNEWS_PATH,pidp,NULL,NULL))) {
	log_msg(L_ERR,"can't run rnews: %s",RNEWS_PATH);
	return 0;
    }
#else
    log_msg(L_ERR,"rnews not available");
    return 0;
#endif
}

/*
 *  close rnews pipe
 *  return true if OK
 */
int 
close_rnews(FILE *f, int pid)
{
    int n;

    fclose(f);
    /* BUG: error check.. */

    /* wait for child to finish */
    log_msg(L_DEBUG4,"wait pid %d...",pid);
    n = wait_pid(pid);
    log_msg(L_DEBUG,"rnews status is %d",n);
    return n==0;
}
