/*  VER 014  TAB P   $Id: incoming.c,v 1.2 1997/08/14 13:39:43 src Exp $
 *
 *  place incoming news in spool
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"

/* 
 * statics  
 *	    
 * BUG: must delete intmpname in case of error/interrupt etc
 */
static char intmpname[PATH_MAX];
static FILE *pull_spoolfp = 0; /* currently open spool */
static int pull_pid = 0; 

/*
 *  open spool file
 */
static int 
open_spool(void)
{
    if (!pull_spoolfp) {
	if (rnews_opt) {
	    if (!(pull_spoolfp = open_rnews(&pull_pid))) {
		log_msg(L_ERRno,"can't open pipe to rnews");
		return 0;
	    }
	    log_msg(L_DEBUG4,"opened rnews pipe, pid %d",pull_pid);
	} else {
	    /* temporary name */
	    char incomingdir[PATH_MAX];
    
	    build_alt_filename(incomingdir,SPOOL,INCOMING,incoming);
	    build_filename(intmpname,incomingdir,_IN_TMP,spoolname,NULL);
    
	    /* open temporary spool file proper */
	    if (!(pull_spoolfp = fopen(intmpname,"w"))) {
		log_msg(L_ERRno,"can't open incoming spool \"%s\"", intmpname);
		return 0;
	    }
	    log_msg(L_DEBUG4,"opened incoming spool: %s",intmpname);
	}
    }
    return 1;
}

/*
 *  write to incoming spool
 */
int 
write_in_coming(char *buffer,long bytecount)
{
    if (bytecount > 0) {
	/* open outgoing spool */
	if (!pull_spoolfp && !open_spool()) return 0;

	/* BUG: see of pull_spoolfp exists */
	fprintf(pull_spoolfp,"#! rnews %ld\n",bytecount);
	if (fwrite(buffer,sizeof(char),bytecount,pull_spoolfp)
						    != bytecount) {
	    log_msg(L_ERRno,"error writing to incoming spool");
	    return 0;
	}
	if (ferror(pull_spoolfp)) {
	    log_msg(L_ERRno,"problems with incoming spool");
	    return 0;
	}
    }
    return 1;
}

/*
 *  flush incoming  spool file
 */
int 
flush_spool(void)
{
    char inspoolname[PATH_MAX];
    FILE *f;
    static int sequence = 0;

    /* finished of spooled batch */
    if (pull_spoolfp) {
	if (rnews_opt) {
	    progtitle("pull: close rnews pipe");
	    if (!close_rnews(pull_spoolfp,pull_pid)) {
		log_msg(L_ERRno,"error closing rnews pipe");
		unlock_exit(6);
	    }
	    pull_spoolfp = 0;
	} else {
	    char incomingdir[PATH_MAX];
	    char spoolfile[PATH_MAX];
    
	    progtitle("pull: flush spool");
	    f = pull_spoolfp;
	    pull_spoolfp = 0;
	    /* BUG: errors? */
	    if (fclose(f) == EOF) {
		log_msg(L_ERRno,"error writing \"%s\"", intmpname);
		unlock_exit(6);
	    }
    
	    /* spool file is now ready for newsrun */
	    /* rename it so that it becomes visible */
	    sprintf(spoolfile,_INSPOOL,time((time_t *)0),getpid(),++sequence);
    
	    build_alt_filename(incomingdir,SPOOL,INCOMING,incoming);
	    build_filename(inspoolname,incomingdir,"/",spoolfile,NULL);
    
	    if (!rename_file(intmpname,inspoolname)) {
		unlink(intmpname);
		unlock_exit(6);
	    }
	}
    }
    return 1;
}
