/*  VER 172   TAB P   $Id: doit.c,v 1.2 1997/08/14 13:39:43 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h" 

#include <string.h>
#include <signal.h>

/*
 *  local functions
 */
static void 
set_signals(void);

/*
 *  do it
 */
int 
doit(void)
{
    int ret;
    time_t starttime,endtime;
    char *article_name = 0;

    progtitle("begin");
    set_signals();

    log_open();

    log_msg(L_DEBUG,"server: %s, spool: %s", hostname, spoolname);

    /* load the active file before we connect to the server */
    if (!nopull_opt || group_newlist || group_desc) {
	load_sys();
	load_active();
    }

    /* see if there are any articles batched up */
    if (!nopost_opt && !(article_name = despool_line())) {
	log_msg(L_DEBUG,"outgoing spool is empty");
	if (nopull_opt) {
	    /* don't bother */
	    return 0;
	}
    }

    /* set up the connection to the server */
    if (!noaction_opt) switch (ret = open_server(hostname,hostport)) {
    case -1 :
	return 3;
    case OK_CANPOST:
	++post_allowed;
	log_msg(L_DEBUG,"OK, can post");
	break;
    case OK_NOPOST:
	log_msg(L_DEBUG,"OK, but can't post");
	break;
    default:
	log_msg(L_ERR,"can't talk to \"%s\": got response code %d", hostname, ret);
	return 4;
    }

    /* start the timer now */
    time(&starttime);

    /* if authinfo details supplied, then use 'em */
    if (ai_username)
	do_authinfo(ai_username,ai_password);

    /* switch INN to nnrpd instead of innd if needed */
    if (!ihave_opt && mode_reader_opt > 0)
	do_mode_reader();

    /* get the active newgroup list from the server */
    if (group_list || group_newlist) {
	get_list();
	if (!nopull_opt || group_desc) {
	    /* the active list may have been updated by now... */
	    clear_active();
	    load_active();
	}
    }

    /* get the newgroup descriptions from the server */
    if (group_desc || group_alldesc) {
	get_desc();
    }

    /* now put the actual articles */
    if (article_name && !zap_opt)
	despool(article_name);

    /* might need to do the switch here */
    if (ihave_opt && mode_reader_opt >= 0)
	do_mode_reader();

    /* and pull any new articles */
    if (!nopull_opt) {
	log_msg(L_DEBUG,"fetching news");
	pull(spoolname);
    }

    /* time for goodbye */
    if (!noaction_opt)
	close_server();

    time(&endtime); 

    statistics(starttime,endtime);

    /* reached so far: everything is all right */
    return 0;
}

/*
 *  some don't have this, so give them a surrogate
 */
#ifndef HAVE_STRSIGNAL
char *
strsignal(int sig)
{
    static char buf[10];
    sprintf(buf,"%d",sig);
    return buf;
}
#endif

/*
 *  signal handler to report signal in log and possibly
 *  submit remaining batch to news and dump uncollected message ids.
 */
static RETSIGTYPE 
sig_interrupt(int signo)
{
    /* pretty primitive, but it works of sort */
    extern int alarm_active;

    if (alarm_active) {
	progtitle("interrupt -> alarm");
	log_msg(L_ERR,"received signal while alarm active %d", signo);
	/* alarm enabled, so treat it as such */
	sig_alrm(signo);
	return;
    }
    progtitle("interrupt");

    log_msg(L_ERR,"received signal: %s", strsignal(signo));

    /* clean up fetching */
    pull_cleanup();

    /* remove any locks */
    unlock_exit(1);
}

/*
 *  signal handler to ignore signal
 */
static RETSIGTYPE 
sig_ignore(int signo)
{
    signal(SIGUSR1, sig_ignore);
    log_msg(L_DEBUG4,"received signal: %s", strsignal(signo));
}

/*
 *  set up signal handler to catch appropriate signals.
 */
static void 
set_signals(void)
{
    /* these signals all causes us to terminate gracefully: */
    signal(SIGHUP,  sig_interrupt);
    signal(SIGINT,  sig_interrupt);
    signal(SIGQUIT, sig_interrupt);
    signal(SIGTERM, sig_interrupt);

    /* this signal is just to check that we are alive: */
    signal(SIGUSR1, sig_ignore);
}

