/*
 * Copyright (c) 1996 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include <atalk/adouble.h>

#include "directory.h"
#include "fork.h"

static struct ofork	**oforks = NULL;
static int	        nforks = 0;
static u_short		lastrefnum = 0;

pforkdesc( f )
    FILE	*f;
{
    u_short	ofrefnum;

    if (!oforks)
      return;

    for ( ofrefnum = 0; ofrefnum < nforks; ofrefnum++ ) {
	if ( oforks[ ofrefnum ] != NULL ) {
	    fprintf( f, "%hu <%s>\n", ofrefnum, oforks[ ofrefnum ]->of_name);
	}
    }
}

of_flush()
{
    u_short	refnum;

    if (!oforks)
      return 0;

    for ( refnum = 0; refnum < nforks; refnum++ ) {
	if ( oforks[ refnum ] != NULL &&
		flushfork( oforks[ refnum ] ) < 0 ) {
	    syslog( LOG_ERR, "of_flush: %m" );
	}
    }
    return( 0 );
}

    struct ofork *
of_alloc( dir, path, ofrefnum )
    struct dir		*dir;
    char		*path;
    u_short		*ofrefnum;
{
    u_short		refnum;
    int			i;

    if (!oforks) {
      nforks = (getdtablesize() - 10) / 2;
      oforks = (struct ofork **) calloc(nforks, sizeof(struct ofork *));
      if (!oforks)
	return NULL;
    }

    for ( refnum = lastrefnum++, i = 0; i < nforks; i++, refnum++ ) {
	if ( oforks[ refnum % nforks ] == NULL ) {
	    break;
	}
    }
    if ( i == nforks ) {
	return( NULL );
    }

    if (( oforks[ refnum % nforks ] =
	    (struct ofork *)malloc( sizeof( struct ofork ))) == NULL ) {
	syslog( LOG_ERR, "of_alloc: malloc: %m" );
	return NULL;
    }
    oforks[ refnum % nforks ]->of_dir = dir;
    if (( oforks[ refnum % nforks ]->of_name =
	    (char *)malloc( strlen( path ) + 1 )) == NULL ) {
	syslog( LOG_ERR, "of_alloc: malloc: %m" );
	free(oforks[refnum % nforks]);
	oforks[refnum % nforks] = NULL;
	return NULL;
    }
    strcpy( oforks[ refnum % nforks ]->of_name, path );
    *ofrefnum = refnum;
    return( oforks[ refnum % nforks ] );
}

    struct ofork *
of_find( ofrefnum )
    u_short	ofrefnum;
{
   if (!oforks)
     return NULL;

    return( oforks[ ofrefnum % nforks ] );
}

struct ofork *
of_findname(const char *name)
{
    int i;

    for (i = 0; i < nforks; i++) {
	if ( oforks[i] == NULL ) {
	    continue;
	}
	if (strcmp(oforks[i]->of_name, name) == 0) {
	    return oforks[i];
	}
    }
    return NULL;
}


of_dealloc( of )
    struct ofork	*of;
{
    u_short		refnum;

    if (!oforks)
      return;

    for ( refnum = 0; refnum < nforks; refnum++ ) {
	if ( oforks[ refnum ] == of ) {
	    break;
	}
    }
    if ( refnum == nforks ) {
	syslog( LOG_ERR, "of_dealloc: OOPS!" );
	return;
    }

    free( of->of_name );
    free( of );
    oforks[ refnum ] = NULL;
    return;
}
