/**************************************************************************** 
** File: payload.c
**
** Author: Mike Borella
**
** Comments: Dump packet payload
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <arpa/inet.h>
#include "config.h"

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_payload()
**
** Dump printable portions of packet payload
**
**----------------------------------------------------------------------------
*/

void dump_payload(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  int col;
  static char last = 0;


  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) ep = packet_end;

  /*
   * Print 64 bytes at a time, using .'s for "unprintable" chars.
   */

  col = 0;
  p = bp;
  printf("----------------------------------------------------------\n");
  while (p < ep)
    {
      if (*p < ' ' || *p > '~') 
	{
	  /*
	   * Eventually expand this and put it somewhere else?
	   */
	  
	  switch (*p)
	    {
	    case 10: 
	      printf("<LF>");
              col += 3;
	      break;
	    case 13:
	      printf("<CR>");
              col += 3;
	      break;
	    default:	
	      putchar('.');
	      break;
	    }
	}
      else 
	putchar(*p);
      last = *p;

      /*
       * Make sure that we only print 64 columns of chars
       */

      col++;
      if (col >= 64)
	{
	  putchar('\n');
	  col = 0;
	}

      p++;
    }

  putchar('\n');
}
