;;
;; Set up the menu
;;
(add-menu-entry "File" "New" "(new-siag)")
(add-menu-entry "File" "Open" "(load-buffer)")
(add-menu-entry "File" "Save" "(save-buffer)")
(add-menu-entry "File" "Save As" "(save-buffer-as)")
(add-menu-entry "File" "Preview" "(preview)")
(add-menu-entry "File" "Print" "(print)")
(add-menu-entry "File" "Print Format" "(print-format)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Load External" "(load-external)")
(add-menu-entry "File" "Save External" "(save-external)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Exit" "(quit-siag)")

(add-menu-entry "Edit" "Undo" "(undo-restore)")
(add-menu-entry "Edit" "Delete" "(delete-cell)")
(add-menu-entry "Edit" "Insert Line" "(insert-line)")
(add-menu-entry "Edit" "Remove Line" "(remove-line)")
(add-menu-entry "Edit" "Insert Column" "(insert-col)")
(add-menu-entry "Edit" "Remove Column" "(remove-col)")
(add-menu-entry "Edit" "Select All" "(select-all)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Find" "(search-forward)")
(add-menu-entry "Edit" "Find Backward" "(search-backward)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Label" "(edit-label)")
;;(add-menu-entry "Edit" "Expression" "(edit-expression)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "SIOD Expression" "(edit-siod)")
(add-menu-entry "Edit" "C Expression" "(edit-c)")
(add-menu-entry "Edit" "Guile Expression" "(edit-guile)")
(add-menu-entry "Edit" "Tcl Expression" "(edit-tcl)")
(add-menu-entry "Edit" "Change default interpreter" "(change-interpreter)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Add Property" "(add-property)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Embed Object" "(embed-object)")
(add-menu-entry "Edit" "Remove Object" "(embed-remove)")
(add-menu-entry "Edit" "Open Object" "(embed-open)")
(add-menu-entry "Edit" "Save Object" "(embed-save)")

(add-menu-entry "Block" "Set Mark" "(set-mark-command)")
(add-menu-entry "Block" "Set Block" "(set-block)")
(add-menu-entry "Block" "Unset Block" "(unset-block)")
(add-menu-entry "Block" "Copy Block" "(copy-block)")
(add-menu-entry "Block" "Delete Block" "(delete-block)")
(add-menu-entry "Block" "Fill Block" "(fill-block)")
(add-menu-entry "Block" "Smart Fill Block" "(smart-fill-block)")
(add-menu-entry "Block" "-" "-")
(add-menu-entry "Block" "Block Sum" "(block-sum)")
(add-menu-entry "Block" "Block Minimum" "(block-min)")
(add-menu-entry "Block" "Block Maximum" "(block-max)")
(add-menu-entry "Block" "Block Average" "(block-avg)")
(add-menu-entry "Block" "-" "-")
(add-menu-entry "Block" "Borders" "(block-borders 1)")
(add-menu-entry "Block" "Grid" "(block-borders 2)")
(add-menu-entry "Block" "Underline" "(block-borders 3)")
(add-menu-entry "Block" "None" "(block-borders 0)")

(add-menu-entry "Format" "Column Width" "(set-cell-width)")
(add-menu-entry "Format" "Fit Block Width" "(fit-block-width)")
(add-menu-entry "Format" "Row Height" "(set-cell-height)")
(add-menu-entry "Format" "Fit Block Height" "(fit-block-height)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Cell Format" "(set-cell-format)")
(add-menu-entry "Format" "Block Format" "(set-block-format)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Cell Style" "(set-cell-style)")
(add-menu-entry "Format" "Block Style" "(set-block-style)")
(add-menu-entry "Format" "Define Style" "(define-style)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Cell Color" "(cell-color)")
(add-menu-entry "Format" "Block Color" "(block-color)")

(add-menu-entry "Data" "Edit Record" "(data-record-edit (position-row (get-point)))")
(add-menu-entry "Data" "Data Entry" "(data-entry)")
(define (siag-net p)
  (require (string-append SIAGHOME "/siag/examples/siag-net.scm"))
  (siag-net p))
(add-menu-entry "Data" "Siag-net" "(siag-net 8080)")

(add-menu-entry "Window" "Change Buffer" "(switch-to-buffer)")
(add-menu-entry "Window" "Delete Buffer" "(kill-buffer)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Split Window" "(split-window-vertically)")
(add-menu-entry "Window" "Remove Window" "(delete-window)")
(add-menu-entry "Window" "One Window" "(delete-other-windows)")
(add-menu-entry "Window" "Change Window" "(other-window)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Protect Cells" "(protect-cells)")
(add-menu-entry "Window" "Remove Protection" "(remove-protection)")

(define *grid-lines* 1)
(add-menu-entry "Window" "Grid Lines" "(grid-lines (set! *grid-lines* (- 1 *grid-lines*)))")
(add-menu-entry "Window" "Disable Helptexts" "(helptext-mode 0)")

(add-menu-entry "Plot" "Lines" "(plot \"lines\")")
(add-menu-entry "Plot" "Points" "(plot \"points\")")
(add-menu-entry "Plot" "Linespoints" "(plot \"linespoints\")")
(add-menu-entry "Plot" "Impulses" "(plot \"impulses\")")
(add-menu-entry "Plot" "Dots" "(plot \"dots\")")
(add-menu-entry "Plot" "Steps" "(plot \"steps\")")
(add-menu-entry "Plot" "Boxes" "(plot \"boxes\")")
(add-menu-entry "Plot" "-" "-")
(add-menu-entry "Plot" "Surface" "(splot \"lines\")")
(add-menu-entry "Plot" "Advanced" "(no-op)")

(add-menu-entry "Help" "Contents" "(help-contents)")
(add-menu-entry "Help" "Search" "(help-search)")
(add-menu-entry "Help" "Copying" "(help-copyright)")
(add-menu-entry "Help" "Help for Help" "(help-for-help)")
(add-menu-entry "Help" "-" "-")
(add-menu-entry "Help" "About Siag" "(print-version)")

(add-menu-entry "Tools" "SIOD Command" "(exec-siod)")
(add-menu-entry "Tools" "C Command" "(exec-c)")
(add-menu-entry "Tools" "Guile Command" "(exec-guile)")
(add-menu-entry "Tools" "Tcl Command" "(exec-tcl)")
(add-menu-entry "Tools" "-" "-")
(add-menu-entry "Tools" "Terminal" "(spawn \"xterm -sb -sl 500 -j -ls -fn 7x14\")")
(add-menu-entry "Tools" "File Manager" "(spawn \"files\")")
(add-menu-entry "Tools" "Pathetic Writer" "(spawn \"pw\")")
(add-menu-entry "Tools" "Siag" "(spawn \"siag\")")
(add-menu-entry "Tools" "Egon Animator" "(spawn \"egon\")")
(add-menu-entry "Tools" "-" "-")
; Add the web server to the menu
(define (webserver)
  (require (string-append SIAGHOME "/siag/examples/siag-http.scm"))
  (siag-http 8080))

(add-menu-entry "Tools" "Webserver" "(webserver)")

; Add the mailer
(define (mailto)
  (require (string-append SIAGHOME "/siag/examples/mailto.scm"))
  (mailto))

(add-menu-entry "Tools" "Mail" "(mailto)")

; The file manager
(define (filemgr)
  (require (string-append SIAGHOME "/siag/examples/filemgr.scm"))
  (read-directory))

(add-menu-entry "Tools" "File Manager" "(filemgr)")
(add-menu-entry "Tools" "-" "-")

(add-menu-entry "Tools" "Form Test" "(form-test)")
(add-menu-entry "Tools" "Another Form Test" "(form-test2)")
(add-menu-entry "Tools" "Yet Another Form Test" "(form-test3)")
(add-menu-entry "Tools" "Another Form Test Still" "(form-test4)")

