
static char rcsid[] = "@(#)$Id: can_access.c,v 5.8 1993/08/23 02:46:07 syd Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.8 $   $State: Exp $
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** can_access - can this user access this file using their normal uid/gid

**/

/* WHAT HELL THIS IS!
 *
 * access -system call uses real uid / gid anyway !!!!!
 *
 *                              - K E H <hurtta@ozone.FMI.FI>
 */

#include "headers.h"
#include <sys/stat.h>
#include <errno.h>

#ifndef I_UNISTD
void _exit();
#endif

extern int errno;		/* system error number */

int can_access(file, mode)
     char *file; 
     int   mode;
{
	/** returns ZERO iff user can access file or "errno" otherwise **/

	int the_stat = 0, pid, w; 
	struct stat stat_buf;
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
	union wait status;
#else
	int status;
#endif
	
#ifdef VFORK
	if ((pid = vfork()) == 0) {
#else
	if ((pid = fork()) == 0) {
#endif
	  setgid(groupid);
	  setuid(userid);		/** back to normal userid **/

	  errno = 0;

	  if (access(file, mode) == 0) 
	    _exit(0);
	  else 
	    _exit(errno != 0? errno : 1);	/* never return zero! */
	  _exit(127);
	}

	errno = 0;
	while ((w = my_wait(pid,&status)) != pid && w != -1 || 
	       EINTR == errno)
	  ;


	if (w == -1) {
	  the_stat = errno;
	  if (!the_stat)
	    the_stat = 1;
	} else {
	  int sig = convert_status(status,&the_stat);
	  if (sig)
	    the_stat = 1;
	}

	if (the_stat == 0) {
	  if (stat(file, &stat_buf) == 0) {
#ifndef _POSIX_SOURCE
	    w = stat_buf.st_mode & S_IFMT;
	    if (w != S_IFREG)
	      the_stat = 1;
#else /* _POSIX_SOURCE */
	    w = stat_buf.st_mode;

	    if (! S_ISREG(w))
	      the_stat = 1;
#endif
	  }
	}

	return(the_stat);
}


