/*								-*- C++ -*-
 * $Id: DLG_base.h,v 1.2 1997-01-30 09:55:24+01 mho Exp $
 *
 * Purpose: dialog function box (used for common dialogs)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef DialogBase_h
#define DialogBase_h

#ifdef __GNUG__
#pragma interface
#endif

class wxButton;
class wxMessage;
class wxPanel;

class wxDialogBase : public wxDialogBox {
DECLARE_DYNAMIC_CLASS(wxDialogBase)
public:
    wxDialogBase(const char *message, const wxBitmap *bmp, const char *caption,
		 int style, wxWindow *parent=NULL, int x=-1, int y=-1);

    int   GetInput(void);
    void  OnCommand(wxWindow &win, wxCommandEvent &event);
    Bool  OnCharHook(wxKeyEvent &event);
    Bool  OnClose(void);
    void  OnPaint(void);
    void  OnSize(int width, int height);
private:
    int   pressed_button;
    long  dlg_style;
    int   x, y;
    const char *title;

    wxButton   *yes;
    wxButton   *no;
    wxButton   *ok;
    wxButton   *cancel;
    wxPanel    *buttons;
    wxMessage  *msg;
    wxMessage  *bmp;
};

#endif // DialogBase_h
