/* Zgv v2.7 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1995 Russell Marks. See README for license details.
 *
 * readngm.c - load NC100 NGM files.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "zgv.h"


/* for aborted file stuff */
static unsigned char *work_bmap,*work_pal;
static FILE *work_in;


int read_ngm_file(char *filename,hffunc howfarfunc,unsigned char **bmap,
  unsigned char **pal,int *output_type,PICINFO *pp)
{
FILE *in;
int f,x,y,z,c,w,h,bytepp;
unsigned char *ptr;

*bmap=NULL;
*pal=NULL;

if((in=fopen(filename,"rb"))==NULL)
  return(_PICERR_NOFILE);

/* always this size and depth */
bytepp=1; w=192; h=64;

if((*bmap=malloc(w*h))==NULL)
  return(_PICERR_NOMEM);

if((*pal=malloc(768))==NULL)
  return(_PICERR_NOMEM);

/* palette goes 0% (black), 15%, 50%, 85%, 100% (white) (due to a quirk
 * of the way the NC100 NGM displayer works)
 */
ptr=*pal;
ptr[0]=ptr[256]=ptr[512]=0;
ptr[1]=ptr[257]=ptr[513]=/*38*/ 50;	/* looks more like this */
ptr[2]=ptr[258]=ptr[514]=128;
ptr[3]=ptr[259]=ptr[515]=217;
ptr[4]=ptr[260]=ptr[516]=255;

memset(*bmap,0,w*h);

/* save stuff in case of abort */
work_in=in; work_bmap=ptr; work_pal=*pal;

/* ok, the format and the idea behind it goes like this.
 * NGM files are really 4 192x64 bitmaps (in raw PBM-like format)
 * concatenated together. The NC100 viewer for these sets them up
 * as screens in different areas of memory and switches between
 * them at a certain interval. Combined with the LCD display's
 * persistence, this gives the effect of 5 greyscales (though
 * two of them are odd shades, as mentioned above).
 *
 * To achieve the same effect in zgv, we just add one to a pixel value
 * each time there's a white (zero) pixel in any of the four bitmaps.
 */

for(z=0;z<4;z++)
  {
  ptr=*bmap;

  for(y=0;y<64;y++)
    {
    for(x=0;x<192/8;x++)
      {
      c=fgetc(in);
      
      for(f=0;f<8;f++,ptr++)
        if((c&(0x80>>(f&7)))==0) (*ptr)++;
      }
    }
  if(howfarfunc!=NULL) howfarfunc(z+1,4);
  }

pp->width=w;
pp->height=h;
pp->numcols=256;

*output_type=bytepp;

fclose(in);
return(_PIC_OK);  
}


void aborted_file_ngm_cleanup()
{
free(work_bmap);
free(work_pal);
fclose(work_in);
}
