/* sane - Scanner Access Now Easy.
   Copyright (C) 1998 Milon Fiikis based on David Mosberger-Tang previous
   Work on mustek.c file drom the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.  */
#ifndef apple_h
#define apple_h

#include <sys/types.h>

/* mode values: */
enum Apple_Modes
  {
  APPLE_MODE_LINEART=0,
  APPLE_MODE_HALFTONE,
  APPLE_MODE_GRAY,
  APPLE_MODE_BICOLOR,
  EMPTY_DONT_USE_IT,
  APPLE_MODE_COLOR
  };
  
enum Apple_Option
  {
    OPT_NUM_OPTS = 0,

    OPT_MODE_GROUP,
    OPT_MODE,
    OPT_RESOLUTION,
    OPT_PREVIEW,
    OPT_GRAY_PREVIEW,		/* This is only for ColorOneScanner
    				since the others don't have color options */

    OPT_GEOMETRY_GROUP,
    OPT_TL_X,			/* top-left x */
    OPT_TL_Y,			/* top-left y */
    OPT_BR_X,			/* bottom-right x */
    OPT_BR_Y,			/* bottom-right y */


    OPT_ENHANCEMENT_GROUP,
    /* COMMON				*/
    OPT_BRIGHTNESS,
    OPT_CONTRAST,
    OPT_THRESHOLD,
    
    /* AppleScanner only		*/
    OPT_GRAYMAP,
    OPT_AUTOBACKGROUND,
    OPT_AUTOBACKGROUND_THRESHOLD,

    /* OneScanner only			*/
    OPT_CALIBRATE,


    /* AppleScanner & OneScanner	*/
    OPT_HALFTONE_PATTERN,
    OPT_HALFTONE_FILE,


    /* Color OneScanner Only		*/
    OPT_CUSTOM_GAMMA,		/* use custom gamma tables? */
    /* The gamma vectors MUST appear in the order gray, red, green,
       blue.  */
    OPT_GAMMA_VECTOR,
    OPT_GAMMA_VECTOR_R,
    OPT_GAMMA_VECTOR_G,
    OPT_GAMMA_VECTOR_B,



#if 0
    OPT_CUSTOM_COLOR,
    OPT_CUSTOM_COLOR_TABLE,
   
/* TODO : Build the rest of the options when possible */
    OPT_ADVANCED_GROUP,
    /* COMMON				*/
    OPT_LAMP,
    /* AppleScanner only		*/
    OPT_WAIT,
    OPT_NOHOME,
    /* OneScanner only			*/
    OPT_SPEED,
    /* Color OneScanner Only		*/
    OPT_DATA_POLARITY,
    OPT_COLOR_SENSOR,

/* Unbelievably! I have to reverse engineer the Documentation in order to
understand what these are for */

    OPT_UNKNOWN_GROUP,
    /* OneScanner & Color OneScanner	*/
    OPT_LED,
    OPT_CCD,
    /* OneScanner only			*/
    OPT_RESET_BUTTON,
    OPT_SET_BUTTON,
    /* Color OneScanner Only		*/
    OPT_MTF_CIRQUIT,
    OPT_BYPASS_ICP,
    OPT_VOLT_REF_TOP,
    OPT_VOLT_REF_BOTTOM,
    OPT_CUSTOM_CALIBRATION,
    OPT_CUSTOM_CALIBRATION_VECTOR,
#endif


    /* must come last: */
    NUM_OPTIONS
  };

typedef union
  {
    SANE_Word w;
    SANE_Word *wa;		/* word array */
    SANE_String s;
  }
Option_Value;


/* Fixme: This is a hack to get fast the model of the Attached Scanner */
/* But it Works well and I am not considering in "fix" it */
enum SCANNERMODEL
  {
    OPT_NUM_SCANNERS = 0,

    APPLESCANNER, ONESCANNER, COLORONESCANNER,
    NUM_SCANNERS
  };

typedef struct Apple_Device
  {
    struct Apple_Device *next;
    SANE_Int ScannerModel;
    SANE_Device sane;
    SANE_Range dpi_range;
    SANE_Range x_range;
    SANE_Range y_range;
    SANE_Int MaxWidth;
    SANE_Int MaxHeight;
    unsigned flags;
  }
Apple_Device;

typedef struct Apple_Scanner
  {
    /* all the state needed to define a scan request: */
    struct Apple_Scanner *next;

    SANE_Option_Descriptor opt[NUM_OPTIONS];
    Option_Value val[NUM_OPTIONS];
    SANE_Int gamma_table[4][256];
    SANE_Int halftone_pattern[64];

    SANE_Bool scanning;
    SANE_Bool AbortedByUser;
 
    int pass;			/* pass number */
    SANE_Parameters params;

    /* These are needed for converting back and forth the scan area */

    SANE_Int bpp;	/* The actual bpp, before scaling */

    double ulx;
    double uly;
    double wx;
    double wy;
    SANE_Int ULx;
    SANE_Int ULy;
    SANE_Int Width;
    SANE_Int Height;

    int fd;			/* SCSI filedescriptor */

    /* scanner dependent/low-level state: */
    Apple_Device *hw;

  }
Apple_Scanner;

#endif /* apple_h */
