
/*
    xskat - a card game for 1 to 3 players.
    Copyright (C) 1998  Gunter Gerhardt

    This program is free software; you can redistribute it freely.
    Use it at your own risk; there is NO WARRANTY.
*/

#define NULL_C

#include "defs.h"
#include "skat.h"
#include "null.h"

VOID init_null()
{
  int i;

  for (i=0;i<4;i++) {
    wirftabfb[i]=0;
    hattefb[i]=0;
    aussplfb[i]=0;
    nochinfb[i]=8;
  }
}

VOID testnull(sn)
int sn;
{
  int i,f,c;
  int a[4],l[4],n[4],m[4],h[4],s[4];

  for (i=0;i<4;i++) a[i]=l[i]=n[i]=m[i]=h[i]=s[i]=0;
  f=1;
  for (i=0;i<10;i++) {
    c=cards[10*sn+i];
    a[c>>3]++;
    if ((c&7)>BUBE) l[c>>3]++;
    else if ((c&7)<BUBE && (c&7)!=ZEHN) h[c>>3]=1;
    else m[c>>3]=1;
    if ((c&7)==NEUN) n[c>>3]=1;
    if ((c&7)==SIEBEN) s[c>>3]=1;
  }
  for (i=0;i<4;i++) {
    if ((a[i] && l[i]!=a[i] && l[i]<2) ||
	(l[i]==1 && n[i]) ||
	(l[i]!=3 && !m[i] && h[i]) ||
	(a[i]>2 && !s[i])) f=0;
  }
  if (f) maxrw[sn]=35;
}

int kleiner(i,j)
int i,j;
{
  int w1,w2;

  w1=cards[possi[i]]&7;
  w2=cards[possi[j]]&7;
  if (w1==ZEHN) return w2<=BUBE;
  if (w2==ZEHN) return w1>BUBE;
  return w1>w2;
}

int hat(i)
int i;
{
  return !hatnfb[spieler][cards[possi[i]]>>3];
}

int n_anwert(c)
int c;
{
  int fb,i,m;

  fb=c>>3;
  if (hatnfb[spieler][fb]) return 0;
  for (i=AS;i<=SIEBEN;i=i==AS?KOENIG:i==BUBE?ZEHN:i==ZEHN?NEUN:i+1) {
    if (c==(fb<<3|i)) return 1;
    if (gespcd[fb<<3|i]!=2) break;
  }
  if ((c&7)==SIEBEN) {
    m=(((ausspl+1)%3!=spieler?1:2)+ausspl)%3;
    if (hatnfb[m][fb]!=1 && nochinfb[fb]>4) return 2;
  }
  if (wirftabfb[fb]) return 6;
  if (aussplfb[fb]) return 3;
  if (hattefb[fb]) return 5;
  return 4;
}

int n_anspiel()
{
  int i,j,ci,cj,wi,wj;

  j=0;
  for (i=1;i<possc;i++) {
    ci=cards[possi[i]];
    cj=cards[possi[j]];
    wi=n_anwert(ci);
    wj=n_anwert(cj);
    if (wi>wj || (wi==wj && kleiner(i,j))) j=i;
  }
  return j;
}

int n_abwert(c)
int c;
{
  int fb,i,n;

  fb=c>>3;
  if ((c&7)>=ACHT) return 0;
  for (i=0;i<possc;i++) {
    if (cards[possi[i]]==(fb<<3|SIEBEN)) return 1;
  }
  if (hatnfb[spieler][fb]) return 2;
  if (aussplfb[fb]) return 3;
  if (wirftabfb[fb]) return 7;
  if (hattefb[fb]) return 6;
  n=0;
  for (i=0;i<possc;i++) {
    if (cards[possi[i]]>>3==fb) n++;
  }
  if (n<3) return 5;
  return 4;
}

int n_abwerfen()
{
  int i,j,ci,cj,wi,wj;

  j=0;
  for (i=1;i<possc;i++) {
    ci=cards[possi[i]];
    cj=cards[possi[j]];
    wi=n_abwert(ci);
    wj=n_abwert(cj);
    if (wi>wj || (wi==wj && !kleiner(i,j))) j=i;
  }
  return j;
}

int minmax(f)
int f;
{
  int i,j,hi,hj;

  j=0;
  for (i=1;i<possc;i++) {
    hi=hat(i);
    hj=hat(j);
    if ((hi && !hj) || (kleiner(i,j)^f && (hi || !hj))) j=i;
  }
  return j;
}

int drunter(f)
int f;
{
  int i,j;

  j=0;
  for (i=1;i<possc;i++) {
    if (higher(cards[possi[j]],cards[possi[i]])) j=i;
  }
  for (i=0;i<possc;i++) {
    if (higher(stcd[f],cards[possi[i]]) &&
      higher(cards[possi[i]],cards[possi[j]])) j=i;
  }
  return j;
}

int drunterdrue()
{
  int i,w,fb;

  fb=stcd[0]>>3;
  i=-1;
  for (w=stcd[0]&7;w>=AS;w=w==NEUN?ZEHN:w==ZEHN?BUBE:w==KOENIG?AS:w-1) {
    if (i<0) {
      i=0;
      continue;
    }
    for (i=0;i<possc;i++) {
      if (cards[possi[i]]==(fb<<3|w)) return i;
    }
    if (gespcd[fb<<3|w]!=2) break;
  }
  return drunter(0);
}

VOID m_nsp()
{
  if (!vmh) playcd=minmax(0);
  else if (hatnfb[spieler][stcd[0]>>3]) playcd=minmax(1);
  else playcd=drunter(vmh==2?!higher(stcd[0],stcd[1]):0);
}

VOID m_nns(s)
int s;
{
  int sga;

  sga=spieler==ausspl;
  if (!vmh) playcd=n_anspiel();
  else if (hatnfb[s][stcd[0]>>3]) playcd=n_abwerfen();
  else if (vmh==1) {
    if (sga) playcd=drunter(0);
    else playcd=drunterdrue();
  }
  else if (higher(stcd[0],stcd[1])^sga) {
    playcd=minmax(1);
  }
  else {
    playcd=minmax(0);
    if (!higher(stcd[!sga],cards[possi[playcd]])) {
      playcd=minmax(1);
    }
  }
}

VOID null_stich()
{
  int i,fb1,fb2;

  for (i=0;i<3;i++) {
    nochinfb[stcd[i]>>3]--;
  }
  fb1=stcd[0]>>3;
  if (ausspl!=spieler) {
    fb2=stcd[(spieler-ausspl+3)%3]>>3;
    if (fb1!=fb2) {
      wirftabfb[fb2]=1;
    }
    else {
      hattefb[fb2]=1;
    }
  }
  else {
    aussplfb[fb1]=1;
    hattefb[fb1]=1;
  }
}
