.\" X-BASED PANEX
.\"
.\" xpanex.man
.\"
.\" ##
.\"
.\" Copyright (c) 1996 - 97	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH PANEX 6 "10 November 1997" "V5.4"
.SH NAME
xpanex \- Panex X widget 
.SH SYNOPSIS
.B /usr/games/xpanex
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-mono]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}] [-pyramid{0|1} {color}]
[-tiles {int}] [-{mode {int}|hanoi|panex}] [-delay msecs]
[-username {string}]
.SH DESCRIPTION
The original Panex puzzle is from the Japanese Magic Company from the
1980's.  Mathematicians at Bell Laboratories estimated the number of
moves to swap 2 columns of order 10 to be 27,564 <= N <= 31,537.
It came in two varieties: one with a blue and a yellow pyramid of order
10 on silver tiles; in the gold version pieces of each color look
alike (i.e. no pyramid is drawn on them), this is a little harder.
.LP
The original Tower of Hanoi puzzle is the invention of Edouard Lucas and
was sold as a toy in France in 1883.  The legend of 64 disks in the great
temple of Benares of the god Brahma is also his invention.
.SH FEATURES
Press "\fBmouse-left\fP" button to move a tile the top tile in a column.
Release "\fBmouse-left\fP" button on another column.  It will not move if
blocked.
.LP
Double click on "\fBmouse-right\fP" button or press "\fBR\fP" or "\fBr\fP"
keys to reset the puzzle.
.LP
Press "\fBM\fP" or "\fBm\fP" keys to toggle between hanoi (one pyramid
column) and panex (two pyramid columns) modes (they each have different
rules).
.BR
In Hanoi, one can not place larger trapezoid on a smaller trapezoid.
Here the goal is to move the pile from the left peg to the rightmost peg.
.BR
In Panex, a tile can not go lower that its initial starting point.
Here the goal is to exchange the 2 piles.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of tiles.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of tiles.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to auto-solve.  Unfortunately, its only
implemented from the starting position.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo last move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Unlike other puzzles in the collection there is no way to move pieces
without drag and drop.
.LP
The title is in the following format (non-motif version):
.RS
x{hanoi | panex}: <Number of rows> @ (<Number of moves>/{<Record number of
moves> <username>|"NEVER noaccess"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the panex window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-mono
This option specifies to display as if on a monochrome monitor
(resource name "\fImono\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the panex window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the panex window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the panex window
(resource name "\fIborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the panex window
(resource name "\fItileColor\fP").
.TP 8
.B \-pyramid0 \fIcolor\fP
This option specifies the foreground of the first pyramid (resource name
"\fIpyramidColor0\fP").
.TP 8
.B \-pyramid1 \fIcolor\fP
This option specifies the foreground of the second pyramid, if it exists
(resource name "\fIpyramidColor1\fP").
.TP 8
.B \-tiles \fIint\fP
This option specifies the number of tiles in a column (resource name
"\fItiles\fP").
.TP 8
.B \-mode \fIint\fP
This option specifies the hanoi (0) or panex (1) mode (resource name
"\fImode\fP").
.TP 8
.B \-hanoi
This option specifies the hanoi mode (resource name "\fImode\fP").
.TP 8
.B \-panex
This option specifies the panex mode (resource name "\fImode\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (resource name "\fIdelay\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
mode: 0-1 <0 hanoi, 1 panex>
.br
tiles: 1-10 <number of tiles in a column>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array pairs of column and position of each tile>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <from_column> <to_column>
.RE
from_column is the top tile of the column
.br
to_column is where that tile is moved to.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES 
Sliding Piece Puzzles (Recreations in Mathematics Series) by L. E. Horden,
Oxford University Press 1986, pp 144, 145.
.sp
Puzzles Old & New (How to Make and Solve Them) by Jerry Slocum & Jack
Botermans, University of Washington Press, Seattle, 1987, p 135.
.sp
Quantum January/February 1996 pp 55-57, 50-51.
(Author's name not present on my copy).
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1996-97, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
 David Albert Bagley, <\fIbagleyd@bigfoot.com\fP>
.RE
.LP
 The latest version is currently at:
.BR
 \fIftp://ftp.tux.org/pub/people/david-bagley/xpuzzles\fP
 \fIftp://ftp.x.org/contrib/applications\fP

