#!/bin/sh
#-- Part of SmallEiffel -- Read DISCLAIMER file -- Copyright (C) 
#-- Dominique COLNET and Suzanne COLLIN -- colnet@loria.fr
#--
#
# To INSTALL SmallEiffel on UNIX like platforms.
#
# If you have the gcc compiler, set the environment variable
# "SmallEiffel" to the appropriate value and simply
# run this INSTALL file (That's all if you have gcc :-).
#
# If you don't have gcc, you must procede manually doing the
# following :
#  - edit and run each SmallEiffel/bin_c/*.make file. Each call
#    to gcc must be changed by a call to your favorite C compiler.
#  - move each executable file in the SmallEiffel/bin directory.
#
# That's all. Good luck :-)
#
# Here the script to run if you have gcc :
sed=${SmallEiffel:=1}
if [ ${sed} = 1 ];  then 
	echo "Environment Variable 'SmallEiffel' not set."
	exit 1
fi
if [ -f ${SmallEiffel} ]; then
	echo ${SmallEiffel} "not found."
	exit 1
fi
cd ${SmallEiffel}
cd bin_c
for fmake in *.make 
do
	chmod a+x ${fmake}
	echo Running ${fmake}
	./${fmake}
	cmd=`basename $fmake .make`
	if [ -x ../bin/${cmd} ]; then
		mv -f ../bin/${cmd} ../bin/${cmd}.old
        fi
	mv -f ${cmd} ../bin/${cmd}
	/bin/rm -f ../bin/${cmd}.old
done
/bin/rm -f *.o
echo Setting system name.
/bin/rm -f ${SmallEiffel}/sys/system.se
echo "UNIX" > ${SmallEiffel}/sys/system.se
echo Writing default ${SmallEiffel}/sys/loadpath.UNIX

if [ Z`echo '\c'` = Z ]
then
	echoopt=''
	echosuf='\c'
else
	echoopt='-n'
	echosuf=''
fi

/bin/rm -f ${SmallEiffel}/sys/loadpath.UNIX
echo    "./"                       >  ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_std/"  >> ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_rand/" >> ${SmallEiffel}/sys/loadpath.UNIX
echo    "${SmallEiffel}/lib_show/" >> ${SmallEiffel}/sys/loadpath.UNIX
echo $echoopt "${SmallEiffel}/lib_se/$echosuf" >> ${SmallEiffel}/sys/loadpath.UNIX
echo Done.
