-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
deferred class ARRAYED_COLLECTION[E]
   -- 
   -- Common root for ARRAY[E] and FIXED_ARRAY[E].
   --

inherit COLLECTION[E];

feature {ARRAYED_COLLECTION}
   
   storage: NATIVE_ARRAY[E];
	 -- Internal access to storage location.
   
feature
   
   capacity: INTEGER;
	 -- Internal storage capacity in number of item.
   
   upper: INTEGER;
	 -- Upper index bound.
   
feature -- 

   sub_array(low, up: INTEGER): like Current is
      require
	 valid_index(low);
	 valid_index(up);
	 low <= up
      deferred
      ensure
	 same_type(Result);
	 Result.count = (up - low + 1);
	 Result.lower = low or Result.lower = 0
      end;

feature -- Implementation of deferred :

   add(element: like item; index: INTEGER) is
      do
	 if index = upper + 1 then
	    add_last(element);
	 else
	    add_last(element);
	    move(index,upper - 1,1);
	    put(element,index);
	 end;
      end;

   remove_last is
      do
	 upper := upper - 1;
      end;
   
feature -- The Guru section :

   frozen free is
      obsolete "Replaced by automatic Garbage Collection. %
             %Will be removed in the next release."
      do
      end;
   
feature -- Interfacing with C :
   
   to_external: POINTER is
	 -- Gives C access into the internal `storage' of the ARRAY.
	 -- Result is pointing the element at index `lower'.
	 -- 
	 -- NOTE: do not free/realloc the Result. Resizing of the array 
	 --       can makes this pointer invalid. 
      require
	 not empty
      do
	 Result := storage.to_pointer;
      ensure
	 Result.is_not_void
      end;

feature {NONE}

   malloc(size: INTEGER): POINTER is
      require
	 size > 0
      local
	 x: like item;
	 mem: MEMORY;
      do
	 if x.is_expanded_type then
	    Result := mem.malloc(size * x.object_size);
	 else
	    Result := mem.malloc(size * mem.pointer_size);
	 end;
      end;

   calloc(size: INTEGER): POINTER is
      require
	 size > 0
      local
	 x: like item;
	 mem: MEMORY;
      do
	 if x.is_expanded_type then
	    Result := mem.calloc(size,x.object_size);
	 else
	    Result := mem.calloc(size,mem.pointer_size);
	 end;
      end;

   realloc(pointer: POINTER; size: INTEGER): POINTER is
      require
	 size > 0
      local
	 x: like item;
	 mem: MEMORY;
      do
	 if x.is_expanded_type then
	    Result := mem.realloc(pointer,size * x.object_size);
	 else
	    Result := mem.realloc(pointer,size * mem.pointer_size);
	 end;
      end;

feature {ARRAYED_COLLECTION}

   set_upper(new_upper: like upper) is
      do
	 upper := new_upper;
      end;

invariant

   capacity >= 0;

   capacity >= (upper - lower + 1);

   capacity > 0 implies storage.is_not_void;

end -- ARRAYED_COLLECTION[E]

