#! /bin/bash
# Wrapper script for SmallEiffel programming

if [ -z $SmallEiffel ]
then
	export SmallEiffel=/usr/lib/smalleiffel
	echo Setting SmallEiffel variable to $SmallEiffel
fi

rcfile=$HOME/.smalleiffelrc
if [ -f $rcfile ]
then
	dir=`grep '^Directory=' $rcfile | cut -f2 -d=`
	cd $dir
	class=`grep '^Class=' $rcfile | cut -f2 -d=`
	root_proc=`grep '^Root_proc=' $rcfile | cut -f2 -d=`
	options=`grep '^Options=' $rcfile | cut -f2 -d=`
	root=`grep '^Root=' $rcfile | cut -f2 -d=`
else
	options='-c_code -all_check'
	root_proc=make
	root=''
	class=''
fi

if [ -z "$EDITOR" ]
then
	EDITOR=vi
fi

if [ -z "$PAGER" ]
then
	PAGER=more
fi

while true
do
echo -n "SmallEiffel
===========
Directory           = `pwd`
Root class          = $root
Root procedure      = $root_proc
Current class file  = $class
Compilation options = $options

D. Change directory                 4. Clean system
C. Change class file                5. Compile system
R. Set root class                   6. Compile to C
P. Set root procedure               7. Compile to Java
Z. Set compilation options          8. Show Java byte code
1. Edit class file                  9. Short view of class
2. Prettify class file              X. Execute compiled program
3. Find class file                  Q. Quit

Enter choice: "

read choice

case $choice in
	d | D)	echo -n "
New directory = "
		read newdir
		nd=`eval echo $newdir`
		if [ -d "$nd" ]
		then
			cd $nd
		else
			echo Bad directory \($newdir\)
		fi
		;;
	c | C)	echo -n "
New class file = "
		read newclass
		if [ -e "$newclass" -a \( ! -f "$newclass" -o] ! -r "$newclass" \) ]
		then
			echo $newclass is not a readable file
		else
			class=$newclass
		fi
		;;
	r | R)  echo -n "
New root class = "
		read root
		;;
	p | P)  echo -n "
New root procedure = "
		read root_proc
		;;
	z | Z)  echo -n "
New compilation options = "
		read options
		;;
	1)	$EDITOR $class
		;;
	2)	pretty $class
		;;
	3)	echo -n "
Find which class? "
		read to_find
		finder $to_find
		;;
	4)	clean $root
		;;
	5)	compile $options -o $root $root $root_proc
		;;
	6)	compile_to_c `echo $options | sed -e 's/-c_code//'` -o $root $root $root_proc 
		;;
	7)	compile_to_jvm `echo $options | sed -e 's/-c_code//'` -o ${root}_java $root $root_proc 
		;;
	8)	print_jvm_class ${root}_java/${root} | $PAGER
		;;
	9)	echo -n "Show inherited features [Y/n]? "
		read x
		if [ -z "$x" ]
		then
			x=y
		fi
		case $x in YES|yes|Y|y)
				short ${class} | $PAGER
				;;
			NO|no|N|n)
				short -short ${class} | $PAGER
				;;
			*)
				echo "Bad response"
				sleep 1
				;;
		esac
		;;
	x | X)	(./$root)
		;;
	q | Q)	echo "Directory=`pwd`
Root=$root
Root_proc=$root_proc
Class=$class
Options=$options
" >$rcfile 
		exit 0
		;;
esac
done
