/* Tower of hanoi */
/* Note, this program uses curses, so you'd either have to load a library 
   of external functions, or you must run it from another application, 
   that has registered the neccessary functions (hanoi.c) */

say starting
call charout ,"Number of discs (3-12) ? "
parse pull disks .

trace o
dll.unix='curses.rxlib'
dll.linux='curses.rxlib'
dll.os2='RXCURSES'
dll.win32='RXCURSES'
dll.windowsnt='RXCURSES'
dll.windows95='RXCURSES'
dll.win='RXCURSES'
Parse Source int_os .
If int_os = 'OS/2' Then int_os = 'OS2'; Else int_os = Translate(int_os)
lib = dll.int_os
if rxfuncadd('CURLOADFUNCS',lib,'CurLoadFuncs')  then do
   say 'An error occured when trying to load the library: "'lib'"'
   say 'The error message returned was: "'rxfuncerrmsg()'"'
   say 'Exiting...'
   exit
   end

signal on syntax

call curloadfuncs
call cur_initscr
if cur_has_colors() Then
  Do
    call cur_start_color
    call cur_init_pair 1, 'COLOR_RED', 'COLOR_BLACK'
    call cur_init_pair 2, 'COLOR_BLUE', 'COLOR_BLACK'
    call cur_init_pair 3, 'COLOR_WHITE', 'COLOR_BLACK'
    call cur_init_pair 4, 'COLOR_GREEN', 'COLOR_BLACK'
    call cur_init_pair 5, 'COLOR_YELLOW', 'COLOR_BLACK'
    call cur_init_pair 6, 'COLOR_CYAN', 'COLOR_BLACK'
    call cur_init_pair 7, 'COLOR_MAGENTA', 'COLOR_BLACK'
    call cur_init_pair 8, 'COLOR_RED', 'COLOR_BLACK'
    call cur_init_pair 9, 'COLOR_BLUE', 'COLOR_BLACK'
    call cur_init_pair 10, 'COLOR_WHITE', 'COLOR_BLACK'
    call cur_init_pair 11, 'COLOR_GREEN', 'COLOR_BLACK'
    call cur_init_pair 12, 'COLOR_YELLOW', 'COLOR_BLACK'
  End

if cur_has_acs() then platechar = 'ACS_CKBOARD'
else platechar = '#'

call cur_curs_set 0  /* turn off cursor */
call cur_clear
call cur_erase
call cur_refresh

w1 = cur_newwin(3,55,1,10)
call cur_box w1
call cur_wmove w1, 1, 2
call cur_waddstr w1, 'Towers of Hanoi:' disks 'disks: '
call cur_wrefresh w1

rc = time('E')

pole.1 = "" 
pole.2 = ""
pole.3 = ""
pole.height = disks 

do i=1 to disks 
   pole.1 = space( i pole.1 )
   end

parse value  13 40 66  with pole.pos.1 pole.pos.2 pole.pos.3

call setup_screen 
call move_stack disks 1 3 2
call cur_curs_set 1  /* turn on cursor */
call cur_waddstr w1, 'Elapsed time:' Time('E')
call cur_wrefresh w1
call cur_move 5, 20
call cur_addstr 'Press any key to continue...'
call cur_refresh
call cur_cbreak
call cur_noecho
rc = cur_getch()
call cur_delwin w1
call cur_endwin
return 0

move_stack: procedure expose pole. screen. platechar
   parse arg num from target scratch
   if num <= 0 then 
      return

   call move_stack num-1 from scratch target
   call move_plate from target
   call move_stack num-1 scratch target from
   return 



move_plate: procedure expose pole. screen. platechar
   parse arg from target
   
   plate = word( pole.from, words( pole.from )) 
/* pole.from = subword( pole.from, 1, words( pole.from ) - 1 )  */
   pole.from = reverse( pole.from )
   parse var pole.from . pole.from 
   pole.from = reverse( pole.from ) 
   
   if 0 then
      say 'Moving plate' plate 'from pole' from 'to pole' target
   else
      call draw_a_move plate from target

   pole.target = pole.target plate
   return


draw_a_move: procedure expose pole. screen. platechar
   parse arg plate from target

   top = screen.height - pole.height - 2
   fulllen = plate*2+1
   empty = center('|', plate*2+1)
   real_empty = copies( ' ', plate*2+1)

   do i=words(pole.from) to pole.height+1
      call cur_move screen.height-i-2, pole.pos.from-plate
      if cur_has_colors() Then call cur_attrset 'COLOR_PAIR('plate')', 'A_BOLD'
      do fulllen
         call cur_addch platechar
         end
      If cur_has_colors() Then call cur_attrset 'A_NORMAL'
      call cur_move screen.height-i-1, pole.pos.from-plate
      if (i>pole.height) then
         call cur_addstr real_empty
      else
         call cur_addstr empty
      call cur_refresh
      end

   top = screen.height - pole.height - 3
   step = sign( pole.pos.target - pole.pos.from )
   do i=pole.pos.from to pole.pos.target-step by step
      if i-step*plate < 0 then trace ?r
      call cur_move top, i-step*plate
      call cur_addch ' '
      call cur_move top, i+step*plate+step
      if cur_has_colors() Then call cur_addch platechar, 'COLOR_PAIR('plate')', 'A_BOLD'
      else call cur_addch platechar
      call cur_refresh 
      end


   j = screen.height - pole.height - 1
   do i=0 to pole.height + 1 - words(pole.target)
      call cur_move j+i-1, pole.pos.target-plate
      if cur_has_colors() Then call cur_attrset 'COLOR_PAIR('plate')', 'A_BOLD'
      do fulllen
         call cur_addch platechar
         end
      If cur_has_colors() Then call cur_attrset 'A_NORMAL'
      call cur_move j+i-2, pole.pos.target-plate
      if (i<=1) then
         call cur_addstr real_empty
      else
         call cur_addstr empty
      call cur_refresh
      end

   return 


setup_screen: 
   screen.height = lines-1 /*24*/
   screen.width = cols /*80*/
   

   do i=1 to disks
      call cur_move screen.height-i, pole.pos.1-(disks+1-i)
      fulllen = 2*(disks-i)+3
      if cur_has_colors() Then call cur_attrset 'COLOR_PAIR(' || (fulllen-1)/2 || ')', 'A_BOLD'
      do fulllen
         call cur_addch platechar
         end
      end

   If cur_has_colors() Then call cur_attrset 'A_NORMAL'
   call cur_move (screen.height-(disks+1)), pole.pos.1
   call cur_addch '|'

   do i=1 to disks+1
      call cur_move screen.height-i, pole.pos.2
      call cur_addch '|'
      call cur_move screen.height-i, pole.pos.3
      call cur_addch '|'
      end

   call cur_refresh

   return

trap_msg:
   say 
   say 'Sorry, this script is not meant to be executed directly from the'
   say 'command line. It is a demonstration of the use of the libregina.a'
   say 'library. Try to compile "hanoi.c", and like with libregina.a, and'
   say 'try to run the "hanoi" program. Enjoy!'
   say 
   exit 0

syntax:
   call cur_endwin
   exit 0
