
#define INCL_RXSHV	/* Shared variable support */
#define INCL_RXFUNC	/* External functions support */

#include <stdio.h>
#include <stdlib.h>
#if defined(__WATCOMC__) || defined(__IBMC__) || defined(_MSC_VER)
#else
# include <termios.h>
#endif
#include <assert.h>
#if defined(XCURSES)
# include "xcurses.h"
char *XCursesProgramName="rxcurses";
#else
# include <curses.h>
#endif

#ifdef __PDCURSES__
# define HAVE_CURS_SET
# define HAVE_NAPMS
# define HAVE_KEYPAD
#endif

#define HAVE_KEYNAME

#ifdef __hpux
# undef HAVE_KEYNAME
#endif

#include "rexxsaa.h"

#if defined(__WATCOMC__) || defined(__IBMC__) || defined(_MSC_VER)
# define DLLNAME "RXCURSES"
#else
# define DLLNAME "curses.rxlib"
#endif

#ifndef HAVE_KEYNAME
typedef struct 
{
   char *keyname;
   int keynumber;
} KeyName;

static KeyName RexxKeyNames[] = {
   { "KEY_BREAK",     KEY_BREAK },
   { "KEY_DOWN",      KEY_DOWN  },
   { "KEY_UP",        KEY_UP    },
   { "KEY_LEFT",      KEY_LEFT  },
   { "KEY_RIGHT",     KEY_RIGHT },
   { "KEY_HOME",      KEY_HOME  },
   { "KEY_BACKSPACE", KEY_BACKSPACE  },
   { "KEY_F(0)",      KEY_F0    },
   { "KEY_F(1)",      KEY_F0+1  },
   { "KEY_F(2)",      KEY_F0+2  },
   { "KEY_F(3)",      KEY_F0+3  },
   { "KEY_F(4)",      KEY_F0+4  },
   { "KEY_F(5)",      KEY_F0+5  },
   { "KEY_F(6)",      KEY_F0+6  },
   { "KEY_F(7)",      KEY_F0+7  },
   { "KEY_F(8)",      KEY_F0+8  },
   { "KEY_F(9)",      KEY_F0+9  },
   { "KEY_F(10)",     KEY_F0+10 },
   { "KEY_F(11)",     KEY_F0+11 },
   { "KEY_F(12)",     KEY_F0+12 },
   { "KEY_F(13)",     KEY_F0+13 },
   { "KEY_F(14)",     KEY_F0+14 },
   { "KEY_F(15)",     KEY_F0+15 },
   { "KEY_F(16)",     KEY_F0+16 },
   { "KEY_F(17)",     KEY_F0+17 },
   { "KEY_F(18)",     KEY_F0+18 },
   { "KEY_F(19)",     KEY_F0+19 },
   { "KEY_F(20)",     KEY_F0+20 },
   { "KEY_F(21)",     KEY_F0+21 },
   { "KEY_F(22)",     KEY_F0+22 },
   { "KEY_F(23)",     KEY_F0+23 },
   { "KEY_F(24)",     KEY_F0+24 },
   { "KEY_F(25)",     KEY_F0+25 },
   { "KEY_F(26)",     KEY_F0+26 },
   { "KEY_F(27)",     KEY_F0+27 },
   { "KEY_F(28)",     KEY_F0+28 },
   { "KEY_F(29)",     KEY_F0+29 },
   { "KEY_F(30)",     KEY_F0+30 },
   { "KEY_F(31)",     KEY_F0+31 },
   { "KEY_F(32)",     KEY_F0+32 },
   { "KEY_F(33)",     KEY_F0+33 },
   { "KEY_F(34)",     KEY_F0+34 },
   { "KEY_F(35)",     KEY_F0+35 },
   { "KEY_F(36)",     KEY_F0+36 },
   { "KEY_F(37)",     KEY_F0+37 },
   { "KEY_F(38)",     KEY_F0+38 },
   { "KEY_F(39)",     KEY_F0+39 },
   { "KEY_F(40)",     KEY_F0+40 },
   { "KEY_F(41)",     KEY_F0+41 },
   { "KEY_F(42)",     KEY_F0+42 },
   { "KEY_F(43)",     KEY_F0+43 },
   { "KEY_F(44)",     KEY_F0+44 },
   { "KEY_F(45)",     KEY_F0+45 },
   { "KEY_F(46)",     KEY_F0+46 },
   { "KEY_F(47)",     KEY_F0+47 },
   { "KEY_F(48)",     KEY_F0+48 },
   { "KEY_F(49)",     KEY_F0+49 },
   { "KEY_F(50)",     KEY_F0+50 },
   { "KEY_F(51)",     KEY_F0+51 },
   { "KEY_F(52)",     KEY_F0+52 },
   { "KEY_F(53)",     KEY_F0+53 },
   { "KEY_F(54)",     KEY_F0+54 },
   { "KEY_F(55)",     KEY_F0+55 },
   { "KEY_F(56)",     KEY_F0+56 },
   { "KEY_F(57)",     KEY_F0+57 },
   { "KEY_F(58)",     KEY_F0+58 },
   { "KEY_F(59)",     KEY_F0+59 },
   { "KEY_F(60)",     KEY_F0+60 },
   { "KEY_F(61)",     KEY_F0+61 },
   { "KEY_F(62)",     KEY_F0+62 },
   { "KEY_F(63)",     KEY_F0+63 },
   { "KEY_DL",        KEY_DL    },
   { "KEY_IL",        KEY_IL    },
   { "KEY_DC",        KEY_DC    },
   { "KEY_IC",        KEY_IC    },
   { "KEY_EIC",       KEY_EIC   },
   { "KEY_CLEAR",     KEY_CLEAR },
   { "KEY_EOS",       KEY_EOS   },
   { "KEY_EOL",       KEY_EOL   },
   { "KEY_SF",        KEY_SF    },
   { "KEY_SR",        KEY_SR    },
   { "KEY_NPAGE",     KEY_NPAGE },
   { "KEY_PPAGE",     KEY_PPAGE },
   { "KEY_STAB",      KEY_STAB  },
   { "KEY_CTAB",      KEY_CTAB  },
   { "KEY_CATAB",     KEY_CATAB },
   { "KEY_ENTER",     KEY_ENTER },
   { "KEY_SRESET",    KEY_SRESET},
   { "KEY_RESET",     KEY_RESET },
   { "KEY_PRINT",     KEY_PRINT },
   { "KEY_LL",        KEY_LL    },
   { "KEY_A1",        KEY_A1    },
   { "KEY_A3",        KEY_A3    },
   { "KEY_B2",        KEY_B2    },
   { "KEY_C1",        KEY_C1    },
   { "KEY_C3",        KEY_C3    },
   { "KEY_BTAB",      KEY_BTAB  },
   { NULL,            0         },
};
#endif

RexxFunctionHandler CurLoadFuncs;
RexxFunctionHandler CurDropFuncs;
RexxFunctionHandler cur_addch;    
RexxFunctionHandler cur_waddch;
RexxFunctionHandler cur_addstr;   
RexxFunctionHandler cur_waddstr;
RexxFunctionHandler cur_box;      
RexxFunctionHandler cur_cbreak;
RexxFunctionHandler cur_nocbreak;
RexxFunctionHandler cur_clear;    
RexxFunctionHandler cur_clearok;  
RexxFunctionHandler cur_clrtobot; 
RexxFunctionHandler cur_clrtoeol; 
RexxFunctionHandler cur_wclrtobot;
RexxFunctionHandler cur_wclrtoeol;
RexxFunctionHandler cur_crmode;   
RexxFunctionHandler cur_curs_set;
RexxFunctionHandler cur_delch;    
RexxFunctionHandler cur_mvdelch;
RexxFunctionHandler cur_wdelch;
RexxFunctionHandler cur_mvwdelch;
RexxFunctionHandler cur_deleteln; 
RexxFunctionHandler cur_wdeleteln;
RexxFunctionHandler cur_delwin;
RexxFunctionHandler cur_echo;     
RexxFunctionHandler cur_endwin;   
RexxFunctionHandler cur_erase;    
RexxFunctionHandler cur_getch;    
RexxFunctionHandler cur_wgetch;
RexxFunctionHandler cur_getstr;   
RexxFunctionHandler cur_getyx;    
RexxFunctionHandler cur_inch;     
RexxFunctionHandler cur_initscr;  
RexxFunctionHandler cur_insch;    
RexxFunctionHandler cur_insertln; 
RexxFunctionHandler cur_keypad;
RexxFunctionHandler cur_move;     
RexxFunctionHandler cur_wmove;
RexxFunctionHandler cur_napms;
RexxFunctionHandler cur_newwin;
RexxFunctionHandler cur_nl;       
RexxFunctionHandler cur_nocrmode; 
RexxFunctionHandler cur_noecho;   
RexxFunctionHandler cur_noraw;    
RexxFunctionHandler cur_printw;   
RexxFunctionHandler cur_raw;      
RexxFunctionHandler cur_refresh;  
RexxFunctionHandler cur_wrefresh;
RexxFunctionHandler cur_scanw;    
RexxFunctionHandler cur_standend; 
RexxFunctionHandler cur_standout; 
RexxFunctionHandler cur_attrset;
RexxFunctionHandler cur_wattrset;
RexxFunctionHandler cur_attron;
RexxFunctionHandler cur_wattron;
RexxFunctionHandler cur_attroff;
RexxFunctionHandler cur_wattroff;
RexxFunctionHandler cur_start_color;
RexxFunctionHandler cur_has_colors;
RexxFunctionHandler cur_has_acs;
RexxFunctionHandler cur_init_pair;

typedef struct cur_window *winptr ;
typedef struct cur_window 
{
   WINDOW *win ;
   struct cur_window *prev, *next ;
} cur_window_type ;

winptr first=NULL, last=NULL ;

typedef struct 
{
   PSZ function_name;
   PFN entrypoint;
} RexxFunction;

/*-----------------------------------------------------------------------------
 * Table of CURSES Functions. Used to install/de-install functions.
 *----------------------------------------------------------------------------*/
static RexxFunction RexxCursesFunctions[] = {
   { "cur_addch",        cur_addch    },
   { "cur_waddch",       cur_waddch   },
   { "cur_addstr",       cur_addstr   },
   { "cur_waddstr",      cur_waddstr  },
   { "cur_box",          cur_box      },
   { "cur_clear",        cur_clear    },
   { "cur_cbreak",       cur_cbreak   },
   { "cur_nocbreak",     cur_nocbreak },
   { "cur_clearok",      cur_clearok  },
   { "cur_clrtobot",     cur_clrtobot },
   { "cur_clrtoeol",     cur_clrtoeol },
   { "cur_wclrtobot",    cur_wclrtobot},
   { "cur_wclrtoeol",    cur_wclrtoeol},
   { "cur_crmode",       cur_crmode   },
   { "cur_curs_set",     cur_curs_set },
   { "cur_delch",        cur_delch    },
   { "cur_mvdelch",      cur_mvdelch  },
   { "cur_wdelch",       cur_wdelch   },
   { "cur_mvwdelch",     cur_mvwdelch },
   { "cur_deleteln",     cur_deleteln },
   { "cur_delwin",       cur_delwin   },
   { "cur_echo",         cur_echo     },
   { "cur_endwin",       cur_endwin   },
   { "cur_erase",        cur_erase    },
   { "cur_getch",        cur_getch    },
   { "cur_wgetch",       cur_wgetch   },
   { "cur_getstr",       cur_getstr   },
   { "cur_getyx",        cur_getyx    },
   { "cur_inch",         cur_inch     },
   { "cur_initscr",      cur_initscr  },
   { "cur_insch",        cur_insch    },
   { "cur_insertln",     cur_insertln },
   { "cur_keypad",       cur_keypad   },
   { "cur_move",         cur_move     },
   { "cur_wmove",        cur_wmove    },
   { "cur_newwin",       cur_newwin   },
   { "cur_nl",           cur_nl       },
   { "cur_napms",        cur_napms    },
   { "cur_nocrmode",     cur_nocrmode },
   { "cur_noecho",       cur_noecho   },
   { "cur_noraw",        cur_noraw    },
   { "cur_printw",       cur_printw   },
   { "cur_raw",          cur_raw      },
   { "cur_refresh",      cur_refresh  },
   { "cur_wrefresh",     cur_wrefresh },
   { "cur_scanw",        cur_scanw    },
   { "cur_standend",     cur_standend },
   { "cur_standout",     cur_standout },
   { "cur_attrset",      cur_attrset  },
   { "cur_wattrset",     cur_wattrset },
   { "cur_has_colors",   cur_has_colors  },
   { "cur_has_acs",      cur_has_acs     },
   { "cur_start_color",  cur_start_color },
   { "cur_init_pair",    cur_init_pair   },
   { NULL, NULL }
};

typedef struct 
{
   char *name;
   long number;
} String2Number;

#ifdef A_COLOR

static String2Number ColorName[] =
{
   { "COLOR_BLACK",   COLOR_BLACK   },
   { "COLOR_BLUE",    COLOR_BLUE    },
   { "COLOR_RED",     COLOR_RED     },
   { "COLOR_CYAN",    COLOR_CYAN    },
   { "COLOR_MAGENTA", COLOR_MAGENTA },
   { "COLOR_GREEN",   COLOR_GREEN   },
   { "COLOR_YELLOW",  COLOR_YELLOW  },
   { "COLOR_WHITE",   COLOR_WHITE   },
   { NULL, 0 }
};
#endif

static String2Number AttrName[] =
{
   { "A_NORMAL",      A_NORMAL      },
   { "A_STANDOUT",    A_STANDOUT    },
   { "A_BOLD",        A_BOLD        },
   { "A_UNDERLINE",   A_UNDERLINE   },
   { "A_REVERSE",     A_REVERSE     },
#ifdef A_BLINK
   { "A_BLINK",       A_BLINK       },
#endif
#ifdef A_DIM
   { "A_DIM",         A_DIM         },
#endif
#ifdef A_INVIS
   { "A_INVIS",       A_INVIS       },
#endif
#ifdef A_PROTECT
   { "A_PROTECT",     A_PROTECT     },
#endif
   { NULL, 0 }
};



#ifndef HAVE_KEYNAME
char *mykeyname
    (int key)
{
   register int i=0;
    
   for (i = 0 ; ; i++ )
   {
      if (RexxKeyNames[i].keyname == NULL)
         return("NO NAME");
      if (RexxKeyNames[i].keynumber == key)
         return(RexxKeyNames[i].keyname);
   }
   return("NO NAME");
}
#endif

static int my_logger(char *msg)
{
 FILE *fp=NULL;

 fp = fopen("logger","a");
 fprintf(fp,"%s",msg);
 fclose(fp);
 return(0);
}

static int my_checkparam(int argc, int mini, int maxi)
{
 if (argc < mini
 ||  argc > maxi)
   return 1;
 else
   return 0;
}

static int my_nullstringptr(RXSTRING *retstr)
{
    strcpy(retstr->strptr,"");
    retstr->strlength = 0;
    return(0);
}

static int my_return_int(RXSTRING *retstr, long num)
{
    sprintf(retstr->strptr,"%ld",num);
    retstr->strlength = strlen(retstr->strptr);
    return(0);
}

static int my_return_ok(RXSTRING *retstr)
{
    strcpy( retstr->strptr, "OK" );
    retstr->strlength = 2;
    return(0);
}

static int my_return_err(RXSTRING *retstr)
{
    strcpy( retstr->strptr, "ERR" );
    retstr->strlength = 3;
    return(0);
}

static int my_return_bool(RXSTRING *retstr, bool num)
{
    if (num)
       strcpy( retstr->strptr, "1" );
    else
       strcpy( retstr->strptr, "0" );
    retstr->strlength = 1;
    return(0);
}

#ifdef A_ALTCHARSET
static long acs_to_number( char *str)
{
   /*
    * This code is horrible, but because of the way most acs character
    * sets are defined, this is the only way.
    */
#ifdef ACS_BLOCK
   if ( strcmp( "ACS_BLOCK", str ) == 0 ) return ( ACS_BLOCK );
#endif
#ifdef ACS_DIAMOND
   if ( strcmp( "ACS_DIAMOND", str ) == 0 ) return ( ACS_DIAMOND );
#endif
#ifdef ACS_CKBOARD
   if ( strcmp( "ACS_CKBOARD", str ) == 0 ) return ( ACS_CKBOARD );
#endif
   return(0);
}
#endif


#ifdef A_COLOR
static int color_to_number(char *str)
{
   register int i = 0;

   for (i=0; ColorName[i].name != NULL; i++ )
   {
      if (strcmp(str,ColorName[i].name) == 0)
         return (int)ColorName[i].number;
   }
   return (-1);
}

static long color_pair_to_number(char *str)
{
   int num = 0;
   int len = strlen( str );

   if (len < 13 )
      return(-1);
   if ( strncmp( str,"COLOR_PAIR(", 11 ) != 0 )
      return(-1);
   if ( str[len-1] != ')' )
      return(-1);
   str[len-1] = '\0';
   if (( num = atoi( str+11 )) == 0 )
      return(-1);

   return COLOR_PAIR( num );
}
#endif

static long attr_to_number(char *str)
{  
   register int i = 0;

   for (i=0; AttrName[i].name != NULL; i++ )
   {
      if (strcmp(str,AttrName[i].name) == 0)
         return AttrName[i].number;
   }
   return (-1);
}

static long get_attr(ULONG argc, RXSTRING argv[], int start, int end )
{
   register int i = 0;
   long tmp = 0;
   long attr = 0;

   for (i = start; i < end ; i++)
   {
      if ( argv[i].strlength == 0 )
         break;
      argv[i].strptr[argv[i].strlength] = '\0';
      if (( tmp = attr_to_number( argv[i].strptr )) == (-1) )
      {
#ifdef A_COLOR
         if (( tmp = color_pair_to_number ( argv[i].strptr )) == (-1))
            return(-1);
         else
            attr |= tmp;
#else
         return(-1);
#endif
      }
      else
         attr |= tmp;
   }
   return attr;
}


static char *make_upper(char *str)
{
 char *save_str=str;
 while(*str)
   {
    if (islower(*str))
       *str = toupper(*str);
    ++str;
   }
 return(save_str);
}

static int short set_rexx_variable(char *name,char *value,int value_length)
{
 SHVBLOCK shv;
 int rc=0;

 shv.shvnext=NULL;                                   /* only one block */
#if defined(USE_REGINA)
 shv.shvcode=RXSHV_SYSET; /* for Regina (no direct set) use symbolic set */
#else
 shv.shvcode=RXSHV_SET;               /* ... for others use direct set */
#endif
/*---------------------------------------------------------------------*/
/* Now (attempt to) set the REXX variable                              */
/* Add name/value to SHVBLOCK                                          */
/*---------------------------------------------------------------------*/
 MAKERXSTRING(shv.shvname, name, strlen(name));
 MAKERXSTRING(shv.shvvalue,value,value_length);
/*---------------------------------------------------------------------*/
/* One or both of these is needed, too <sigh>                          */
/*---------------------------------------------------------------------*/
 shv.shvnamelen=strlen(name);
 shv.shvvaluelen=value_length;

 rc = RexxVariablePool(&shv);                 /* Set the REXX variable */
 if (rc != RXSHV_OK 
 &&  rc != RXSHV_NEWV)
   return(1);
 else
   return(0);
}

static WINDOW *getwindow( long index )
{
   winptr ptr ;
   
   for (ptr=first; ptr; ptr=ptr->next )
      if ((long)ptr->win == index)
         break ;

   if (!ptr)
   {
/*      fprintf( stderr, "Curses: Unknown window name: %s\n", name->value) ; */
      return NULL ;
   }
   return ptr->win ;
}


static void dropwindows()
{
   winptr ptr=first, nptr=first ;
 
   while(ptr)
   {
      nptr = ptr->next ;
      free( ptr ) ;
      ptr = nptr;
      if (!ptr)
         break;
   }
}

static void delwindow( long index )
{
   winptr ptr=first, nptr=first ;

   for (ptr=first; ptr; ptr=ptr->next )
   {
      if ((long)ptr->win == index)
      {
         if (ptr == first)
         {
            if (ptr == last)
            {
               first = last = NULL;
               free( ptr );
               return;
            }
            first = ptr->next;
            first->prev = NULL;
            free (ptr );
            return;
         }
         else if (ptr == last)
         {
            last = ptr->prev;
            last->next = NULL;
            free( ptr );
            return;
         }
         else
         {
            nptr = ptr;
            ptr->prev->next = ptr->next;
            ptr->next->prev = ptr->prev;
            free( nptr );
            return;
         }
      }
      break ;
   }
}

#if OLD
static void addwindow( WINDOW *win, char *name )
#else
static void addwindow( WINDOW *win )
#endif
{
   winptr ptr ;

   ptr = malloc( sizeof(struct cur_window) ) ;
#if OLD
   ptr->name.strptr = (char *)malloc(strlen(name)+1);
   strcpy(ptr->name.strptr,name) ;
#endif
   ptr->win = win ;
   ptr->next = NULL ;
   ptr->prev = last ;

   if (last)
      ptr->prev->next = last = ptr ;

   if (!first)
      first = last = ptr ;
}


/* here */
/*====== Here come the real interface functions to curses ======*/

/*====== Initiate and terminate ================================*/

APIRET APIENTRY cur_initscr
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{ 
   char buf[50];

   if (my_checkparam(argc, 0, 0 ) ) return(1);
   initscr() ;
   sprintf(buf,"%d",LINES);
   if (set_rexx_variable("LINES",buf,strlen(buf))) return(1);
   sprintf(buf,"%d",COLS);
   if (set_rexx_variable("COLS",buf,strlen(buf))) return(1);
#ifdef A_COLOR
   if ( has_colors() )
   {
     sprintf(buf,"%d",COLORS);
     if (set_rexx_variable("COLORS",buf,strlen(buf))) return(1);
     sprintf(buf,"%d",COLOR_PAIRS);
     if (set_rexx_variable("COLOR_PAIRS",buf,strlen(buf))) return(1);
   }
#endif

   addwindow( stdscr ) ;
   addwindow( curscr ) ;
   sprintf(buf,"%ld",(long)stdscr);
   if (set_rexx_variable("STDSCR",buf,strlen(buf))) return(1);
   sprintf(buf,"%ld",(long)curscr);
   if (set_rexx_variable("CURSCR",buf,strlen(buf))) return(1);
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_endwin
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   endwin() ;
   dropwindows() ;
#if defined(XCURSES)
   XCursesExit();
#endif
   return my_nullstringptr(retstr) ;
}


/*====== Cursor movements ======================================*/
   
APIRET APIENTRY cur_move
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int x, y ;

   if (my_checkparam(argc, 2, 2 ) ) return(1);
   argv[0].strptr[argv[0].strlength] = '\0';
   argv[1].strptr[argv[1].strlength] = '\0';
   y = atoi( argv[0].strptr ) ;
   x = atoi( argv[1].strptr ) ;
   move( y, x ) ;
   return my_nullstringptr(retstr) ;
}
   
APIRET APIENTRY cur_wmove
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int x, y ;

   if (my_checkparam(argc, 3, 3 ) ) return(1);
   argv[1].strptr[argv[1].strlength] = '\0';
   argv[2].strptr[argv[2].strlength] = '\0';
   y = atoi( argv[1].strptr ) ;
   x = atoi( argv[2].strptr ) ;
   pwin = getwindow( atol(argv[0].strptr) ) ;
   wmove( pwin, y, x ) ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_getyx 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int x, y ;

   if (my_checkparam(argc, 3, 3 )  ) return(1);
#if OLD
   pwin = getwindow( argv[0].strptr ) ;
#else
   pwin = getwindow( atol(argv[0].strptr) ) ;
#endif

   getyx( pwin, y, x ) ;
   sprintf( retstr->strptr, "%d %d", y, x ) ;
   retstr->strlength = strlen( retstr->strptr ) ;
   
   return(0) ;
}


APIRET APIENTRY cur_inch 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{

   if (my_checkparam(argc, 0, 0 ) ) return(1);
   retstr->strptr[0] = inch() ;
   retstr->strlength = 1 ;

   return (0);
}

   
APIRET APIENTRY cur_napms
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int ms ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   argv[0].strptr[argv[0].strlength] = '\0';
   ms = atoi( argv[0].strptr ) ;
#ifdef HAVE_NAPMS
   napms( ms ) ;
#endif
   return my_nullstringptr(retstr) ;
}

   
APIRET APIENTRY cur_curs_set
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int flag ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   argv[0].strptr[argv[0].strlength] = '\0';
   flag = atoi( argv[0].strptr ) ;
#ifdef HAVE_CURS_SET
   curs_set( flag ) ;
#endif
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_leaveok 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int flag ;

   if (my_checkparam(argc, 2, 2 ) ) return(1);

   pwin = getwindow( atol(argv[0].strptr) ) ;
   flag = atoi( argv[1].strptr ) ;
   if (flag>1)
      return(1);

   leaveok( pwin, flag ) ;
   return my_nullstringptr(retstr) ;
}   
   


APIRET APIENTRY cur_addch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   long attr = 0;
   long ch = 0;

   if (my_checkparam(argc, 1, 6 ) ) return(1);
   if (( attr = get_attr( argc, argv, 1, argc )) == (-1) )
      return(1);
#ifdef A_ALTCHARSET
   argv[0].strptr[argv[0].strlength] = '\0';
   if (argv[0].strlength == 1)
      ch = argv[0].strptr[0] ;
   else
   {
      if (( ch = acs_to_number( argv[0].strptr )) == 0)
         return(1);
   }
#else
   ch = argv[0].strptr[0] ;
#endif
   addch( ch | attr ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_waddch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   long attr = 0;
   long ch = 0;

   if (my_checkparam(argc, 2, 7 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   if (( attr = get_attr( argc, argv, 2, argc )) == (-1) )
      return(1);
#ifdef A_ALTCHARSET
   argv[1].strptr[argv[1].strlength] = '\0';
   if (argv[1].strlength == 1)
      ch = argv[1].strptr[0] ;
   else
   {
      if (( ch = acs_to_number( argv[1].strptr )) == 0)
         return(1);
   }
#else
   ch = argv[1].strptr[0] ;
#endif
   waddch( pwin, ch | attr ) ;
   return my_nullstringptr(retstr) ;
}
 

APIRET APIENTRY cur_addstr
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 1, 1 ) ) return(1);  

   argv[0].strptr[argv[0].strlength] = '\0';
   addstr( argv[0].strptr ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_waddstr
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;

   if (my_checkparam(argc, 2, 2 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;

   argv[1].strptr[argv[1].strlength] = '\0';
   waddstr( pwin, argv[1].strptr ) ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_printw 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_insch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 1, 1 ) ) return(1);
   insch( argv[0].strptr[0]) ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_insertln
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   insertln() ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_box
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   char hor=0, vert=0 ;

   if (my_checkparam(argc, 1, 3 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   switch(argc)
   {
      case 3:
         if (argv[2].strlength > 1) return(1);
         if (argv[2].strlength == 1)
            hor = argv[2].strptr[0];
         /* fall through */
      case 2:
         if (argv[1].strlength > 1) return(1);
         if (argv[1].strlength == 1)
            vert = argv[1].strptr[0];
         break;
      default:
         break;
   }

   box( pwin, vert, hor ) ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_refresh
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   refresh() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_wrefresh
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
 
   if (my_checkparam(argc, 1, 1 ) ) return(1);

   pwin = getwindow( atol(argv[0].strptr) ) ;
   wrefresh( pwin ) ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_keypad
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int flag = 0;
   WINDOW *pwin ;

   if (my_checkparam(argc, 2, 2 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   flag = atoi( argv[1].strptr );
   if ( flag != 0 &&  flag != 1 ) return(1);
#ifdef HAVE_KEYPAD
   keypad( pwin, flag );
#endif
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_getch 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int key = 0;

   if (my_checkparam(argc, 0, 0 ) ) return(1);
   key = getch();
#ifdef KEY_MIN
   if (key >= KEY_MIN)
#else
   if (key >= 256)
#endif
   {
#ifdef HAVE_KEYNAME
      retstr->strptr = keyname( key );
#else
      retstr->strptr = mykeyname( key );
#endif
      retstr->strlength = strlen( retstr->strptr );
   }
   else
   {
      retstr->strptr[0] = key;
      retstr->strlength = 1 ;
   }
   return (0);
}


APIRET APIENTRY cur_wgetch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int key = 0;
   WINDOW *pwin ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   key = wgetch(pwin);
#ifdef KEY_MIN
   if (key >= KEY_MIN)
#else
   if (key >= 256)
#endif
   {
#ifdef HAVE_KEYNAME
      retstr->strptr = keyname( key );
#else
      retstr->strptr = mykeyname( key );
#endif
      retstr->strlength = strlen( retstr->strptr );
   }
   else
   {
      retstr->strptr[0] = key;
      retstr->strlength = 1 ;
   }
   return (0);
}


APIRET APIENTRY cur_getstr 
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int i ;

   if (my_checkparam(argc, 0, 0 ) ) return(1);
   i = getstr(retstr->strptr);
   retstr->strlength = i;
   return (0);
}


APIRET APIENTRY cur_scanw
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_crmode
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
#if defined(XCURSES)
#else
   crmode() ;
#endif
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_nocrmode
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
#if defined(XCURSES)
#else
   nocrmode() ;
#endif
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_cbreak
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   cbreak();
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_nocbreak
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   nocbreak();
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_raw
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   raw() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_noraw
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   noraw() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_echo
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   echo() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_noecho
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   noecho() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_nl
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   nl() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_nonl
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   nl() ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_delch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   delch() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_mvdelch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int y, x;

   if (my_checkparam(argc, 2, 2 ) ) return(1);
   y = atoi( argv[0].strptr ) ;
   x = atoi( argv[1].strptr ) ;
   mvdelch( y, x ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_wdelch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   wdelch( pwin ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_mvwdelch
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int y, x;

   if (my_checkparam(argc, 3, 3 ) ) return(1);
   y = atoi( argv[0].strptr ) ;
   x = atoi( argv[1].strptr ) ;
   pwin = getwindow( atol(argv[2].strptr) ) ;
   mvwdelch( pwin, y, x ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_deleteln
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   deleteln() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_wdeleteln
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   wdeleteln( pwin ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_clrtoeol
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   clrtoeol() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_wclrtoeol
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   wclrtoeol( pwin ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_clrtobot
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   clrtobot() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_wclrtobot
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;

   if (my_checkparam(argc, 0, 0 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   wclrtobot( pwin ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_erase
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   erase() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_clearok
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int flag ;
 
   if (my_checkparam(argc, 2, 2 ) ) return(1);

   pwin = getwindow( atol(argv[0].strptr) ) ;
   if (argv[1].strlength != 1)
      return(1);
   flag = atoi( argv[1].strptr);
   if (flag>1)
      return(1);

   clearok( pwin, flag ) ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_clear
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   clear() ;
   return my_nullstringptr(retstr) ;
}

/*====== Routines for handling attributes ======*/

APIRET APIENTRY cur_standout
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   standout() ;
   return my_nullstringptr(retstr) ;
}


APIRET APIENTRY cur_standend
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
   standend() ;
   return my_nullstringptr(retstr) ;
}

APIRET APIENTRY cur_attrset
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   long attr = 0;

   if (my_checkparam(argc, 1, 5 ) ) return(1);
   if (( attr = get_attr( argc, argv, 0, argc )) == (-1) )
      return(1);
   attrset( attr );
   return my_return_ok(retstr) ;
}

APIRET APIENTRY cur_wattrset
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   long attr = 0;

   if (my_checkparam(argc, 2, 6 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   if (( attr = get_attr( argc, argv, 1, argc )) == (-1) )
      return(1);
   wattrset( pwin, attr );
   return my_return_ok(retstr) ;
}

APIRET APIENTRY cur_attron
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   long attr = 0;

   if (my_checkparam(argc, 1, 5 ) ) return(1);
   if (( attr = get_attr( argc, argv, 0, argc )) == (-1) )
      return(1);
   attron( attr );
   return my_return_ok(retstr) ;
}

APIRET APIENTRY cur_wattron
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   long attr = 0;

   if (my_checkparam(argc, 2, 6 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   if (( attr = get_attr( argc, argv, 1, argc )) == (-1) )
      return(1);
   wattron( pwin, attr );
   return my_return_ok(retstr) ;
}

APIRET APIENTRY cur_attroff
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   long attr = 0;

   if (my_checkparam(argc, 1, 5 ) ) return(1);
   if (( attr = get_attr( argc, argv, 0, argc )) == (-1) )
      return(1);
   attroff( attr );
   return my_return_ok(retstr) ;
}

APIRET APIENTRY cur_wattroff
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   long attr = 0;

   if (my_checkparam(argc, 2, 6 ) ) return(1);
   pwin = getwindow( atol(argv[0].strptr) ) ;
   if (( attr = get_attr( argc, argv, 1, argc )) == (-1) )
      return(1);
   wattroff( pwin, attr );
   return my_return_ok(retstr) ;
}


APIRET APIENTRY cur_has_acs
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int acschars = 0;

   if (my_checkparam(argc, 0, 0 ) ) return(1);
#ifdef ACS_BLOCK
   acschars++;
#endif
#ifdef ACS_DIAMOND
   acschars++;
#endif
#ifdef ACS_CKBOARD
   acschars++;
#endif

   if (acschars)
      return my_return_bool( retstr, TRUE ) ;
   else
      return my_return_bool( retstr, FALSE ) ;
}


APIRET APIENTRY cur_has_colors
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
#ifdef A_COLOR
   if (has_colors())
      return my_return_bool( retstr, TRUE ) ;
   return my_return_bool( retstr, FALSE ) ;
#else
   return my_return_bool( retstr, FALSE ) ;
#endif
}


APIRET APIENTRY cur_start_color
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   if (my_checkparam(argc, 0, 0 ) ) return(1);
#ifdef A_COLOR
   if (has_colors())
   {
      start_color();
      return my_return_ok( retstr ) ;
   }
   return my_return_err( retstr ) ;
#else
   return my_return_err( retstr ) ;
#endif
}


APIRET APIENTRY cur_init_pair
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   int pairnum, fore, back;

   if (my_checkparam(argc, 3, 3 ) ) return(1);
#ifdef A_COLOR
   if (has_colors())
   {
      if ((fore = color_to_number( argv[1].strptr )) == -1 ) return(1);
      if ((back = color_to_number( argv[2].strptr )) == -1 ) return(1);
      if ((pairnum = atoi( argv[0].strptr )) == 0 ) return(1);
      init_pair( pairnum, fore, back );
      return my_return_ok( retstr ) ;
   }
   return my_return_err( retstr ) ;
#else
   return my_return_err( retstr ) ;
#endif
}



/*====== Routines for handling new windows ======*/

APIRET APIENTRY cur_newwin
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int lines, cols, begy, begx;

   if (my_checkparam(argc, 4, 4 ) ) return(1);
   lines = atoi( argv[0].strptr );
   cols  = atoi( argv[1].strptr );
   begy  = atoi( argv[2].strptr );
   begx  = atoi( argv[3].strptr );
   pwin = newwin(lines, cols, begy, begx );
   if (pwin)
   {
      addwindow( pwin );
      return my_return_int( retstr, (long)pwin );
   }
   return my_nullstringptr( retstr ) ;
}

APIRET APIENTRY cur_delwin
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
   WINDOW *pwin ;
   int lines, cols, begy, begx;
   long index;

   if (my_checkparam(argc, 1, 1 ) ) return(1);
   index =  atol(argv[0].strptr)  ;
   pwin = getwindow( index ) ;
   delwin( pwin );
   delwindow( index );
   return my_nullstringptr(retstr) ;
}

/*====== Routines for handling registration of functions ======*/


APIRET APIENTRY CurLoadFuncs
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 RexxFunction *func=NULL;
 ULONG rc=0L;

    
 /* Register all curses functions */
 for (func = RexxCursesFunctions; func->function_name; func++)
   {
    rc = RexxRegisterFunctionDll(func->function_name,DLLNAME,func->function_name);
   }
 return 0;
}

APIRET APIENTRY CurDropFuncs
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 int rc=0;
 RexxFunction  *func=NULL;
    
 /* DeRegister all curses functions */
 for (func = RexxCursesFunctions; func->function_name; func++)
   {
    rc = RexxDeregisterFunction(func->function_name);
   }
 strcpy(retstr->strptr,"return from sqldropfuncs");
 retstr->strlength = strlen(retstr->strptr);
 return(rc);
}
