#
# rules.mk:  1998 03 07
#
# Copyright (C) 1998 by Avery Pennarun <apenwarr@worldvisions.ca>.
#   Use, distribute, modify, and redistribute freely.  (But if you're nice,
#   you'll send all your changes back to me.)
#
# This is a complicated-looking set of Makefile rules that should make your
# own Makefiles simpler, by providing for several useful features (like
# autodependencies and a 'clean' target) without any extra effort.
#
# It will only work with GNU make.
#

STRIP=strip --remove-section=.note --remove-section=.comment

#
# Define DEBUG flag if not already set.
#
ifeq ($(DEBUG),)
DEBUG=1
endif

#
# Point to the electric fence library, assuming DEBUG=1.
#
ifeq ($(DEBUG),1)
EFENCE=-lefence
else
EFENCE=
endif

#
# C compilation flags (depends on DEBUG setting)
#
CFLAGS=-Wall -D_BSD_SOURCE -D_GNU_SOURCE
ifeq ($(DEBUG),1)
CFLAGS+=-g -Wall -DDEBUG=1
CXXFLAGS+=
LDFLAGS+=-g
else
CFLAGS+=-O6 -fomit-frame-pointer -DDEBUG=0 -DNDEBUG
#CXXFLAGS+=-fno-implement-inlines  # causes trouble with egcs
LDFLAGS+=-s
endif


# we need a default rule, since the 'include' below causes trouble
default: all

# any rule that depends on FORCE will always run
.PHONY: FORCE
FORCE:

%.gz: FORCE %
	@rm -f $@
	gzip -f $*
	@ls -l $@

INCDIRS = $(addprefix -I,$(subst :, ,$(VPATH)))

#
# Automatically generate header dependencies for .c and .cc files.  The
# dependencies are stored as ".filename.d"
#
define mkdepend
	@echo "(autodepend $<)"
	@-set +e; $(CC) -MM $(CPPFLAGS) $(INCDIRS) $< \
		| sed 's/\($*\)\.o[ :]*/\1.o $@: /g' >$@
endef
.%.d: %.c
	$(mkdepend)
.%.d: %.cc
	$(mkdepend)
rules_mk_sf = $(wildcard *.c) $(wildcard *.cc)
ifneq ($(strip $(rules_mk_sf)),)
-include $(addprefix .,$(addsuffix .d,$(basename $(rules_mk_sf))))
endif


#
# Typical compilation rules.
#
override _R_CFLAGS=$(CPPFLAGS) $(CFLAGS) $(INCDIRS)
override _R_CXXFLAGS=$(CPPFLAGS) $(CFLAGS) $(CXXFLAGS) $(INCDIRS)
export _R_CFLAGS
export _R_CXXFLAGS
%.o: %.c
	$(CC) $$_R_CFLAGS -c $<

%.o: %.cc
	$(CXX) $$_R_CXXFLAGS -c $<
	
%.a:
	rm -f $@
	ar q $@ $^
	ranlib $@

%: %.o
	$(CC) $(LDFLAGS) -o $@ $^ $(LIBS) $($*-LIBS)

#
# A macro for compiling subdirectories listed in the SUBDIRS variable.
# Tries to make the target ($@) in each subdir, unless the target is called
# "subdirs" in which case it makes "all" in each subdir.
#
define subdirs
	@OLDDIR="$$PWD"; set -e; \
	for d in __fx__ ${SUBDIRS}; do \
		if [ "$$d" = "__fx__" ]; then continue; fi; \
		cd "$$d"; \
		echo ; \
		echo "--> Making $(subst subdirs,all,$@) in $$PWD..."; \
		${MAKE} --no-print-directory $(subst subdirs,all,$@); \
		cd "$$OLDDIR"; \
	done
	@echo
	@echo "--> Back in $$PWD..."
endef

subdirs:
	$(subdirs)


#
# Auto-clean rule.  Feel free to append to this in your own directory, by
# defining your own "clean" rule.
#
clean: FORCE cleanrule

cleanrule: FORCE
	rm -f *~ *.o *.a .*.d

#
# Make 'tags' file using the ctags program - useful for editing
#
tags: $(shell find -name '*.cc' -o -name '*.[ch]')
	@echo '(creating "tags")'
	@if [ -x /usr/bin/ctags ]; then /usr/bin/ctags $^; fi
