#!/usr/bin/perl -w

use strict;
use File::Find;

my $basedir;
my @md5sums;

($basedir) = @ARGV;

chdir $basedir;

if (-f "indices/md5sums") {
  open(MD5SUMS,"indices/md5sums") or
    die "can't read from indices/md5sums : $!\n";
} elsif (-f "indices/md5sums.gz") {
  open(MD5SUMS, "zcat indices/md5sums.gz|") or
    die "can't read from indices/md5sums.gz : $!\n";
} else {
  die "neither indices/md5sums nor indices/md5sums.gz found\n" ;
}

while (<MD5SUMS>) {
	my $file;
	my $md5;
	chop;
	next if ($_ =~ /  \.\/bo/);
	next if ($_ =~ /  \.\/contrib\//);
	next if ($_ =~ /  \.\/non-free\//);
	next if ($_ =~ /  \.\/dists\/slink\//);
	next if ($_ =~ /  \.\/Debian-1.3/);
	next if ($_ =~ /\/binary-alpha\//);
	next if ($_ =~ /\/binary-sparc\//);
	next if ($_ =~ /\/binary-powerpc\//);
	next if ($_ =~ /\/disks-alpha\//);
	next if ($_ =~ /\/disks-sparc\//);
	next if ($_ =~ /\/disks-powerpc\//);
	($md5, $file) = /(.*)  (.*)/;
	if (-f $file) {
		my $is_md5;
		my $line;
		$line = `md5sum $file`;
		chop $line;
		($is_md5) = $line =~ /(.*)  .*/;
		if ($md5 ne $is_md5) {
			print "mismatch: $file $md5 $is_md5 !\n";
		}
	} else {
		print "no such file: $file !\n";
	}
		
	push @md5sums, $file;
}
close(MD5SUMS);

# reverse check for unwanted files not implemented
#find(&checkdir,'.');

exit 0;
