// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include "Canvas.h"
#include "DownloadRenderer.h"
#include "FormRenderer.h"
#include "GifDecoder.h"
#include "ImageRenderer.h"
#include "Request.h"

ImageRenderer::ImageRenderer( QString     src,
                              int         width,
                              int         height,
                              bool        ismap,
                              bool        isSubmit,
                              QString     url,
                              Canvas*     canvas,
                              int         clipWidth,
                              QObject*    parent,
                              const char* name )
        : FormObjectRenderer( canvas, clipWidth, parent, name ),
          _src( src.copy() ),
          _ismap( ismap ),
          _url( url ),
          _x( 0 ),
          _y( 0 ),
          _isSubmit( isSubmit ),
          _decoder( 0 )
{
    if ( ( width >= 0 ) && ( height >= 0 ) ) {
        resize( width, height );
        _minimumWidth = width;
        _maximumWidth = width;
    }

    if ( url.length() ) {
        canvas->registerMouseZone( this, url );
    }

    if ( src.length() ) {
        Request* req = new Request( Url( &canvas->baseUrl(), src ), canvas );
        connect( req, SIGNAL( status( QString ) ), canvas, SLOT( status( QString ) ) );
        connect( req, SIGNAL( startOfData( Request*, QString, QString, int ) ), this, SLOT( startOfData( Request*, QString, QString, int ) ) );
        if ( !req->open() ) {
            delete req;
        }
    }
}

ImageRenderer::~ImageRenderer()
{
    delete _decoder;
}

QString ImageRenderer::value()
{
    QString nm = name();

    if ( nm.length() == 0 ) {
        return "";
    }

    Url::encode( nm );

    QString tmp;
    tmp.sprintf( "%s.x=%d&%s.y=%d", nm.data(), _x, nm.data(), _y );
    return tmp;
}

void ImageRenderer::reset()
{
}

bool ImageRenderer::redraw()
{
    // Do I need to do anything?
    if ( !_needRedraw ) return FALSE;
    
    _minimumWidth = width();
    _maximumWidth = width();

    _needRedraw = FALSE;

    return TRUE;
}

void ImageRenderer::repaint( QPainter& p, const Rect& )
{
    if ( _decoder ) {
        p.drawPixmap( x(), y(), _decoder->pixmap() );
    } else {
        p.setPen( QColor( "black" ) );
        p.drawRect( x(), y(), width(), height() );
    }
}

void ImageRenderer::startOfData( Request* req, QString mediaType, QString mediaSubtype, int )
{
    if ( mediaType == "image" ) {
        if ( mediaSubtype == "gif" ) {
            _decoder = new GifDecoder( this );
            connect( req, SIGNAL( data( const char*, int ) ), _decoder, SLOT( data( const char*, int ) ) );
            connect( req, SIGNAL( endOfData() )             , _decoder, SLOT( endOfData() ) );
            return;
        }
    }

    req->abort();
}
