// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _DownloadRenderer_h_
#define _DownloadRenderer_h_

extern "C"
{
#include <stdio.h>
}
#include <qwidget.h>
#include "Url.h"

class ProgressBar;
class QFrame;
class QLabel;
class QPushButton;
class Request;
class TransferLogo;

//: The DownloadRenderer class provides a dialog for saving a remote URL to a local file.
//. The dialog shows the remote source and local destination, an animated
//. transfer icon, and a progress bar.  The transfer can be aborted at any time
//. if the user presses the "Stop" button.
class DownloadRenderer : public QWidget {
    Q_OBJECT
    QLabel*       _remoteLabel;
    QLabel*       _remoteValue;
    QLabel*       _localLabel;
    QLabel*       _localValue;
    TransferLogo* _logo;
    ProgressBar*  _progress;
    QPushButton*  _stop;
    QFrame*       _separator;
    QLabel*       _status;
    Request*      _request;
    FILE*         _fp;
    int           _totalSize;
    int           _totalRead;
protected:
    void resizeEvent( QResizeEvent* e );
public:
    //. Popup a QFileDlg to get a local file name, and create a request for the
    //. remote URL.
    DownloadRenderer( const Url& remote );
public slots:
    void startOfData( Request* req, QString mediaType, QString mediaSubtype, int totalSize );
    void data( const char* bytes, int length );
    void endOfData();
    void status( QString msg );
    void urlChanged( const Url& url );
};

#endif
