// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ConsoleWindow_h_
#define _ConsoleWindow_h_

#include <qwidget.h>

class QComboBox;
class QLabel;
class QMultiLineEdit;
class QPushButton;

class ConsoleWindow : public QWidget {
    Q_OBJECT
    QLabel*         _debugLevelLabel;
    QComboBox*      _debugLevelCombo;
    QMultiLineEdit* _mle;
    QPushButton*    _dismiss;
    enum { Debug=0, Warning=1 };
protected:
    void resizeEvent( QResizeEvent* e );
public:
    ConsoleWindow();

    ~ConsoleWindow();

    void debug( const char* fmt );

    void debug( const char* fmt, const char* arg1 );

    void warning( const char* fmt );

    void warning( const char* fmt, const char* arg1 );

    void warning( const char* fmt, int arg1 );

    void warning( const char* fmt, int arg1, int arg2 );
public slots:
    void dismiss();
};

extern ConsoleWindow* console;

#endif
