/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "prepmx.pas" */


#include "cfuncs.h"


#ifndef STRINGS_H

#endif

#ifndef GLOBALS_H
#include "globals.h"
#endif

#ifndef PREAMBLE_H
#include "preamble.h"
#endif

#ifndef MTX_H
#include "mtx.h"
#endif

#ifndef LYRICS_H
#include "lyrics.h"
#endif

#ifndef ANALYZE_H
#include "analyze.h"
#endif


/** M-Tx preprocessor to PMX     Dirk Laurie */

#define version         "0.30"
#define version_date    "<2 November 1997>"
/** Current bug corrections
- mtxstyle file never actually read
- in nested slur/beam situations, extra begin-melisma
  and erroneous end-melisma
*/
/** Current bugs
- pickup followed by incomplete bar not diagnosed
*/
/** Bugs:
   Comment in preamble generates warning
   Does not check PMX syntax
*/
/** Weaknesses that may later cause bugs:
   Decisions sometimes made on note, sometimes on scan
   Can 'here' overrun?
   Where does one note stop and the next begin?
   Declarations, initializations etc. too scattered
*/
/** Undocumented features:
   Options -D and -p are for the convenience of the development team.
*/
/** To do:
   Allow lyrics paragraph selection anywhere
   Own calculation of height
*/

/* --- This main program contains all procedures that open or close files,
   or do input-output except error messages and reading the style file --- */

#define param_leader    '-'

#define maxfilenamelength  20

#define chord_flat      't'
#define chord_left      'l'

#define indent          "0.12"


static char texdir[256] = "";
static boolean private_pmx = false;

static short infilecount, testin, first_par_PMX_len;
static char infilename[256], outfilename[256], buffer[256];
static boolean eof_infile;
static paragraph first_par_PMX;


static void process_option(char j)
{
  switch (j) {

  case 'b':
    unbeam_if_vocal = false;
    break;

  case 'c':
    dochords = false;
    break;

  case 'd':
    split_dots = true;
    break;

  case 'i':
    ignore = true;
    break;

  case 'l':
    musixlyr = false;
    break;

  case 'm':
    dolyrics = false;
    break;

  case 'n':
    set_names = true;
    break;

  case 'p':
    private_pmx = true;
    break;

  case 't':
    dotext = false;
    break;

  case 'v':
    verbose = 1;
    break;

  case 'x':
    extended_dots = true;
    break;

  case 'D':
    verbose = 2;
    break;

  default:
    putchar(j);
    error(": invalid option");
    break;
  }
}


static void show_options(void)
{
  printf("  Options selected:\n");
  if (!dochords)
    printf("Ignore chord lines (c)\n");
  if (split_dots)
    printf("Use M-Tx 0.12 dot shortcut (d)\n");
  if (ignore)
    printf("Ignore errors (i)\n");
  if (!musixlyr)
    printf("Use M-Tx 0.12 lyrics package (l)\n");
  if (!dolyrics)
    printf("Music only, no lyrics (m)\n");
  if (set_names)
    printf("Set instrument names (n)\n");
  if (private_pmx)
    printf("Use private PMX features (p)\n");
  if (!dotext)
    printf("Ignore uptext lines (t)\n");
  if (verbose == 1)
    printf("Verbose progress report (v)\n");
  else if (verbose == 2)
    printf("Debugging printouts (D)\n");
  if (extended_dots)
    printf("Extended dot positioning syntax (x)\n");
}


/* -------------------------------------------------------------- */

static void OpenFiles(void)
{
  short i, j;
  short fileid = 0;
  char basename[256], param[256];
  short FORLIM1;
  char STR2[256];

  infilecount = 0;
  line_no = 0;
  paragraph_no = 0;
  for (i = 1; i <= P_argc - 1; i++) {
    strcpy(param, P_argv[i]);
    if (param[0] == param_leader) {
      FORLIM1 = strlen(param);
      for (j = 1; j <= FORLIM1 - 1; j++)
	process_option(param[j]);
    } else if (fileid == 0)
      fileid = i;
    else if (*texdir == '\0')
      strcpy(texdir, param);
    else
      strcpy(stylefilename, param);
  }
  if (P_argc < 2) {
    printf("Please type a basename (<9 characters, no dots):\n");
    gets(basename);
  } else
    strcpy(basename, P_argv[fileid]);
  /*  if pos1('.',basename)>0 then fatalerror('No dots allowed in basename');*/
  sprintf(infilename, "%s.mtx", basename);
  sprintf(outfilename, "%s.pmx", basename);
  strcpy(infile_NAME, infilename);
  if (infile != NULL)
    infile = freopen(infile_NAME, "r", infile);
  else
    infile = fopen(infile_NAME, "r");
  _SETIO(infile != NULL, FileNotFound);
  testin = P_ioresult;
  *buffer = '\0';
  strcpy(outfile_NAME, outfilename);
  if (outfile != NULL)
    outfile = freopen(outfile_NAME, "w", outfile);
  else
    outfile = fopen(outfile_NAME, "w");
  _SETIO(outfile != NULL, FileNotFound);
  _SETIO(fprintf(outfile, "---\n") >= 0, FileWriteError);
  strcpy(stylefile_NAME, stylefilename);
  if (stylefile != NULL)
    stylefile = freopen(stylefile_NAME, "r", stylefile);
  else
    stylefile = fopen(stylefile_NAME, "r");
  _SETIO(stylefile != NULL, FileNotFound);
  teststyle = P_ioresult;
  if (testin != 0) {
    sprintf(STR2, "Input file %s not found", infilename);
    fatalerror(STR2);
  }
  printf("Writing to %s.pmx\n", basename);
}


static void CloseFiles(void)
{
  if (outfile != NULL)
    fclose(outfile);
  outfile = NULL;
  if (infile != NULL)
    fclose(infile);
  infile = NULL;
  if (teststyle != 0)
    return;
  if (stylefile != NULL)
    fclose(stylefile);
  stylefile = NULL;
}


static void tex3(char *s)
{
  if (!pmx_preamble_done) {
    fprintf(outfile, "%s\n", s);
    return;
  }
  if (s[0] == '%') {
    fprintf(outfile, "%s\n", s);
    return;
  }
  if (first_paragraph)
    fprintf(outfile, "\\%s\\\n", s);
  else
    fprintf(outfile, "\\\\%s\\\n", s);
}


/* ------------------------------------------------------------- */

static boolean skip_empty_lines(void)
{
  /* TRUE if non-empty line found */
  boolean started = false;
  char *TEMP;

  if (posnot(blank, buffer) == 0)
    *buffer = '\0';
  if (*buffer != '\0')
    return true;
  do {
    eof_infile = P_eof(infile);
    if (*buffer == '\0' && !eof_infile) {
      fgets(buffer, 256, infile);
      TEMP = strchr(buffer, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      infilecount++;
      if (posnot(blank, buffer) == 0)
	*buffer = '\0';
      else
	started = true;
    }
  } while (!(started || eof_infile));
  if (eof_infile)
    *buffer = '\0';
  return started;
}


static void read_paragraph(char (*P)[256], short *no, short *L)
{
  boolean ended;
  char *TEMP;

  *L = 0;
  if (!skip_empty_lines())
    return;
  paragraph_no++;
  do {
    if (*L < lines_in_paragraph) {
      (*L)++;
      strcpy(P[*L - 1], buffer);
      *buffer = '\0';
      no[*L - 1] = infilecount;
    } else {
      line_no = infilecount;
      warning("Paragraph too long: skipping line");
    }
    eof_infile = P_eof(infile);
    if (eof_infile)
      *buffer = '\0';
    else {
      fgets(buffer, 256, infile);
      TEMP = strchr(buffer, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      infilecount++;
    }
    ended = (posnot(blank, buffer) == 0 || eof_infile);
  } while (!ended);
  skip_empty_lines();
/* p2c: prepmx.pas: Note: Eliminated unused assignment statement [338] */
}


/* ------------------------------------------------------------------ */

static void respace(void)
{
  short i, j;
  char STR1[256];
  char STR2[256], STR3[256];

  for (i = ninstr; i >= 2; i--) {
    j = ninstr - i + 1;
    if (nspace[j-1] != unspec) {
      sprintf(STR3, "\\setinterinstrument%s{%s\\Interligne}",
	      strnum(STR1, i - 1), strnum(STR2, nspace[j-1]));
      tex3(STR3);
    }
  }
  if (nspace[nstaves-1] != unspec) {
    sprintf(STR3, "\\staffbotmarg%s\\Interligne",
	    strnum(STR1, nspace[nstaves-1]));
    tex3(STR3);
  }
  must_respace = false;
}


static void init_mod(void)
{
  /* --------------------- Into the heading TeX go:
     (a)  Essential stuff that must be read before \setlyrics
     (b)  Stuff that is the same on every run.
          Everything else goes later. --------------------- */
  fprintf(outfile, "\\immediate\\write10{M-Tx %s (Music from TeXt) %s}\n",
	  version, version_date);
  fprintf(outfile, "\\let\\:=\\relax\\input musixtex\\:\\sepbarrules\n");
  if (!some_vocal)
    return;
  if (musixlyr)
    fprintf(outfile,
      "\\input musixlyr\\:\\enableauxlyrics\\def\\AL{\\auxlyr\\lyr\\nolyr}\n");
  else
    fprintf(outfile,
      "\\input musixcho\\def\\<{\\hskip-1ex\\relax}\\def\\>{\\hskip1ex\\relax}\n");
}


static short clefno(char cl)
{
  short Result;

  switch (cl) {

  case 'G':
  case 't':
  case '0':
    Result = 0;
    break;

  case 's':
  case '1':
    Result = 1;
    break;

  case 'm':
  case '2':
    Result = 2;
    break;

  case 'a':
  case '3':
    Result = 3;
    break;

  case 'n':
  case '4':
    Result = 4;
    break;

  case 'r':
  case '5':
    Result = 5;
    break;

  case 'F':
  case 'b':
  case '6':
    Result = 6;
    break;

  case 'C':
    Result = 3;
    break;

  default:
    warning("Unknown clef code - replaced by treble");
    Result = 0;
    break;
  }
  return Result;
}


static char *sizecode(char *Result, short k)
{
  strcpy(Result, "\\normalvalue");
  switch (k) {

  case 13:
    if (musicsize == 20)
      strcpy(Result, "\\tinyvalue");
    else
      strcpy(Result, "\\smallvalue");
    break;

  case 16:
    if (musicsize == 20)
      strcpy(Result, "\\smallvalue");
    break;

  case 20:
    if (musicsize == 16)
      strcpy(Result, "\\largevalue");
    break;

  case 24:
    if (musicsize == 20)
      strcpy(Result, "\\largevalue");
    else
      strcpy(Result, "\\Largevalue");
    break;

  case 29:
    strcpy(Result, "\\Largevalue");
    break;

  default:
    error("Valid sizes are 13, 16, 20, 24, 29");
    break;
  }
  return Result;
}


static void do_pmx_preamble(void)
{
  static char clefcode[9] = "0123456";
  short i, j;
  char clefs[256];
  char STR1[256], STR2[256];
  short FORLIM;
  line_info *WITH;

  fprintf(outfile, "---\n");
  if (set_names)
    strcpy(fracindent, indent);
  fprintf(outfile, "%d %d %d %d %d %d %8.5f %d %d %d %d %s\n",
	  nstaves, ninstr, meternum, meterdenom, pmnum, pmdenom, xmtrnum0,
	  n_sharps, n_pages, n_systems, musicsize, fracindent);
  FORLIM = ninstr;
  for (i = 1; i <= FORLIM; i++) {
    if (!set_names)
      putc('\n', outfile);
    else
      fprintf(outfile, "{\\twelvebf{%s}}\n", instr_name[ninstr - i]);
  }
  *clefs = '\0';
  for (i = nclefs - 1; i >= 0; i--)
    sprintf(clefs + strlen(clefs), "%c", clefcode[clefno(clef[i])]);
  fprintf(outfile, "%s\n", clefs);
  if (*texdir == '\0')
    strcpy(texdir, "./");
  fprintf(outfile, "%s\n", texdir);

  pmx_preamble_done = true;
  respace();

  FORLIM = ngroups;
  for (j = 1; j <= FORLIM; j++)
    fprintf(outfile, "\\\\grouptop%d%d\\groupbottom%d%d\\\n",
	    j, ninstr - group_start[j-1] + 1, j,
	    ninstr - group_stop[j-1] + 1);
  FORLIM = ninstr;
  for (j = 1; j <= FORLIM; j++) {
    if (stave_size[j-1] != unspec)
      fprintf(outfile, "\\\\setsize%s{%s}\\\n",
	      strnum(STR1, ninstr - j + 1), sizecode(STR2, stave_size[j-1]));
  }
  if (*title_line != '\0') {
    fprintf(outfile, "Tt\n");
    fprintf(outfile, "%s\n", title_line);
  }
  if (*composer_line != '\0') {
    fprintf(outfile, "Tc\n");
    fprintf(outfile, "%s\n", composer_line);
  }
  if (*pmx_line != '\0')
    fprintf(outfile, "%s\n", pmx_line);
  if (musixlyr) {
    FORLIM = nvoices;
    for (i = 1; i <= FORLIM; i++) {
      WITH = &info[i-1];
      if (WITH->vocal) {
	if (WITH->has_lyrics == normal)
	  fprintf(outfile, "\\\\setsongraise%d{%d\\internote}\\\n",
		  instrument(i), current[i-1].adjust);
	else if (WITH->has_lyrics == auxiliary)
	  fprintf(outfile, "\\\\auxsetsongraise%d{%d\\internote}\\\n",
		  instrument(i), current[i-1].auxadjust);
      }
    }
  }
  FORLIM = first_par_PMX_len;
  for (i = 0; i <= FORLIM - 1; i++)
    fprintf(outfile, "%s\n", first_par_PMX[i]);
}


/* --------------- Translation procedures --------------- */

static boolean last_bar;
static short bar_of_line;


static void write_repeat(char *note)
{
  char repcode[256];

  *repcode = '\0';
  if (!strcmp(note, "||"))
    strcpy(repcode, "Rd");
  else if (!strcmp(note, "|]"))
    strcpy(repcode, "RD");
  else if (!strcmp(note, "|:"))
    strcpy(repcode, "Rl");
  else if (!strcmp(note, ":|:"))
    strcpy(repcode, "Rlr");
  else if (!strcmp(note, ":|"))
    strcpy(repcode, "Rr");
  if (*repcode != '\0')
    fprintf(outfile, " %s\n", repcode);
  else if (last_bar && !strcmp(note, "|"))
    fprintf(outfile, " \\\\\\let\\Endpiece=\\endpiece\\\n");
  *note = '\0';
}


#define pause           "rp "


static void supply_rests(short voice)
{
  char STR3[256];

  if (bar_of_line == 1) {
    printf("Bar %d Voice %d", bar_no, voice);
    warning(" Filling missing voice with rests");
  }
  if (pickup > 0)
    fputs(rests(STR3, pickup, meterdenom), outfile);
  fputs(pause, outfile);
}

#undef pause


static char *MusicWord(char *Result, short voice, short n)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (n > 0 && n <= WITH->nword)
    return (substr_(Result, WITH->line, WITH->word_bound[n-1] + 1,
		    WITH->word_bound[n] - WITH->word_bound[n-1] - 1));
  else
    return strcpy(Result, "");
}


static char *GetMusicWord(char *Result, short voice)
{
  MusicWord(Result, voice, info[voice-1].here);
  info[voice-1].here++;
  return Result;
}


static char repeat_sign[256];


static short interstave(void)
{
  return 24;
}


#define FermataDown     "oF"

#define lyrics_adj      '@'


#define default_        10
#define under           (-14)


/* static variables for process_line: */
struct LOC_process_line {
  short voice;
  char chords[256], note[256], pretex[256];
  short uptext_line, chord_line, outlen, ngrace, nmulti;
  boolean last_was_tex, no_uptext, no_chords;
} ;

static void output(char *note_, struct LOC_process_line *LINK)
{
  char note[256];
  boolean join_tex;
  short notelen;
  line_info *WITH;

  strcpy(note, note_);
  if (*note != '\0') {
    join_tex = (LINK->last_was_tex && note[0] == '\\');
    if (LINK->outlen > 0 && !join_tex) {
      putc(' ', outfile);
      LINK->outlen++;
    }
    if (join_tex)
      predelete(note, 1);
    notelen = strlen(note);
    LINK->last_was_tex = (note[notelen-1] == '\\' && note[1] != '\\');
    /*Why only Type 1?*/
    if (LINK->outlen + notelen > PMXlinelength) {
      fprintf(outfile, "\n ");
      LINK->outlen = 1;
      LINK->last_was_tex = false;
    }
    fputs(note, outfile);
    LINK->outlen += strlen(note);
  }
  WITH = &info[LINK->voice-1];
  if (WITH->scan[WITH->here - 2] == nextvoice)
    putc('\n', outfile);
}

/* static variables for add_uptext: */
struct LOC_add_uptext {
  struct LOC_process_line *LINK;
  char w[256];
  short adj;
} ;

static void adjust_uptext(struct LOC_add_uptext *LINK)
{
  char letter;
  boolean force = false;
  line_info *WITH;

  delete1(LINK->w, 1);
  while (*LINK->w != '\0') {
    letter = LINK->w[0];
    delete1(LINK->w, 1);
    WITH = &info[LINK->LINK->voice-1];
    switch (letter) {

    case '<':
      if (WITH->uptext_lcz > 1)
	WITH->uptext_lcz--;
      break;

    case '>':
      if (WITH->uptext_lcz < 3)
	WITH->uptext_lcz++;
      break;

    case '^':
      WITH->uptext_adjust = 0;
      break;

    case 'v':
      WITH->uptext_adjust = under;
      break;

    case '=':
      force = true;
      break;

    case '+':
    case '-':
      if (*LINK->w != '\0')
	get_num(LINK->w, &LINK->adj);
      else
	LINK->adj = 0;
      if (letter == '-')
	LINK->adj = -LINK->adj;
      if (force)
	WITH->uptext_adjust = LINK->adj;
      else
	WITH->uptext_adjust += LINK->adj;
      *LINK->w = '\0';
      break;

    default:
      error3(LINK->LINK->voice, "Unknown uptext adjustment");
      break;
    }
  }
  strcpy(LINK->w, "!");
}

static void add_uptext(struct LOC_process_line *LINK)
{
  struct LOC_add_uptext V;
  char font[256];
  static char lcz[4] = "lcz";
  line_info *WITH;
  char STR1[256], STR3[256];

  V.LINK = LINK;
  if (LINK->no_uptext)
    return;
  WITH = &info[LINK->voice-1];
  do {
    GetNextWord(V.w, P[LINK->uptext_line-1], blank, dummy);
    sprintf(STR1, "%c", barsym);
    if (!strcmp(V.w, STR1) || *V.w == '\0')
      LINK->no_uptext = true;
    sprintf(STR1, "%c", tilde);
    if (!strcmp(V.w, STR1) || LINK->no_uptext)
      return;
    if (V.w[0] == '!') {
      strcpy(WITH->uptext_font, V.w);
      WITH->uptext_font[0] = '\\';
    }
    if (V.w[0] == '@')
      adjust_uptext(&V);
  } while (V.w[0] == '!');   /* ! is a kludge, will get me in trouble later */
  strcpy(font, WITH->uptext_font);
  text_translate(V.w, font);
  if (*font != '\0')
    sprintf(V.w, "%s{%s}", font, strcpy(STR1, V.w));
  sprintf(V.w, "\\%cchar{%s}{%s}",
	  lcz[WITH->uptext_lcz - 1],
	  strnum(STR1, default_ + WITH->uptext_adjust), strcpy(STR3, V.w));
  strcat(LINK->pretex, V.w);
}

#undef default_
#undef under

/* static variables for add_chords: */
struct LOC_add_chords {
  struct LOC_process_line *LINK;
  char nt[256];
} ;

static void out_chord(struct LOC_add_chords *LINK)
{
  line_status *WITH;

  WITH = &cstat[LINK->LINK->voice-1];
  WITH->pitch = new_pitch(LINK->nt, cstat[LINK->LINK->voice-1]);
  WITH->lastnote = LINK->nt[0];
  sprintf(LINK->LINK->chords + strlen(LINK->LINK->chords), " z%s", LINK->nt);
  *LINK->nt = '\0';
}

static void add_chords(struct LOC_process_line *LINK)
{
  struct LOC_add_chords V;
  char w[256];
  short j = 1;
  short l, mus_line;
  boolean arpeggio;
  char STR1[256];

  V.LINK = LINK;
  *LINK->chords = '\0';
  if (LINK->no_chords)
    return;
  GetNextWord(w, P[LINK->chord_line-1], blank, dummy);
  sprintf(STR1, "%c", barsym);
  if (!strcmp(w, STR1) || *w == '\0')
    LINK->no_chords = true;
  sprintf(STR1, "%c", tilde);
  if (!strcmp(w, STR1) || LINK->no_chords)
    return;
  mus_line = line_no;
  line_no = orig_line_no[LINK->chord_line-1];
  arpeggio = (w[0] == '?');
  if (arpeggio) {
    strcpy(LINK->chords, " ?");
    predelete(w, 1);
  }
  if (w[0] < 'a' || w[0] > 'g') {
    sprintf(STR1, "%s: Chord word must start with note", w);
    error3(LINK->voice, STR1);
  }
  l = strlen(w);
  sprintf(V.nt, "%c", w[0]);
  for (j = 1; j <= l - 1; j++) {
    if (w[j] >= 'a' && w[j] <= 'g')
      out_chord(&V);
    if (w[j] == chord_flat)
      w[j] = 'f';
    else if (w[j] == chord_left)
      w[j] = 'e';
    sprintf(V.nt + strlen(V.nt), "%c", w[j]);
  }
  if (*V.nt != '\0')
    out_chord(&V);
  if (arpeggio)
    strcat(LINK->chords, " ?");
  strcat(LINK->note, LINK->chords);
  line_no = mus_line;
}

/* static variables for process_other: */
struct LOC_process_other {
  struct LOC_process_line *LINK;
  char note[256];
  short adj;
  boolean force, put_above, put_below;
} ;

static void adjustment(short *adjust, char *s, struct LOC_process_other *LINK)
{
  char STR1[256], STR3[256];

  if (LINK->put_above)
    *adjust = interstave();
  else if (LINK->put_below)
    *adjust = 0;
  if (LINK->force)
    *adjust = LINK->adj;
  else
    *adjust += LINK->adj;
  sprintf(LINK->note, "\\\\\\%ssetsongraise%s{%s\\internote}\\",
	  s, strnum(STR1, instrument(LINK->LINK->voice)),
	  strnum(STR3, *adjust));
}

static char *process_other(char *Result, char *note_,
			  struct LOC_process_line *LINK)
{
  struct LOC_process_other V;
  short s2;
  char actualslur;
  line_status *WITH;
  line_info *WITH1;

  V.LINK = LINK;
  strcpy(V.note, note_);
  WITH = &current[LINK->voice-1];
  switch (V.note[0]) {

  case grace_group:
    if (strlen(V.note) == 1)
      LINK->ngrace = 1;
    else
      LINK->ngrace = pos1(V.note[1], digits);
    if (LINK->ngrace > 0)
      LINK->ngrace--;
    break;

  case stop_beam:
    WITH->beamed = false;
    WITH->after_beam = 0;
    break;

  case stop_slur:
  case stop_phrase:
    if (WITH->slurlevel < 1)
      error3(LINK->voice, "Ending a slur that was never started");
    V.note[0] = WITH->slurtoggle[WITH->slurlevel - 1];
    s2 = pos1(start_slur, V.note);
    if (s2 == 0)
      WITH->slurlevel--;
    else {
      V.note[s2-1] = V.note[0];
      insertchar(blank, V.note, s2);
    }
    if (WITH->slurlevel == 0) {
      WITH->slurred = false;
      WITH->after_slur = 0;
    }
    break;

  case start_beam:
    WITH->beamnext = true;
    WITH->no_beam_melisma = match(V.note, "[[");
    if (WITH->no_beam_melisma)
      predelete(V.note, 1);
    break;

  case start_slur:
  case start_phrase:
    if (WITH->slurlevel > 1)
      error3(LINK->voice, "More than two levels of nested slurs");
    WITH->slurlevel++;
    WITH->no_slur_melisma[WITH->slurlevel - 1] = (match(V.note, "((") ||
						  match(V.note, "{{"));
    if (WITH->no_slur_melisma[WITH->slurlevel - 1])
      predelete(V.note, 1);
    else if (WITH->slurlevel == 2)
      WITH->after_slur = 0;
    WITH->slurnext = true;
    if (WITH->slurlevel == 1) {
      if (V.note[0] == start_slur)
	WITH->slurtoggle[0] = 's';
      else
	WITH->slurtoggle[0] = 't';
    } else if (WITH->slurtoggle[0] == 't')
      WITH->slurtoggle[1] = 's';
    else
      WITH->slurtoggle[1] = 't';
    actualslur = V.note[0];
    V.note[0] = WITH->slurtoggle[WITH->slurlevel - 1];
    if (*WITH->delay_slur == '\0')
      strcpy(WITH->delay_slur, V.note);
    else {
      if (actualslur != '{') {
	WITH->slurtoggle[0] = 't';
	WITH->slurtoggle[1] = 's';
      }
      V.note[0] = WITH->slurtoggle[1];
      WITH->delay_slur[0] = WITH->slurtoggle[0];
      sprintf(WITH->delay_slur + strlen(WITH->delay_slur), " %s", V.note);
    }
    if (V.note[0] == 't' && strlen(V.note) > 1) {
      if (pos1(V.note[0], "udl") == 0)
	error3(LINK->voice, "`t' slurs may not have adjustments");
    }
    *V.note = '\0';
    break;

  case lyrics_adj:
    WITH1 = &info[LINK->voice-1];
    predelete(V.note, 1);
    V.force = (V.note[0] == '=');
    if (V.force)
      predelete(V.note, 1);
    V.put_above = (V.note[0] == '^');
    if (V.put_above)
      predelete(V.note, 1);
    V.put_below = (V.note[0] == 'v');
    if (V.put_below)
      predelete(V.note, 1);
    if (*V.note != '\0')
      get_num(V.note, &V.adj);
    else
      V.adj = 0;
    if (WITH1->has_lyrics == normal)
      adjustment(&WITH->adjust, "", &V);
    else if (WITH1->has_lyrics == auxiliary)
      adjustment(&WITH->auxadjust, "aux", &V);
    else
      *V.note = '\0';
    break;
  }
  return strcpy(Result, V.note);
}

static void lookahead(struct LOC_process_line *LINK)
{
  /* Can be improved for longer lookahead */
  char s1[256];
  short x;
  line_info *WITH;
  line_status *WITH1;
  char STR1[256];
  char STR2[256];
  char STR4[256];

  WITH = &info[LINK->voice-1];
  WITH1 = &current[LINK->voice-1];
  if (match(MusicWord(STR1, LINK->voice, WITH->here), FermataDown)) {
    GetMusicWord(s1, LINK->voice);
    predelete(s1, 2);
    if (*s1 != '\0')
      get_num(s1, &x);
    else
      x = 0;
    sprintf(LINK->pretex, "\\Fermatadown{%s}", strnum(STR2, x));
    LINK->outlen += 16;
  }
  WITH1->last_under_slur = (WITH->scan[WITH->here - 1] == rparen);
  if (WITH1->last_under_slur)
    sprintf(LINK->note + strlen(LINK->note), " %s",
	    process_other(STR2, GetMusicWord(STR4, LINK->voice), LINK));
  while (WITH->scan[WITH->here - 1] == pmxl)
    sprintf(LINK->note + strlen(LINK->note), " %s",
	    process_other(STR4, GetMusicWord(STR1, LINK->voice), LINK));
  WITH1->last_under_beam = (WITH->scan[WITH->here - 1] == rbrac);
}

static void process_note(struct LOC_process_line *LINK)
{
  short l;
  line_status *WITH;
  line_info *WITH1;
  char STR2[256];

  WITH = &current[LINK->voice-1];
  WITH1 = &info[LINK->voice-1];
  l = pos1(multi_group, LINK->note);
  if (l > 0)
    scan1(LINK->note, l + 1, &LINK->nmulti);
  if (WITH->beamnext) {
    WITH->beamed = true;
    WITH->beamnext = false;
  }
  if (WITH->beamed)
    WITH->after_beam++;
  if (WITH->slurnext) {
    WITH->slurred = true;
    WITH->slurnext = false;
  }
  if (WITH->slurred)
    WITH->after_slur++;
  if (LINK->ngrace > 0)
    LINK->ngrace--;
  else {
    if (LINK->nmulti > 0)
      LINK->nmulti--;
    else
      extend(LINK->note, LINK->voice);
  }
  *LINK->pretex = '\0';
  lookahead(LINK);
  get_syllable(LINK->voice, LINK->note, LINK->pretex);
  add_uptext(LINK);
  if (*LINK->pretex != '\0')
    sprintf(LINK->note, "%s\\ %s", LINK->pretex, strcpy(STR2, LINK->note));
  if (*WITH->delay_slur != '\0') {
    sprintf(LINK->note + strlen(LINK->note), " %s", WITH->delay_slur);
    *WITH->delay_slur = '\0';
  }
  cstat[LINK->voice-1] = current[LINK->voice-1];
  add_chords(LINK);
}


static void process_line(short voice_, short last)
{
  struct LOC_process_line V;
  short par_line;
  char STR1[256];
  line_info *WITH;

  V.voice = voice_;
  V.outlen = 0;
  V.last_was_tex = false;
  V.chord_line = info[V.voice-1].chord;
  V.no_chords = (V.chord_line == 0);
  V.uptext_line = info[V.voice-1].uptext;
  V.no_uptext = (V.uptext_line == 0);
  par_line = info[V.voice-1].mus;
  V.nmulti = 0;
  V.ngrace = 0;
  line_no = orig_line_no[par_line-1];
  do {
    GetMusicWord(V.note, V.voice);
    if (*V.note == '\0')
      return;
    WITH = &info[V.voice-1];
    if (V.note[0] == rest)
      extend(V.note, V.voice);
    else if (pos1(V.note[0], note_names) > 0)
      process_note(&V);
    else if (pos1(barsym, V.note) > 0) {
      if (V.voice == nvoices) {
	if (WITH->here < last)
	  write_repeat(V.note);
	else
	  strcpy(repeat_sign, V.note);
      }
      sprintf(STR1, "%c", barsym);
      if (strcmp(V.note, STR1))
	*V.note = '\0';
      V.no_chords = (V.chord_line == 0);
      V.no_uptext = (V.uptext_line == 0);
    } else if (WITH->scan[WITH->here - 2] == FirstOnly && V.voice != nvoices)
      *V.note = '\0';
    else
      strcpy(V.note, process_other(STR1, V.note, &V));
    output(V.note, &V);
  } while (info[V.voice-1].here <= last);
  if (!V.no_chords) {
    sprintf(STR1, "%c", barsym);
    if (!strcmp(P[V.chord_line-1], STR1))
      predelete(P[V.chord_line-1], 1);
  }
}


static void get_meter_change(short voice, char *new_meter)
{
  short pn1, pn2;
  char w[256], new_command[256];
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->nword == 0 || WITH->scan[WITH->here - 1] != mword)
    return;
  line_no = orig_line_no[WITH->mus - 1];
  GetMusicWord(w, voice);
  read_meter(w, &meternum, &meterdenom, &pn1, &pn2);
  full_bar = meternum * (64 / meterdenom);
  if (w[0] == 'm')
    sprintf(new_command, "%s ", w);
  else
    meter_change(new_command, meternum, meterdenom, false);
  if (*new_meter != '\0' && strcmp(new_meter, new_command))
    error3(voice, "The same meter change must appear in all voices");
  strcpy(new_meter, new_command);
}


#define all             100


/* static variables for music_paragraph: */
struct LOC_music_paragraph {
  char new_meter[256];
} ;

static void process_one_bar(struct LOC_music_paragraph *LINK)
{
  short voice;
  boolean wrote_repeat = false;
  line_info *WITH;

  if (bar_of_line > 1)
    fprintf(outfile, "%cBar %d\n", comment, bar_no);
  last_bar = (bar_of_line == nbars && final_paragraph);
  *LINK->new_meter = '\0';
  if (!last_bar)
    write_repeat(repeat_sign);
  else
    *repeat_sign = '\0';
  for (voice = nvoices; voice >= 1; voice--) {
    WITH = &info[voice-1];
    if (WITH->mus > 0) {
      WITH->here = WITH->bar_bound[bar_of_line-1] + 1;
      get_meter_change(voice, LINK->new_meter);
      WITH->bar_bound[bar_of_line-1] = WITH->here - 1;
    }
  }
  if (last_bar && *LINK->new_meter == '\0' && nleft > pickup)
    meter_change(LINK->new_meter, nleft, 64, true);
  if (*LINK->new_meter != '\0')
    fprintf(outfile, "%s\n", LINK->new_meter);
  for (voice = nvoices; voice >= 1; voice--) {
    WITH = &info[voice-1];
    if (WITH->mus > 0)
      process_line(voice, WITH->bar_bound[bar_of_line]);
    else
      supply_rests(voice);
    if (last_bar && *repeat_sign != '\0' && !wrote_repeat) {
      write_repeat(repeat_sign);
      wrote_repeat = true;
    }
    if (WITH->voice_pos == 1)
      fprintf(outfile, " /\n");
    else
      fprintf(outfile, " //\n");
  }
  bar_no++;
  pickup = 0;
  putc('\n', outfile);
}


/* ------------------------------------------------------------------- */

static void music_paragraph(void)
{
  struct LOC_music_paragraph V;
  short i, nvoice, FORLIM;

  paragraph_setup(&nvoice);
  if (nvoice == 0)
    warning("Paragraph contains no music lines at all");
  else if (nvoice > nvoices) {
    error("I can handle too few voices but not too many - skipping paragraph");
    return;
  }
  test_paragraph();
  if (verbose > 0)
    describe_paragraph();
  /* ---- Knowing the score, we can start setting music ---------------- */
  if (!pmx_preamble_done) {
    do_pmx_preamble();
    fprintf(outfile, "%c Paragraph %d line %d bar ",
	    comment, paragraph_no, orig_line_no[0]);
    if (pickup > 0)
      fprintf(outfile, "0\n");
    else
      fprintf(outfile, "1\n");
  }
  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++)
  {   /* ----- Wipe comments ------------------ */
    if (P[i][0] == comment) {   /** Double comments are PMX lines   ------ */
      if (P[i][1] == comment) {
	predelete(P[i], 2);
	if (pmx_preamble_done)
	  fprintf(outfile, "%s\n", P[i]);
	else {
	  first_par_PMX_len++;
	  strcpy(first_par_PMX[first_par_PMX_len-1], P[i]);
	}
      }
      *P[i] = '\0';
    }
  }
  if (some_vocal && musixlyr) {
    FORLIM = ninstr;
    for (i = 0; i <= FORLIM - 1; i++) {   /* ------ Assign lyrics ------ */
      if (!global_lyrics && !strcmp(tags[i], "."))
	*tags[i] = '\0';
      if (strcmp(tags[i], oldtags[i]) && strcmp(tags[i], ".")) {
	fprintf(outfile, "\\\\\\assignlyrics%d{%s}\\\n",
		nstaves - continuo - i, tags[i]);
	strcpy(oldtags[i], tags[i]);
      }
      if (!global_lyrics && !strcmp(auxtags[i], "."))
	*auxtags[i] = '\0';
      if (strcmp(auxtags[i], oldauxtags[i]) && strcmp(auxtags[i], ".")) {
	fprintf(outfile, "\\\\\\auxlyr{\\assignlyrics%d{%s}}\\\n",
		nstaves - continuo - i, auxtags[i]);
	strcpy(oldauxtags[i], auxtags[i]);
      }
    }
  }
  if (must_respace)
    respace();
  if (nleft > 0)
    nbars++;
  FORLIM = nbars;
  for (bar_of_line = 1; bar_of_line <= FORLIM; bar_of_line++)
    process_one_bar(&V);
}

#undef all


static void lyrics_paragraph(void)
{
  char first[256], w[256];
  short i, l, line;
  short nother = 0;
  char other_[10][256];
  char STR1[256], STR3[256];
  short FORLIM;
  char STR4[256], STR5[256];

  if (!dolyrics)
    return;
  NextWord(w, P[0], blank, dummy);
  l = strlen(w);
  line_no = orig_line_no[0];
  if (w[l-1] != '}')
    strcat(w, "}");
  GetNextWord(first, w, dummy, '}');
  while (*w != '\0') {
    if (w[0] == '=')
      predelete(w, 1);
    if (w[0] != '{')
      sprintf(w, "{%s", strcpy(STR1, w));
    nother++;
    GetNextWord(other_[nother-1], w, dummy, '}');
  }
  if (verbose > 0) {
    printf("---- Paragraph %d starting at line %d has lyrics headed %s",
	   paragraph_no, line_no, first);
    for (i = 0; i <= nother - 1; i++)
      printf("=%s", other_[i]);
    putchar('\n');
  }
  sprintf(STR5, "%c Paragraph %s line %s bar %s",
	  comment, strnum(STR1, paragraph_no), strnum(STR3, line_no),
	  strnum(STR4, bar_no));
  tex3(STR5);
  sprintf(STR3, "\\setlyrics%s{%%", first);
  tex3(STR3);
  FORLIM = para_len;
  for (line = 2; line <= FORLIM; line++) {
    lyr_translate(P[line-1]);
    line_no = orig_line_no[line-1];
    if (strlen(P[line-1]) > max_lyrics_line_length && pmx_preamble_done)
      error("Lyrics line too long");
    if (pmx_preamble_done) {
      if (line == 2)
	fprintf(outfile, "\\\\\\:%s", P[line-1]);
      else
	fprintf(outfile, "\\\\\\ %s", P[line-1]);
    } else
      fputs(P[line-1], outfile);
    if (line < para_len) {
      if (pmx_preamble_done)
	fprintf(outfile, " %%\\\n");
      else
	fprintf(outfile, " %%\n");
    } else if (pmx_preamble_done)
      fprintf(outfile, "}\\\n");
    else
      fprintf(outfile, "}\n");
  }
  for (i = 0; i <= nother - 1; i++) {
    sprintf(STR1, "\\copylyrics%s%s", first, other_[i]);
    tex3(STR1);
  }
}


/* -------------- Level 1 procedures ------------------------------------- */

static boolean do_preamble(void)
{
  /* ----- True if a preamble is present ---*/
  boolean Result = false;
  short i, j;
  short maybe_voices = 0, ncommands = 0;
  line_type line_found;
  boolean guess = false;
  short FORLIM;

  preamble_defaults();
  read_paragraph(P, orig_line_no, &para_len);
  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++) {
    line_no = orig_line_no[i];
    line_found = do_command(P[i]);
    if (line_found == command_line)
      ncommands++;
    else if (line_found == colon_line)
      printf("Presumed new style element on line %d\n", line_no);
    else {
      printf("Presumed music line in preamble\n");
      if (line_found == plain_line)
	maybe_voices++;
    }
  }
  if (ncommands > 0 && maybe_voices > 0)
    error("Paragraph 1 seems to be a mixture of commands and music");
  else if (ncommands == 0) {
    guess = true;
    printf("No preamble commands found!  I hope paragraph 1 contains music.\n");
  } else
    Result = true;
  if (ncommands > 0 && maybe_voices == 0 && !style_supplied) {
    warning("Preamble paragraph does not supply STYLE");
    read_paragraph(P, orig_line_no, &para_len);
    Result = false;
    guess = true;
    maybe_voices = para_len;
  }
  if (guess)
    preamble_guess(maybe_voices);
  interpret_commands();
  FORLIM = strlen(options_line);
  for (j = 0; j <= FORLIM - 1; j++)
    process_option(options_line[j]);
  if (verbose > 0)
    show_options();
  one_beat = 64 / meterdenom;
  full_bar = meternum * one_beat;
  return Result;
}


static void do_music(boolean paragraph_scanned)
{
  short j, stave, voice, FORLIM;
  line_status *WITH;
  line_info *WITH1;

  first_paragraph = true;
  pmx_preamble_done = false;
  bar_no = 1;
  *repeat_sign = '\0';
  first_par_PMX_len = 0;
  must_respace = false;
  init_mod();
  FORLIM = nvoices;
  for (voice = 0; voice <= FORLIM - 1; voice++) {
    WITH = &current[voice];
    WITH1 = &info[voice];
    WITH->duration = default_duration;
    WITH1->has_lyrics = none;
    WITH->adjust = 0;
    if (upper(voice + 1))
      WITH->auxadjust = interstave();
    else
      WITH->auxadjust = 0;
    WITH1->uptext_adjust = 0;
    WITH1->uptext_lcz = 3;
    *WITH1->uptext_font = '\0';
    WITH->lastnote = 'f';
    WITH->octave_adjust = 0;
    *WITH->delay_slur = '\0';
    WITH->slurlevel = 0;
    WITH->beamed = false;
    WITH->beamnext = false;
    WITH->after_beam = 0;
    WITH->last_under_beam = false;
    WITH->slurred = false;
    WITH->slurnext = false;
    WITH->after_slur = 0;
    WITH->last_under_slur = false;
    WITH->octave = init_octave(WITH1->voice_stave);
    WITH->pitch = WITH->octave * 7 - '0' - 3;
    cstat[voice] = current[voice];
  }
  FORLIM = nstaves;
  for (stave = 0; stave <= FORLIM - 1; stave++) {
    strcpy(oldtags[stave], ".");
    strcpy(oldauxtags[stave], ".");
  }
  do {
    if (paragraph_scanned)
      read_paragraph(P, orig_line_no, &para_len);
    final_paragraph = eof_infile;
    paragraph_scanned = true;
    if (para_len > 0) {
      j = posnot(blank, P[0]);
      if (j > 0 && P[0][j-1] == '{')
	lyrics_paragraph();
      else {
	if (pmx_preamble_done)
	  fprintf(outfile, "%c Paragraph %d line %d bar %d\n",
		  comment, paragraph_no, orig_line_no[0], bar_no);
	music_paragraph();
	first_paragraph = false;
	write_repeat(repeat_sign);
      }
    }
  } while (!final_paragraph);
}


main(int argc, char *argv[])
{  /* ---- Main program ------------------------ */
  PASCAL_MAIN(argc, argv);
  exit_code = 0;
  printf("M-Tx %s (Music from TeXt) %s\n", version, version_date);
  OpenFiles();
  do_music(do_preamble());
  CloseFiles();
  printf("PrePMX done.  Now run PMX.\n");
  _Escape(exit_code);
  exit(EXIT_SUCCESS);
}




/* End. */
