/*
 * $Id: true1541.h,v 1.1 1997/05/22 21:36:35 ettore Exp $
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 * Written by
 *   Daniel Sladic (sladic@eecg.toronto.edu)
 *   Ettore Perazzoli (ettore@comm2000.it)
 *
 * $Log: true1541.h,v $
 * Revision 1.1  1997/05/22 21:36:35  ettore
 * Initial revision
 *
 */

/* This is the header file for the hardware-level 1541 emulation. */

#ifndef _TRUE1541_H
#define _TRUE1541_H

#include "types.h"
#include "drive.h"		/* DRIVE */
#include "1541cpu.h"

/* VIA 1 alarms */
#define	A_VIAD1T1	0
#define	A_VIAD1T2	1
/* VIA 2 alarms */
#define	A_VIAD2T1	2
#define	A_VIAD2T2	3

#define TRUE1541_NUMOFALRM 4

/* VIA 1 interrupts. */
#define	I_VIAD1T1	0
#define	I_VIAD1T2	1
#define	I_VIAD1SR	2
#define	I_VIAD1FL	3
#define I_VIAD1CB1	4
#define I_VIAD1CB2	5
#define I_VIAD1CA1	6
#define I_VIAD1CA2	7
/* VIA 2 interrupts. */
#define	I_VIAD2T1	8
#define	I_VIAD2T2	9
#define	I_VIAD2SR	10
#define	I_VIAD2FL	11
#define I_VIAD2CB1	12
#define I_VIAD2CB2	13
#define I_VIAD2CA1	14
#define I_VIAD2CA2	15

#define TRUE1541_NUMOFINT 16

/* 1541 sync factor.

   The ``sync factor'' is computed approximately as:
   
    65536 * clk_1541 / clk_[c64|vic20]
    
   where `clk_1541' is fixed to 1 MHz, while `clk_[c64|vic20]' depends on the
   video timing (PAL or NTSC). */

/* Are these exact? */

#if defined(CBM64) || defined(C128)
#define TRUE1541_PAL_SYNC_FACTOR	66516   /* Maybe 66517? */
#define TRUE1541_NTSC_SYNC_FACTOR	64094
#endif
#if defined(VIC20)
#define TRUE1541_PAL_SYNC_FACTOR	59126
#define TRUE1541_NTSC_SYNC_FACTOR	64079
#endif

#define TRUE1541_ROM_SIZE 16384
#define TRUE1541_RAM_SIZE 2048

/* 1541 idling methods. */
#define TRUE1541_IDLE_SKIP_CYCLES	0
#define TRUE1541_IDLE_TRAP_IDLE		1

/* -------------------------------------------------------------------------- */

extern void initialize_true1541(void);

#if defined(CBM64) || defined(C128)
extern void serial_bus_cpu_write(BYTE data);
extern BYTE serial_bus_cpu_read(void);
#endif
#if defined(VIC20) 
extern void serial_bus_pa_write(BYTE data);
extern void serial_bus_pcr_write(BYTE data);
extern BYTE serial_bus_pa_read(void);
#endif
extern void serial_bus_drive_write(BYTE data);
extern BYTE serial_bus_drive_read(void);
extern int true1541_trap_handler(void);
extern void true1541_move_head(int step);
extern int true1541_sync_found(void);
extern BYTE true1541_read_disk_byte(void);
extern void true1541_write_gcr(BYTE val);
extern int true1541_write_protect_sense(void);
extern void true1541_cpu_execute(void);
extern void true1541_cpu_reset(void);
extern void true1541_set_sync_factor(unsigned int factor);
extern void true1541_set_ntsc_sync_factor(void);
extern void true1541_set_pal_sync_factor(void);
extern void true1541_ack_sync_factor(void);
extern void true1541_enable(void);
extern void true1541_disable(void);
extern void true1541_ack_switch(void);
extern void true1541_reset(void);
extern int true1541_attach_floppy(DRIVE *floppy);
extern int true1541_detach_floppy(void);

extern BYTE true1541_rom[TRUE1541_ROM_SIZE];
extern BYTE true1541_ram[TRUE1541_RAM_SIZE];
extern int true1541_led_status;

#endif /* !_TRUE1541_H */
