/*      -------------------------------------------------------------------
	xldlas -- A Program for Statistics

	Copyright (C) 1996, 1997 Thor Sigvaldason

	This file contains all the test routines
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void inhibit_input();
extern void reenable_input();
extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void begin_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void add_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void end_column_output();
extern void seperator_output(int how_many);
extern void begin_table_output(int how_many, char title[XLDLASMAX_INPUT]);
extern void end_table_output(int how_many);
extern void filter_tex_specials(char input_string[XLDLASMAX_INPUT]);
extern float betai(float a, float b, float x);

void done_eqmeantest(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_EQMEAN][0] = obj->form->x;
	window_geometry[XLDLAS_EQMEAN][1] = obj->form->y;
	window_geometry[XLDLAS_EQMEAN][2] = obj->form->w;
	window_geometry[XLDLAS_EQMEAN][3] = obj->form->h;
	fl_hide_form(eqmean_window);
	reenable_input();
	say_status("Ready");
}

void done_watsontest(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_WATSON][0] = obj->form->x;
	window_geometry[XLDLAS_WATSON][1] = obj->form->y;
	window_geometry[XLDLAS_WATSON][2] = obj->form->w;
	window_geometry[XLDLAS_WATSON][3] = obj->form->h;
	fl_hide_form(watson_window);
	reenable_input();
	say_status("Ready");
}

void do_watsontest(FL_OBJECT *obj, long arg)
{
	int var_number, i;
	float d_numerator, d_denominator;
	char a_string[XLDLASMAX_INPUT];
	var_number = -1;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(watson_browser, i+1))
		{
			var_number = i;
		}
	}
	if(var_number == -1)
	{
		fl_show_alert("You have to choose a variable to perform the test on",
			      "", "", TRUE);
		return;
	}
	all_start = fl_get_counter_value(watson_from_counter);
	all_stop = fl_get_counter_value(watson_to_counter);
	if(all_start > data_matrix[var_number].obs) all_start = data_matrix[var_number].obs;
	if(all_stop > data_matrix[var_number].obs) all_stop = data_matrix[var_number].obs;
	if(all_stop < all_start)
	{
		fl_show_alert("From Value greater than To Value","","",TRUE);
		return;
	}
	worksize = 0;
	for(i = all_start - 1; i < all_stop; i++)
	{
		if(*(fvector[var_number] + i) != missing_value)
		{
			working[worksize] = *(fvector[var_number] + i);
			worksize++;
		}
	}
	if(worksize < 2)
	{
		fl_show_alert("Not enough degress of freedom", "","",TRUE);
		return;
	}
	d_numerator = 0.0;
	d_denominator = pow(working[i],2);
	for(i = 1; i < worksize; i++)
	{
		d_denominator= d_denominator + pow(working[i], 2);
		d_numerator = d_numerator + pow(working[i] - working[i-1], 2);
	}

	begin_table_output(2, "Durban-Watson Test");
	begin_column_output("Variable            ", XLDLAS_JUST_CENTER);
	add_column_output(data_matrix[var_number].name, XLDLAS_JUST_CENTER);	
	end_column_output();

	seperator_output(2);

	sprintf(a_string,"%d", worksize);
	begin_column_output("Degrees of Freedom  ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%f", d_numerator / d_denominator);
	begin_column_output("Test  Statistic     ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();

	end_table_output(2);

	
}

void do_eqmeantest(FL_OBJECT *obj, long arg)
{
	int var_one, var_two, i, total_freedom;
	float mean_one, mean_two, variance_one, variance_two, scratch,
		total_variance, tstat, tprob;
	char a_string[XLDLASMAX_INPUT];
	var_one = -1;
	var_two = -2;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(eqmean_one_browser, i+1))
		{
			var_one = i;
		}
		if(fl_isselected_browser_line(eqmean_two_browser, i+1))
		{
			var_two = i;
		}
	}
	if(var_one == var_two)
	{
		fl_show_alert("I can tell you right now that they're equal",
			      "(You selected the same variable twice)", "", TRUE);
		return;
	}
	if(var_one == -1 || var_two == -1)
	{
		fl_show_alert("You have to choose two variables to perform the test on",
			      "", "", TRUE);
		return;
	}
	all_start = fl_get_counter_value(eqmean_from_counter);
	all_stop = fl_get_counter_value(eqmean_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value greater than To Value","","",TRUE);
		return;
	}
	worksize = 0;
	worksize_two = 0;
	mean_one = 0.0;
	mean_two = 0.0;
	variance_one = 0.0;
	variance_two = 0.0;
	for(i = all_start - 1; i < all_stop; i++)
	{
		if(*(fvector[var_one] + i - (all_start - 1)) != missing_value)
		{
			working[worksize] = *(fvector[var_one] + i - (all_start - 1));
			mean_one = mean_one + working[worksize];
			worksize++;
		}
		if(*(fvector[var_two] + i - (all_start - 1)) != missing_value)
		{
			working_two[worksize_two] = *(fvector[var_two] + i - (all_start - 1));
			mean_two = mean_two + working_two[worksize_two];
			worksize_two++;
		}
	}
	if(worksize < 2 || worksize_two < 2)
	{
		fl_show_alert("Not enough degrees of freedom in data","Sadly, I can't go on","", TRUE);
		return;
	}
	mean_one = mean_one / worksize;
	mean_two = mean_two / worksize_two;
	scratch = 0.0;
	for(i = 0; i < worksize; i++)
	{
		scratch = scratch + (working[i] - mean_one);
		variance_one = variance_one + pow((working[i] - mean_one),2);
	}
	variance_one = (variance_one - scratch * scratch / worksize) / (worksize - 1);
	scratch = 0.0;
	for(i = 0; i < worksize_two; i++)
	{
		scratch = scratch + (working_two[i] - mean_two);
		variance_two = variance_two + pow((working_two[i] - mean_two),2);
	}
	variance_two = (variance_two - scratch * scratch / worksize_two) / (worksize_two - 1);
	total_freedom = worksize + worksize_two - 2;
	total_variance = (((worksize - 1) * variance_one) + ((worksize_two - 1)* variance_two)) / total_freedom;
	tstat = (mean_one - mean_two) / pow(total_variance * (1.0/worksize + 1.0/worksize_two), 0.5);
	tprob = betai(0.5 * total_freedom, 0.5, total_freedom/(total_freedom + tstat * tstat));
	
	begin_table_output(2, "Test for Equality of Means");
	begin_column_output("Variable 1          ", XLDLAS_JUST_CENTER);
	add_column_output(data_matrix[var_one].name, XLDLAS_JUST_CENTER);	
	end_column_output();
	begin_column_output("Variable 2          ", XLDLAS_JUST_CENTER);
	add_column_output(data_matrix[var_two].name,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%f",mean_one);
	begin_column_output("Mean of Var 1       ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%f",mean_two);
	begin_column_output("Mean of Var 2       ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%f",variance_one);
	begin_column_output("Variance of Var 1   ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%f",variance_two);
	begin_column_output("Variance of Var 2   ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	
	seperator_output(2);

	sprintf(a_string,"%d, %d, %d", worksize-1,worksize_two-1, total_freedom);
	begin_column_output("Degrees of Freedom  ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"t = %1.3f",tstat);
	begin_column_output("T Statistic         ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();

	sprintf(a_string,"Prob(t) = %1.3f",tprob);
	begin_column_output("Confidence          ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();

	end_table_output(2);


}

void done_signtest(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_SIGN][0] = obj->form->x;
	window_geometry[XLDLAS_SIGN][1] = obj->form->y;
	window_geometry[XLDLAS_SIGN][2] = obj->form->w;
	window_geometry[XLDLAS_SIGN][3] = obj->form->h;
	fl_hide_form(sign_window);
	reenable_input();
	say_status("Ready");
}

void do_signtest(FL_OBJECT *obj, long arg)
{
	int var_one, var_two, i, nrealobs, numb_pluses, numb_negs, numb_equal;
	float test_prob, phat, zstat, reject_significance;
	char a_string[XLDLASMAX_INPUT];
	var_one = -1;
	var_two = -2;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(sign_one_browser, i+1))
		{
			var_one = i;
		}
		if(fl_isselected_browser_line(sign_two_browser, i+1))
		{
			var_two = i;
		}
	}
	if(var_one == var_two)
	{
		fl_show_alert("There is little point in Sign Testing a variable against itself",
			      "(I'm not going to bother)", "", TRUE);
		return;
	}
	if(var_one == -1 || var_two == -1)
	{
		fl_show_alert("You have to choose two variables to perform the test on",
			      "", "", TRUE);
		return;
	}
	all_start = fl_get_counter_value(sign_from_counter);
	all_stop = fl_get_counter_value(sign_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value greater than To Value","","",TRUE);
		return;
	}
	test_prob = fl_get_counter_value(sign_null_counter);
	nrealobs = 0;
	numb_pluses = 0;
	numb_negs = 0;
	numb_equal = 0;
	for(i = all_start - 1; i < all_stop; i++)
	{
		if(*(fvector[var_one] + i - (all_start - 1)) != missing_value &&
		   *(fvector[var_two] + i - (all_start - 1)) != missing_value)
		   {
		   	nrealobs++;
			if(*(fvector[var_one] + i - (all_start - 1)) >
		   	   *(fvector[var_two] + i - (all_start - 1)) )
		   	{
		   		numb_pluses++;
		   	}
			if(*(fvector[var_one] + i - (all_start - 1)) <
		   	   *(fvector[var_two] + i - (all_start - 1)) )
		   	{
		   		numb_negs++;
		   	}
			if(*(fvector[var_one] + i - (all_start - 1)) ==
		   	   *(fvector[var_two] + i - (all_start - 1)) )
		   	{
		   		numb_equal++;
		   	}
		   }
	}
	if((nrealobs - numb_equal) == 0)
	{
		fl_show_alert("All Observations are Equal", "(Can't perform the test)","",TRUE);
		return;
	}
	if((nrealobs - numb_equal) < 35) fl_show_alert("Warning: You have selected a small number of observations!",
					"This test uses a normal approximation to the binomial distribution",
					"which is innacurate for such small samples.", TRUE);
	begin_table_output(2, "Sign Test Results");
	begin_column_output("Variable 1          ", XLDLAS_JUST_CENTER);
	add_column_output(data_matrix[var_one].name, XLDLAS_JUST_CENTER);	
	end_column_output();
	begin_column_output("Variable 2          ", XLDLAS_JUST_CENTER);
	add_column_output(data_matrix[var_two].name,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%d", nrealobs);
	begin_column_output("Total Observations  ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%d",numb_pluses);
	begin_column_output("Var 1 > Var 2       ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%d",numb_negs);
	begin_column_output("Var 1 < Var 2       ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	sprintf(a_string,"%d",numb_equal);
	begin_column_output("Var 1 = Var 2       ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	
	seperator_output(2);

	sprintf(a_string,"p = %1.3f", test_prob);
	begin_column_output("Null Hypothesis     ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	phat = numb_pluses;
	phat = phat / (nrealobs - numb_equal);
	sprintf(a_string,"phat = %1.3f",phat);
	begin_column_output("Sample Ratio        ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();

	zstat = (phat - test_prob) / (pow(((test_prob * test_prob) / (nrealobs - numb_equal)) ,0.5));	

	sprintf(a_string,"z = %1.3f",zstat);
	begin_column_output("Test statistic      ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();

	reject_significance = betai(numb_pluses + 1, (nrealobs - numb_equal) - numb_pluses + 1, test_prob);
	if(reject_significance > 0.5) reject_significance = 1.0 - reject_significance;
	sprintf(a_string,"%1.3f", reject_significance);
	begin_column_output("One Sided Reject    ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	
	sprintf(a_string,"%1.3f", reject_significance * 2.0);
	begin_column_output("Two Sided Reject    ", XLDLAS_JUST_CENTER);
	add_column_output(a_string,XLDLAS_JUST_CENTER);	
	end_column_output();
	

	end_table_output(2);
}


void start_signtest()
{
	int i, largest;
	inhibit_input();
	largest = 0;
	fl_clear_browser(sign_one_browser);
	fl_clear_browser(sign_two_browser);
	for(i = 0; i < numb_variables; i++)
	{
		if(largest < data_matrix[i].obs) largest = data_matrix[i].obs;
		fl_addto_browser(sign_one_browser,data_matrix[i].name);
		fl_addto_browser(sign_two_browser,data_matrix[i].name);
	}
	fl_set_counter_value(sign_from_counter, 1);
	fl_set_counter_bounds(sign_from_counter, 1, largest);
	fl_set_counter_value(sign_to_counter, largest);
	fl_set_counter_bounds(sign_to_counter, 1, largest);
	say_status("Waiting for Sign Test Specifications...");
	if(window_geometry[XLDLAS_SIGN][0] != -1)
	{
		fl_set_form_geometry(sign_window, 
					window_geometry[XLDLAS_SIGN][0],
					window_geometry[XLDLAS_SIGN][1],
					window_geometry[XLDLAS_SIGN][2],
					window_geometry[XLDLAS_SIGN][3]);
	}	
	fl_show_form(sign_window,FL_PLACE_FREE,FL_FULLBORDER,"Sign Test");
}

void start_watsontest()
{
	int i, largest;
	inhibit_input();
	largest = 0;
	fl_clear_browser(watson_browser);
	for(i = 0; i < numb_variables; i++)
	{
		if(largest < data_matrix[i].obs) largest = data_matrix[i].obs;
		fl_addto_browser(watson_browser,data_matrix[i].name);
	}
	fl_set_counter_value(watson_from_counter, 1);
	fl_set_counter_bounds(watson_from_counter, 1, largest);
	fl_set_counter_value(watson_to_counter, largest);
	fl_set_counter_bounds(watson_to_counter, 1, largest);
	say_status("Waiting for Durbin-Watson Test variable specification...");
	if(window_geometry[XLDLAS_WATSON][0] != -1)
	{
		fl_set_form_geometry(sign_window, 
					window_geometry[XLDLAS_WATSON][0],
					window_geometry[XLDLAS_WATSON][1],
					window_geometry[XLDLAS_WATSON][2],
					window_geometry[XLDLAS_WATSON][3]);
	}	
	fl_show_form(watson_window,FL_PLACE_FREE,FL_FULLBORDER,"Durbin-Watson Test");
}

void start_eqmeantest()
{
	int i, largest;
	inhibit_input();
	largest = 0;
	fl_clear_browser(eqmean_one_browser);
	fl_clear_browser(eqmean_two_browser);
	for(i = 0; i < numb_variables; i++)
	{
		if(largest < data_matrix[i].obs) largest = data_matrix[i].obs;
		fl_addto_browser(eqmean_one_browser,data_matrix[i].name);
		fl_addto_browser(eqmean_two_browser,data_matrix[i].name);
	}
	fl_set_counter_value(eqmean_from_counter, 1);
	fl_set_counter_bounds(eqmean_from_counter, 1, largest);
	fl_set_counter_value(eqmean_to_counter, largest);
	fl_set_counter_bounds(eqmean_to_counter, 1, largest);
	say_status("Waiting for Mean Equality Test Specifications...");
	if(window_geometry[XLDLAS_EQMEAN][0] != -1)
	{
		fl_set_form_geometry(eqmean_window, 
					window_geometry[XLDLAS_EQMEAN][0],
					window_geometry[XLDLAS_EQMEAN][1],
					window_geometry[XLDLAS_EQMEAN][2],
					window_geometry[XLDLAS_EQMEAN][3]);
	}	
	fl_show_form(eqmean_window,FL_PLACE_FREE,FL_FULLBORDER,"Test Equality of Means");
}


void test_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1) start_signtest();
	if(choice == 2) start_eqmeantest();
	if(choice == 3) start_watsontest();
}