#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"


#define NO_SELECT_HOST 0
#define SELECTED_HOST  1
#define NO_SELECT_USER 2
#define SELECTED_USER  3
#define NO_SELECT_DBF  4
#define SELECTED_DBF   5
#define SELECTED_SUBFORM 6

struct inputGrant *InputGrant, *InpHost, *InpDb, *InpUser;
extern struct setup Setup;
extern struct stat Stat;
FD_grant *f_grant;

void grant_getHosts(FL_OBJECT *browser);
void grant_activate(int status);
void grant_getUsers(FL_OBJECT *browser, char *hostName);
void grant_getDb(FL_OBJECT *browser, char *hostName, char *userName);

extern void main_inputhost(int type);
extern void main_inputdb(int type);
extern void main_inputuser(int type);



void grant_hosts(FL_OBJECT *obj, long data)
{
  char string[256];
  
  strcpy(string, fl_get_browser_line(obj, fl_get_browser(obj)));

  if(fl_get_browser_maxline(f_grant->dbf))
    fl_clear_browser(f_grant->dbf);
  
  if(!string[0])
    {
      if(fl_get_browser_maxline(f_grant->users))
	fl_clear_browser(f_grant->users);
      grant_activate(NO_SELECT_HOST);
      memset(InpHost, '\0', sizeof(struct inputGrant));
      memset(InpDb, '\0', sizeof(struct inputGrant));
      memset(InpUser, '\0', sizeof(struct inputGrant));
      return;
    }
  strcpy(InpHost->host, getSubstr(string, '\t', 0));
  strcpy(InpHost->db, getSubstr(string, '\t', 1));

  /* prend toute l'information de la ligne selectionnee */
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      
      mysql_select_db(&connection, "mysql");
      sprintf(string, "select * from host where host = '%s' and db = '%s' limit 1", InpHost->host, InpHost->db);

      if (!mysql_query(&connection, string))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
	  strcpy(InpHost->select, row[2]);
	  strcpy(InpHost->insert, row[3]);
	  strcpy(InpHost->update, row[4]);
	  strcpy(InpHost->delete, row[5]);
	  strcpy(InpHost->create, row[6]);
	  strcpy(InpHost->drop,   row[7]);
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
  
  /* load le browser des usagers pour le host courant */
  grant_getUsers(f_grant->users, InpHost->host);
  grant_activate(NO_SELECT_USER);
  
  
}

void grant_addhost(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpHost;
  memset(InputGrant, '\0', sizeof(struct inputGrant));
  main_inputhost(0);
}
void grant_modhost(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpHost;
  main_inputhost(1);
}
void grant_delhost(FL_OBJECT *obj, long data)
{
  int delAll;
  MYSQL connection;

  if(!fl_show_question("You are about to remote access from an host.\nAre you sure?", 0))
    return;
  
  delAll = fl_show_question("Propagate delete to subforms users and db?", 0);
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *query;
      
      query = (char *) malloc(2048);
      if(!query) return;
      
      mysql_select_db(&connection, "mysql");
      sprintf(query,
          "delete from host where host='%s' and db='%s'",
          InpHost->host,InpHost->db);

      if (!mysql_query(&connection, query))
	{
	  result = mysql_store_result(&connection);
	  if(result != NULL) mysql_free_result(result);
	}
      else
	{
	  fl_show_messages(mysql_error(&connection));
	}

	if(delAll)
	  {
	    sprintf(query,
		    "delete from user where host='%s'",
		    InpHost->host);
	    if (!mysql_query(&connection, query))
	      {
		result = mysql_store_result(&connection);
		if(result != NULL) mysql_free_result(result);
	      }
	    else
	      {
		fl_show_messages(mysql_error(&connection));
	      }

	    sprintf(query,
		    "delete from db where host='%s'", InpHost->host);
	    if (!mysql_query(&connection, query))
	      {
		result = mysql_store_result(&connection);
		if(result != NULL) mysql_free_result(result);
	      }
	    else
	      {
		fl_show_messages(mysql_error(&connection));
	      }
	
	  }
	free(query);
	mysql_close(&connection);
    }

  if(fl_get_browser_maxline(f_grant->users))
    fl_clear_browser(f_grant->users);
  if(fl_get_browser_maxline(f_grant->dbf))
    fl_clear_browser(f_grant->dbf);
  grant_activate(NO_SELECT_HOST);
  memset(InpHost, '\0', sizeof(struct inputGrant));
  memset(InpDb, '\0', sizeof(struct inputGrant));
  memset(InpUser, '\0', sizeof(struct inputGrant));
  grant_getHosts(f_grant->hosts);
}

void grant_users(FL_OBJECT *obj, long data)
{
  char string[256];
  
  strcpy(string, fl_get_browser_line(obj, fl_get_browser(obj)));
  
  if(!string[0])
    {
      if(fl_get_browser_maxline(f_grant->dbf))
	fl_clear_browser(f_grant->dbf);
      grant_activate(NO_SELECT_USER);
      memset(InpDb, '\0', sizeof(struct inputGrant));
      memset(InpUser, '\0', sizeof(struct inputGrant));
      return;
    }
  strcpy(InpUser->host, getSubstr(string, '\t', 0));
  strcpy(InpUser->user, getSubstr(string, '\t', 1));

  /* prend toute l'information de la ligne selectionnee */
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      
      mysql_select_db(&connection, "mysql");
      sprintf(string, "select * from user where host = '%s' and user = '%s' limit 1", InpUser->host, InpUser->user);

      if (!mysql_query(&connection, string))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
	  strcpy(InpUser->host,   row[0]);
	  strcpy(InpUser->user,   row[1]);
	  strcpy(InpUser->password, row[2]);
	  strcpy(InpUser->select, row[3]);
	  strcpy(InpUser->insert, row[4]);
	  strcpy(InpUser->update, row[5]);
	  strcpy(InpUser->delete, row[6]);
	  strcpy(InpUser->create, row[7]);
	  strcpy(InpUser->drop,   row[8]);
	  strcpy(InpUser->reload, row[9]);
	  strcpy(InpUser->shutdown,   row[10]);
	  strcpy(InpUser->process,   row[11]);
	  strcpy(InpUser->file,   row[12]);
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
  
  /* load le browser des usagers pour le host courant */
  grant_getDb(f_grant->dbf, InpUser->host, InpUser->user);
  grant_activate(NO_SELECT_DBF);
}

   


void grant_adduser(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpUser;
  memset(InputGrant, '\0', sizeof(struct inputGrant));
  strcpy(InputGrant->host, InpHost->host);
  main_inputuser(0);
}
void grant_moduser(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpUser;
  main_inputuser(1);
}
void grant_deluser(FL_OBJECT *obj, long data)
{
  int delAll;
  MYSQL connection;

  if(!fl_show_question("You are about to remote access from an user.\nAre you sure?", 0))
    return;
  
  delAll = fl_show_question("Propagate delete to subform db?", 0);
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *query;
      
      query = (char *) malloc(2048);
      if(!query) return;
      
      mysql_select_db(&connection, "mysql");
      sprintf(query,
          "delete from user where user='%s' and host='%s'",
          InpUser->user,InpUser->host);

      if (!mysql_query(&connection, query))
	{
	  result = mysql_store_result(&connection);
	  if(result != NULL) mysql_free_result(result);
	}
      else
	{
	  fl_show_messages(mysql_error(&connection));
	}

	if(delAll)
	  {
	    sprintf(query,
		    "delete from db where host='%s' and user='%s'",
		    InpUser->host,InpUser->user);
	    if (!mysql_query(&connection, query))
	      {
		result = mysql_store_result(&connection);
		if(result != NULL) mysql_free_result(result);
	      }
	    else
	      {
		fl_show_messages(mysql_error(&connection));
	      }
	  }
	free(query);
	mysql_close(&connection);
    }

  if(fl_get_browser_maxline(f_grant->dbf))
    fl_clear_browser(f_grant->dbf);
  grant_activate(NO_SELECT_USER);
  memset(InpDb, '\0', sizeof(struct inputGrant));
  memset(InpUser, '\0', sizeof(struct inputGrant));
  grant_getUsers(f_grant->users, InpHost->host);
}

void grant_dbf(FL_OBJECT *obj, long data)
{
  char string[256];
  
  strcpy(string, fl_get_browser_line(obj, fl_get_browser(obj)));
  
  if(!string[0])
    {
      grant_activate(NO_SELECT_DBF);
      memset(InpDb, '\0', sizeof(struct inputGrant));
      return;
    }

  strcpy(InpDb->host, getSubstr(string, '\t', 0));
  strcpy(InpDb->user, getSubstr(string, '\t', 1));
  strcpy(InpDb->db,   getSubstr(string, '\t', 2));

  /* prend toute l'information de la ligne selectionnee */
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      
      mysql_select_db(&connection, "mysql");
      sprintf(string, "select * from db where host = '%s' and user = '%s' and db = '%s' limit 1", InpDb->host, InpDb->user, InpDb->db);

      if (!mysql_query(&connection, string))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
	  strcpy(InpDb->host,   row[0]);
	  strcpy(InpDb->user,   row[2]);
	  strcpy(InpDb->db,     row[1]);
	  strcpy(InpDb->select, row[3]);
	  strcpy(InpDb->insert, row[4]);
	  strcpy(InpDb->update, row[5]);
	  strcpy(InpDb->delete, row[6]);
	  strcpy(InpDb->create, row[7]);
	  strcpy(InpDb->drop,   row[8]);
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
  
  grant_activate(SELECTED_DBF);
}



void grant_adddbf(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpDb;
  memset(InputGrant, '\0', sizeof(struct inputGrant));
  strcpy(InputGrant->host, InpUser->host);
  strcpy(InputGrant->user, InpUser->user);
  main_inputdb(0);
}

void grant_moddbf(FL_OBJECT *obj, long data)
{
  grant_activate(SELECTED_SUBFORM);
  InputGrant = InpDb;
  main_inputdb(1);
}

void grant_deldbf(FL_OBJECT *obj, long data)
{
  MYSQL connection;

  if(!fl_show_question("You are about to remote a database access from an user.\nAre you sure?", 0))
    return;
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *query;
      
      query = (char *) malloc(2048);
      if(!query) return;
      
      mysql_select_db(&connection, "mysql");
      sprintf(query,
          "delete from db where user='%s' and host='%s' and db='%s'",
          InpDb->user,InpDb->host,InpDb->db);

      if (!mysql_query(&connection, query))
	{
	  result = mysql_store_result(&connection);
	  if(result != NULL) mysql_free_result(result);
	}
      else
	{
	  fl_show_messages(mysql_error(&connection));
	}

	free(query);
	mysql_close(&connection);
    }

  grant_activate(NO_SELECT_DBF);
  memset(InpDb, '\0', sizeof(struct inputGrant));
  grant_getDb(f_grant->dbf, InpUser->host, InpUser->user);
}

void grant_activate(int status)
{
  fl_freeze_form(f_grant->grant);
  if(status != SELECTED_SUBFORM)
    {
      Stat.statusGrant = status;
      fl_activate_object(f_grant->close);
      fl_set_object_lcol(f_grant->close, FL_BLACK);
/*      if(!fl_form_is_visible(f_grant->grant))
	fl_show_form(f_grant->grant, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin Grant/Revoke");
*/	
    }
  switch(status)
    {
  case NO_SELECT_HOST :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_deactivate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_INACTIVE);
      fl_deactivate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_INACTIVE);
      fl_deactivate_object(f_grant->users);
      fl_deactivate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->dbf);
      fl_deactivate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
  case SELECTED_HOST :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_activate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_BLACK);
      fl_activate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_BLACK);
      fl_activate_object(f_grant->users);
      fl_activate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_BLACK);
      fl_deactivate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->dbf);
      fl_deactivate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
  case NO_SELECT_USER :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_activate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_BLACK);
      fl_activate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_BLACK);
      fl_activate_object(f_grant->users);
      fl_activate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_BLACK);
      fl_deactivate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->dbf);
      fl_deactivate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
  case SELECTED_USER :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_activate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_BLACK);
      fl_activate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_BLACK);
      fl_activate_object(f_grant->users);
      fl_activate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_BLACK);
      fl_activate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_BLACK);
      fl_activate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_BLACK);
      fl_activate_object(f_grant->dbf);
      fl_deactivate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
  case NO_SELECT_DBF :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_activate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_BLACK);
      fl_activate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_BLACK);
      fl_activate_object(f_grant->users);
      fl_activate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_BLACK);
      fl_activate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_BLACK);
      fl_activate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_BLACK);
      fl_activate_object(f_grant->dbf);
      fl_activate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_BLACK);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
  case SELECTED_DBF :
    {
      fl_activate_object(f_grant->hosts);
      fl_activate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_BLACK);
      fl_activate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_BLACK);
      fl_activate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_BLACK);
      fl_activate_object(f_grant->users);
      fl_activate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_BLACK);
      fl_activate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_BLACK);
      fl_activate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_BLACK);
      fl_activate_object(f_grant->dbf);
      fl_activate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_BLACK);
      fl_activate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_BLACK);
      fl_activate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_BLACK);
    }
    break;
  case SELECTED_SUBFORM :
    {
/*      fl_hide_form(f_grant->grant); */
      fl_deactivate_object(f_grant->close);
      fl_set_object_lcol(f_grant->close, FL_INACTIVE);
      fl_deactivate_object(f_grant->hosts);
      fl_deactivate_object(f_grant->addHost);
      fl_set_object_lcol(f_grant->addHost, FL_INACTIVE);
      fl_deactivate_object(f_grant->modHost);
      fl_set_object_lcol(f_grant->modHost, FL_INACTIVE);
      fl_deactivate_object(f_grant->delHost);
      fl_set_object_lcol(f_grant->delHost, FL_INACTIVE);
      fl_deactivate_object(f_grant->users);
      fl_deactivate_object(f_grant->addUser);
      fl_set_object_lcol(f_grant->addUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->modUser);
      fl_set_object_lcol(f_grant->modUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->delUser);
      fl_set_object_lcol(f_grant->delUser, FL_INACTIVE);
      fl_deactivate_object(f_grant->dbf);
      fl_deactivate_object(f_grant->addDbf);
      fl_set_object_lcol(f_grant->addDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->modDbf);
      fl_set_object_lcol(f_grant->modDbf, FL_INACTIVE);
      fl_deactivate_object(f_grant->delDbf);
      fl_set_object_lcol(f_grant->delDbf, FL_INACTIVE);
    }
    break;
    }
  fl_unfreeze_form(f_grant->grant);
  fl_redraw_object(f_grant->users);
  fl_redraw_object(f_grant->dbf);
}


void grant_getHosts(FL_OBJECT *browser)
{
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      mysql_select_db(&connection, "mysql");

      if (!mysql_query(&connection, "select host,db from host order by host,db"))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}

void grant_getUsers(FL_OBJECT *browser, char *hostName)
{
  char query[128];
  
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      mysql_select_db(&connection, "mysql");

      sprintf(query, "select host,user from user where host like '%s' order by 1,2", hostName);
      if (!mysql_query(&connection, query))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}


void grant_getDb(FL_OBJECT *browser, char *hostName, char *userName)
{
  char query[128];
  
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      mysql_select_db(&connection, "mysql");

      sprintf(query, "select host,user,db from db where host like '%s' and user like '%s' order by 1,2,3", hostName, userName);
      if (!mysql_query(&connection, query))
      {
        result = mysql_store_result(&connection);
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}
 
void main_grant(FL_OBJECT *obj, long data)
{
  if(Stat.flagGrant) return;
  Stat.flagGrant=1;

  InpHost    = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  InpDb      = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  InpUser    = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  if(!InpHost || !InpDb || !InpUser) 
    {
      Stat.flagGrant = 0;
      if(InpHost)    free(InpHost);
      if(InpDb)      free(InpDb);
      if(InpUser)    free(InpUser);
      return;
    }
  
  f_grant = create_form_grant();
  fl_show_form(f_grant->grant, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin Grant/Revoke");

  fl_freeze_form(f_grant->grant);
  grant_activate(NO_SELECT_HOST);
  grant_getHosts(f_grant->hosts);
  fl_unfreeze_form(f_grant->grant);
}

void grant_close(FL_OBJECT *obj, long data)
{
  free(InpHost);
  free(InpDb);
  free(InpUser);
  fl_hide_form(f_grant->grant);
  fl_free_form(f_grant->grant);
  free(f_grant);
  Stat.flagGrant=0;
}



