/*
   nsform.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: March 1997
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>

int
main(int argc, char **argv, char** env)
{
  NSApplication *theApp;
  NSWindow *win;
  NSRect wf = {{100, 100}, {400, 300}};
  NSRect frame = {{20, 20}, {300, 250}};
  NSForm* form;
  NSView *v;
  NSFormCell *c;
  id pool = [NSAutoreleasePool new];

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

#ifndef NX_CURRENT_COMPILER_RELEASE
  initialize_gnustep_backend();
#endif

  theApp = [NSApplication sharedApplication];

#if 1
  win = [[NSWindow alloc]
	      initWithContentRect:wf
	      styleMask:NSTitledWindowMask
	      backing:NSBackingStoreNonretained
	      defer:NO];
#else
  win = [[NSWindow alloc] init];
#endif
  v = [win contentView];

  form = [[NSForm alloc] initWithFrame:frame];
  c = [form addEntry:@"Field1"];
  [c setEditable:YES];
  [c setStringValue:@"Test"];
  [form addEntry:@"Field2"];
  [form addEntry:@"Field3"];
  [v addSubview:form];

  [win setFrame: wf display: YES];
  [win makeKeyAndOrderFront:nil];
  [win orderFront:nil];

  [theApp run];

  [pool release];
  return 0;
}
