AC_SUBST(MAKE)dnl
AC_SUBST(OBJC_RUNTIME)dnl
AC_SUBST(OBJC_RUNTIME_FLAG)dnl
AC_SUBST(BROKEN_COMPILER)dnl
AC_SUBST(BROKEN_BUILTIN_APPLY)dnl
AC_SUBST(FOUNDATION_LIBRARY)dnl
dnl
dnl
AC_DEFUN(AC_LANG_OBJECTIVE_C,
[AC_REQUIRE([AC_PROG_CC])dnl
define([AC_LANG], [AC_LANG_OBJECTIVE_C])dnl
ac_ext=m
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $OBJC_RUNTIME_FLAG'
ac_compile='${CC-cc} -c $OBJC_RUNTIME_FLAG $CFLAGS conftest.$ac_ext 1>&AC_FD_CC 2>&AC_FD_CC'
ac_link='${CC-cc} -o conftest $OBJC_RUNTIME_FLAG $CFLAGS $LDFLAGS conftest.$ac_ext $LIBS $OBJC_LIBS 1>&AC_FD_CC 2>&AC_FD_CC'
])dnl
dnl
dnl
AC_DEFUN(AC_CHECK_NESTED_FUNCTIONS,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_MSG_CHECKING(whether nested functions work)
AC_CACHE_VAL(ac_cv_nested_functions,
[AC_LANG_SAVE[]dnl
AC_LANG_OBJECTIVE_C[]
AC_TRY_RUN([
f(void (*nested)())
{
    (*nested)();
}

main()
{
    int a = 0;
    void nested()
    {
	a = 1;
    }
    f(nested);
    if(a != 1)
	exit(1);
    exit(0);
}
], ac_cv_nested_functions=yes, ac_cv_nested_functions=no,
ac_cv_nested_functions=yes)
AC_LANG_RESTORE[]
if test $ac_cv_nested_functions = no; then
    AC_MSG_ERROR([
Exception handling facility cannot work without nested functions. You must
obtain the gcc version 2.6.3 or later and try again!
])
fi
])dnl
AC_MSG_RESULT(${ac_cv_nested_functions})
])dnl
dnl
dnl
AC_DEFUN(AC_BROKEN_BUILTIN_APPLY,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_MSG_CHECKING(whether __builtin_apply and __builtin_return are broken)
AC_CACHE_VAL(ac_cv_broken_builtin_apply,
[AC_LANG_SAVE[]dnl
AC_LANG_OBJECTIVE_C[]
AC_TRY_RUN([
#include <objc/Object.h>

float value = 123.456;

@interface MyObject : Object
@end

@implementation MyObject
- (float)floatValue
{
    return value;
}
@end

@interface Forwarder : Object
{
    id object;
}
@end

@implementation Forwarder
- setObject:anObject
{
    object = anObject;
    return self;
}

- (void*)forward:(SEL)selector:(void*)argframe
{
    IMP imp = [object methodFor:@selector(floatValue)];
    void* retframe;
    void* frame = malloc(116);
    *(void**)frame = NULL;
    retframe = __builtin_apply((void(*)(void))imp, frame, 0);
    if(*(long double*)(((char*)retframe) + 8) == (long double)value)
	exit(0);
    exit(1);
}
@end

void main()
{
    id fwd = [[Forwarder alloc] setObject:[MyObject alloc]];
    [fwd floatValue];
    exit(0);
}
], ac_cv_broken_builtin_apply=no,
ac_cv_broken_builtin_apply=yes,
ac_cv_broken_builtin_apply=no)
AC_LANG_RESTORE[]
])dnl
AC_MSG_RESULT(${ac_cv_broken_builtin_apply})
BROKEN_BUILTIN_APPLY=${ac_cv_broken_builtin_apply}
if test $BROKEN_BUILTIN_APPLY = yes; then
    AC_DEFINE(BROKEN_BUILTIN_APPLY)
fi
])dnl
dnl
dnl
