/*
 * ipc_s.h for HP-UX 10.30 and above
 *
 * This header file defines the ipc_s structure for lsof.  The ipc_s structure
 * is the streams equivalent of a Berkeley-style inpcb (Internet Protocol
 * Control Block).  The ipc_s holds the TCP/IP address for a stream.  It is
 * backawrd-linked to the read and write sections of the stream.
 *
 * V, Abell <abe@purdue.edu>
 * February, 1998
 */

#if	!defined(LSOF_IPC_S_H)
#define	LSOF_IPC_S_H

#include "kernbits.h"
#include <sys/types.h>

typedef struct ipc_s {
	KA_T ipc_hash_next;			/* hash link -- ipc_s
						 * structures are hashed in
						 * ipc_tcp_conn[] and
						 * ipc_udp_conn[] */
	uint ipc_mirg;
	KA_T ipc_readers_next;
	KA_T ipc_readers_ptpn;
	KA_T ipc_ptphn;
	KA_T ipc_rq;				/* stream's read queue */
	KA_T ipc_wq;				/* stream's write queue */
	uint32_t d1;				/* Why is this needed? */
	union {
	    struct {
		uint32_t ipcu_lcl_addr;		/* local IP address */
		uint32_t ipcu_rem_addr;		/* remote IP address */
		uint16_t ipcu_rem_port;		/* remote port */
		uint16_t ipcu_lcl_port;		/* local port */
	    } ipcu_addrs;
            uint16_t ipcu_tcp_addr[6];
	} ipc_ipcu;

/*
 * The rest of the q4 elements are ignored.
 */

} ipc_s_t;

#define	ipc_udp_port	ipc_ipcu.ipcu_addrs.ipcu_lcl_port
#define	ipc_udp_addr	ipc_ipcu.ipcu_addrs.ipcu_lcl_addr
#define	ipc_tcp_lport	ipc_ipcu.ipcu_addrs.ipcu_lcl_port
#define	ipc_tcp_laddr	ipc_ipcu.ipcu_addrs.ipcu_lcl_addr
#define	ipc_tcp_fport	ipc_ipcu.ipcu_addrs.ipcu_rem_port
#define	ipc_tcp_faddr	ipc_ipcu.ipcu_addrs.ipcu_rem_addr

#endif	/* !defined(LSOF_IPC_S_H) */
