/*
 *  File:        math_panel.h
 *  Purpose:     Mathed GUI for lyx
 *  Author:      Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *  Created:     March 28, 1996
 * 
 *  Dependencies: Xlib, Xpm, XForms, Lyx
 *
 *  Copyright: (c) 1996, Alejandro Aguilar Sierra 
 *
 *   You are free to use and modify it under the terms of
 *   the GNU General Public Licence version 2 or later.
 */

#ifndef FD_math_panel_h_
#define FD_math_panel_h_

#include "bmtable.h"                 

enum  {
   MM_GREEK, MM_ARROW, MM_BOP, MM_BRELATS, MM_VARSIZE, MM_MISC,
   MM_FRAC, MM_SQRT, MM_DELIM, MM_MATRIX, MM_EQU,
   MM_MAX,
};


typedef FL_OBJECT* FL_OBJECTP;

// Class to manage bitmap menu bars
class BitmapMenu {
   static BitmapMenu *active;
   friend int peek_event(FL_FORM *, void *);
 protected:
   BitmapMenu *next, *prev;
   int nb;             // Number of bitmaps
   int i;              // Current bitmap
   int ww;             // Border width
   int x, y, w, h;
   FL_FORM *form;
   FL_OBJECTP *bitmap;
   FL_OBJECT *button;
 public:
   BitmapMenu(int n, FL_OBJECT* bt, BitmapMenu* prevx=NULL);
   ~BitmapMenu();
   FL_OBJECT* AddBitmap(int id, int nx, int ny, int bw, int bh, char* data, Bool vert=True);
   void Create(void);   
   void Hide(void);
   void Show(void);
   void Prev(void);
   void Next(void);
   int  GetIndex(FL_OBJECT* ob);
};


inline
void BitmapMenu::Prev()  {
   Hide();
   if (prev)
     prev->Show();
}

inline
void BitmapMenu::Next()  {
   Hide();
   if (next)
     next->Show();
}


/**** Callback routines ****/

extern void button_cb(FL_OBJECT *, long);

extern void delim_cb(FL_OBJECT *, long);

extern void matrix_cb(FL_OBJECT *, long);


/**** Forms and Objects ****/

typedef struct {
	FL_FORM *panel;
	FL_OBJECT *greek;
	FL_OBJECT *arrow;
	FL_OBJECT *boperator;
	FL_OBJECT *brelats;
	FL_OBJECT *varsize;
	FL_OBJECT *misc;
	FL_OBJECT *equation;
	FL_OBJECT *sqrt;
	FL_OBJECT *frac;
	FL_OBJECT *delim;
	FL_OBJECT *matrix;
	void *vdata;
	long ldata;
} FD_panel;

extern FD_panel * create_form_panel(void);
extern FD_panel * create_math_panel(void);

typedef struct {
	FL_FORM *delim;
	FL_OBJECT *menu;
	FL_OBJECT *lado;
	FL_OBJECT *right;
	FL_OBJECT *left;
	FL_OBJECT *pix;
	void *vdata;
	long ldata;
} FD_delim;

extern FD_delim * create_form_delim(void);

typedef struct {
	FL_FORM *matrix;
	FL_OBJECT *rows;
	FL_OBJECT *columns;
	FL_OBJECT *valign;
	FL_OBJECT *halign;
	void *vdata;
	long ldata;
} FD_matrix;

extern FD_matrix * create_form_matrix(void);

#endif /* FD_math_panel_h_ */
