#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/servers.tcl,v $
# $Date: 1996/01/31 09:46:44 $
# $Revision: 1.16.1.13 $
#
#
#  Server Operations
#
proc sendStats {net srv param var win} {
    global $var
    if {$param != {}} {
	set val $param
    } {
	set val [set ${var}($win)]
    }
    $net STATS $val $srv
    unset ${var}($win)
}
#
proc serverCmd {net cmd} {
    global zircon
    set srv [$zircon(host) host]
    set def "(Default host is $srv)"
    switch $cmd {
    Oper {
	    global myid
	    set opStuff [$zircon(host) oper]
	    set nk [lindex $opStuff 0]
	    set pw [lindex $opStuff 1]
	    mkEntryBox .@oper Oper {Enter name and password:} \
	      "{Name [expr {$nk == {} ? [$myid name] : $nk}]} \
	      {Password $pw}" "OK {$net OPER}" {Cancel {}}
	}
    Rehash -
    Restart {
    	    set ucmd [string toupper $cmd]
	    mkDialog $ucmd .@$cmd $cmd "Really $cmd $srv?" \
	      {} "OK {$net q1Send $ucmd}" {Cancel {}}
	}
    Stats {
	    global statsInfo
	    set statsInfo {}
	    mkRadioBox .@Stats Stats "Enter Stats parameters $def:" \
	    {c h k i l L m o t u y z} c \
	    {{Server {}} {Parameter {}}} "OK {sendStats $net}" {Cancel {}}
	}
    Links {
	    global linksInfo
	    set linksInfo {}
	    mkEntryBox .@[newName Links] Links "Enter Links parameters $def:" \
	      {{Server {}} {Mask {}}} "OK {$net send LINKS}" {Cancel {}}
	}
    Connect {
	    mkEntryBox .@[newName Con] Connect "Enter Connect parameters $def:" \
	      {{Server {}} {Port {}} {Remote {}}} \
	      "OK {$net send CONNECT}" {Cancel {}}
	}
    Info {
	    global infoInfo
	    set infoInfo {}
	    mkEntryBox .@[newName Inf] Info "Enter Server name $def:" \
	      {{Server {}}} "OK {$net qSend INFO}" {Cancel {}}
	}
    Squit {
	    mkEntryBox .@[newName sq] Squit "Enter Server name :" \
	      {{Server {}}} "OK {doSquit $net}" {Cancel {}}
	}
    Trace {
	    global traceInfo
	    set traceInfo {}
	    mkEntryBox .@[newName tr] Trace "Enter server name $def:" \
	      {{Server {}}} "OK {$net send TRACE}" {Cancel {}}
	}
    Motd {
	    mkEntryBox .@[newName motd] MOTD "Enter server name $def:" \
	      {{Server {}}} "OK {$net send MOTD}" {Cancel {}}
	}
    default {
	    set ucmd [string toupper $cmd]
	    mkEntryBox .@$cmd $cmd "Enter server pattern $def:" {{Server {}}}\
	      "OK {$net send $ucmd}" {Cancel {}}
	}
    }
}
#
proc doSquit {net srv} {
    if {$srv != {}} {
	set w .@[newName squit]
	mkDialog SQUIT $w Squit "Really Squit server \"$srv\"?" \
	  {} "OK {$net qSend SQUIT :$srv}" {Cancel {}}
	tkwait window $w ;# This seems to be needed...
    }
}
#
proc kill {net who} {
    mkDialog {} .@[newName kill] Kill "Really kill $who?" \
      {{Message {}}} "OK {doKill $net $who}" {Cancel {}}
}
#
proc doKill {net nk msg} {
    if {$nk != {}} { $net KILL $nk $msg }
}
#
proc userKill {net} {
    mkEntryBox .@ukill "Kill" {Enter user name and message:} \
      {{User {}} {Message {}}} "OK {doKill $net}" {Cancel {}}
}

proc statsProc {prefix param args} {
    global statsInfo
    set p [string range $prefix 1 end]:
    foreach a [lrange [lindex $args 0] 1 end] { if {$a != {}} {append p " $a"}}
    if {$param != {}} {append p " $param"}
    append statsInfo "$p\n"
}

proc traceProc {net prefix param args} {
    set p [string range $prefix 1 end]:
    foreach a [lrange [lindex $args 0] 1 end] {	if {$a != {}} {append p " $a"}}
    if {$param != {}} {append p " $param"}
    $net display {} $p
}
#
proc irc201 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc202 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc203 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc204 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc205 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc208 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
proc irc261 {net prefix param pargs} { traceProc $net $prefix $param $pargs }
#
proc irc211 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc212 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc213 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc214 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc215 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc216 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc218 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc241 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc242 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc243 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc244 {net prefix param pargs} { statsProc $prefix $param $pargs }
proc irc249 {net prefix param pargs} { statsProc $prefix $param $pargs }
#
proc tracewin {net prefix param pargs} {
    global wstat
    set prefix [string range $prefix 1 end]
    if ![info exists wstat($prefix)] {
	set w [toplevel .@[newName trace] -class Zircon]
	wm resizable $w 1 1
	wm protocol $w WM_DELETE_WINDOW "destroy $w ; unset wstat($prefix)"
	wm title $w "Trace for $prefix"
	set f [frame $w.f1]
	scrollbar $f.vs -command "$f.txt yview"
        text $f.txt -yscrollcommand "$f.vs set" -width 60 -height 10 \
	  -takefocus 0
	bindtags $f.txt ROText
	pack $f.vs -side right -fill y
	pack $f.txt -fill both -expand 1 -side left
	pack $f -fill both -expand 1
	pack [frame $w.f2] -fill x
	pack [button $w.f2.xit -text Dismiss -command "destroy $w ; \
	   unset wstat($prefix)" -width 10] -expand 1 -side left
	pack [button $w.f2.trc -text Trace -command "$net qSend TRACE :$prefix" \
	  -width 10] -expand 1 -side left
	set wstat($prefix) $w
    } {
	set w $wstat($prefix)
    }
    foreach a [lrange $pargs 1 end] {
	if {$a != {}} {$w.f1.txt insert end " $a"}
    }
    if {$param != {}} {$w.f1.txt insert end " $param"}
    $w.f1.txt insert end "\n"
}
#
proc irc200 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    tracewin $net :[lindex $pargs 3] $param $pargs
}
#
proc irc206 {net prefix param pargs} { tracewin $net $prefix $param $pargs }
#
proc irc219 {net prefix param pargs} {
    global statsInfo
    if [info exists statsInfo] {
	set w .@[newName stats]
	mkInfoBox STATS $w \
	  "[string range $prefix 1 end] Stats [getDate]" $statsInfo {OK {}}
	unset statsInfo
    }
}
#
proc irc364 {net prefix param pargs} {
    global linksInfo
    regsub -all {\\} $pargs {\\\\} pargs
    append linksInfo "[lindex $pargs 1] [lindex $pargs 2] ${param}\n"
}
#
proc irc365 {net prefix param pargs} {
    global linksInfo
    if ![info exists linksInfo] { set linksInfo {No Links} }
    set w .@[newName links]
    mkInfoBox LINKS $w "[string range $prefix 1 end] Links [getDate]" $linksInfo {OK {}}
    unset linksInfo
}
#
proc irc371 {net prefix param pargs} {
    global infoInfo
    append infoInfo "${param}\n"
}
#
proc irc374 {net prefix param pargs} {
    global infoInfo
    set w .@[newName info]
    mkInfoBox INFO $w "[string range $prefix 1 end] Info [getDate]" $infoInfo {OK {}}
    unset infoInfo
}
