#
# $Source: /user/nlfm/Working/Zircon/Development/lib/RCS/Help.tcl,v $
# $Date: 1996/01/08 12:37:08 $
# $Revision: 1.2 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
proc makeHelp {win nm} {
    $win delete 0 end
    global zircon
    if {[set st [glob -nocomplain $zircon(lib)/help/$nm/*]] == {}} {
	$win add command -label {Sorry, not yet available.} -command {}
    } {
	foreach x $st {
	   set tx [file tail $x]
	   $win add command -label $tx \
	      -command "zHelpWind .@$nm$tx $x {Zircon Help : $nm > $tx}"
	}
    }
}
#
proc zHelpWind {ctl file title} {
    if [winfo exists $ctl] { popup $ctl ; return }
    toplevel $ctl -class Zircon -borderwidth 2
    set oFrm $ctl
    wm title $ctl $title
    wm resizable $ctl 1 1
    wm protocol $ctl WM_DELETE_WINDOW "destroy $ctl"
    set f [frame $ctl.t]
    scrollbar $f.vs -command "$f.txt yview"
    text $f.txt -yscrollcommand "$f.vs set" -height 10 -width 40
    $f.txt tag configure input -foreground red
    $f.txt tag configure output -foreground black
    pack $f.vs -side right -fill y
    pack $f.txt -side left -expand 1 -fill both
    pack $f -fill both -expand 1
    set f [frame $ctl.btn]
    button $f.close -text Dismiss -command "destroy $ctl"
    pack $f.close -expand 1 -side left
    pack $f -fill x
    set desc [open $file r]
    while {![eof $desc]} {
	gets $desc buffer
	$ctl.t.txt insert end "$buffer\n"
    }
    close $desc
    $ctl.t.txt configure -state disabled
}
