#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Chat.tcl,v $
# $Date: 1996/03/08 10:32:18 $
# $Revision: 1.16.1.8 $
#
global defChat
set defChat {}
#
proc Chat {name args} {
    if {$name == {::}} {
	set op [lindex $args 0]
	if {[info procs Chat_$op] != {}} {
	    return [eval Chat_$op [lrange $args 1 end] ]
	} {
	    return [eval Channel_$op [lrange $args 1 end] ]
	}
    }
    if {[set id [Chat :: find $name]] == {nil}} { set id [makeChat $name] }
    if {$args != {}} { eval $id configure $args }
    return $id
}
#
proc chat_action {this string} { $this send $string }
#
proc chat_send {this string args} {
    notIdle {}
    if {$string != {}} {
	global Chat monitorOut
	if [info exists Chat($this)] {
	    if [catch [list puts $Chat($this) $string] err] {
		$this addText {} "*** Error : $err"
	    } {
		flush $Chat($this)
		$this addText @me "= $string"
	        if $monitorOut { zOut "= $string" }
	    }
	} {
	    $this addText {} {*** Connection is closed!!!!}
	}
    }
}
#
proc chat_call {this op args} {
    switch $op {
    default {
	    if {[info procs chat_$op] == {}} {
		eval channel_call $this $op $args
	    } {
		eval chat_$op $this $args
	    }
	}
    }
}
#
proc makeChat {chan} {
    global CHTO defChat defChan
    set this [objName Chat]
    proc $this {args} " eval chat_call $this \$args "
    initObj $this Channel
    upvar #0 $this cdata
    set lchan [string tolower $chan]
    if [string match {} [set def $defChat]] {
	set b 0
	set def $defChan
    } {
	set b [$def buttons]
    }
    array set cdata [uplevel #0 array get $def]
    set cdata(buttons) $b
    set cdata(draw) 0
    set cdata(name) $chan
    set cdata(lname) $lchan
    set CHTO($lchan) $this
    return $this
}
#
proc chat_delete {this} {
    global Name Chat CHTO
    upvar #0 $this cdata
    if ![string match {} $cdata(log)] { close $cdata(log) }
    catch {unset Name([$this window])}
    $this configure -window {}
    set chan $cdata(lname)
    unset CHTO($chan) cdata
    rename $this {}
    if [info exists Chat($this)] { closeChat $this $chan $Chat($this) }
}
#
proc chat_leave {this} {
    set chan [$this name]
    set msg "Really leave DCC chat with $chan?"
    mkDialog LEAVE .@$this "Leaving $chan" $msg {} \
      "OK {$this doLeave {}}" {Cancel {}}
}
#
proc Chat_make {name} {
    global CHTO
    set ln [string tolower $name]
    if [info exists CHTO($ln)] { return $CHTO($ln) } { return [Chat $name]}
}
#
proc Chat_find {name} {
    global CHTO
    set ln [string tolower $name]
    return [expr {[info exists CHTO($ln)] ? $CHTO($ln) : {nil}}]
}
#
proc Chat_save {desc} {
    global defChat
    if ![string match {} $defChat] { $defChat save $desc }
}
#
proc chat_save {this desc} {
    global defChat
    set ln [mncSave $this $desc $defChat]
    foreach op {logfile icon} {
	if {[set v [$this $op]] != {}} { append ln " -$op {$v}"	}
    }
    puts $desc $ln
    foreach  b [$this bindings] {
	puts $desc "zbind [$this name] [lindex $b 0] {[lindex $b 1]}"
    }
}
