/*
 * Lynx - Hypertext navigation system
 *
 *   (c) Copyright 1992, 1993, 1994 University of Kansas
 */

/*******************************************************************
 * There are three sections to this document
 *  Section 1.  Things you MUST change or verify
 *	Section 1a)  VMS specific things
 *	Section 1b)  UNIX specific things
 *	Section 1c)  ALL Platforms
 *
 *  Section 2.  Things you should probably check!
 *
 *  Section 3.  Things you should only change after you have a good
 *              understanding of the program!
 *
 */

#ifndef USERDEFS_H
#define USERDEFS_H

/*******************************************************************
 * Things you must change
 *  Section 1. 
 */

/*******************************************************************
 * Things you must change  VMS specific
 *  Section 1a). 
 */
#ifdef VMS
/**************************
 * TEMP_SPACE is where Lynx temporary cache files will be placed.
 * Temporary files are removed automatically as long as nothing
 * goes terribly wrong :)
 * This definition can be overridden at run time by defining a
 * "LYNX_TEMP_SPACE" VMS logical.
 */
#define TEMP_SPACE "sys$scratch:"

/**************************
 * LYNX_CFG_FILE is the location and name of the default lynx
 * global configuration file.  It is sought and processed at
 * startup of Lynx, followed by a seek and processing of a
 * personal RC file (.lynxrc in the user's HOME directory,
 * created if the user saves values in the 'o'ptions menu).
 * You also can define the location and name of the global
 * configuration file via a VMS logical, "LYNX_CFG", which
 * will override the "LYNX_CFG_FILE" definition here.  SYS$LOGIN:
 * can be used as the device in either or both definitions if
 * you want lynx.cfg treated as a personal configuration file.
 * You also can use Unix syntax with a '~' for a subdirectory
 * of the login directory, (e.g., ~/lynx/lynx.cfg).
 * The -cfg command line switch will override these definitions.
 * You can pass the compilation default via build.com or descrip.mms.
 *
 * Note that any SUFFIX or VIEWER mappings in the configuration
 * files will be overidden by any suffix or viewer mappings
 * that are established as defaults in src/HTInit.c.
 */
#ifndef LYNX_CFG_FILE
#define LYNX_CFG_FILE "Lynx_Dir:lynx.cfg"
#endif /* LYNX_CFG_FILE */

/**************************
 * The EXTENSION_MAP file allows you to map file suffix's to 
 * mime types.
 * These global and personal files override anything in
 * lynx.cfg or src/HTInit.c
 */
#define GLOBAL_EXTENSION_MAP "Lynx_Dir:mime.types"
#define PERSONAL_EXTENSION_MAP "mime.types"

/**************************
 * The MAILCAP file allows you to map file MIME types to 
 * external viewers.
 * These global and personal files override anything in
 * lynx.cfg or src/HTInit.c
 */ 
#define GLOBAL_MAILCAP "Lynx_Dir:mailcap"
#define PERSONAL_MAILCAP ".mailcap"

/**************************
 * This define will be used for a default in src/HTInit.c.
 * Make it the full path and name of the xloadimage command.
 * Put 'echo' or something like it here if you don't have it.
 * It can be anything that will handle GIF, TIFF and other
 * popular image formats (xv does).
 * You must also have a "%s" for the filename
 */
#define XLOADIMAGE_COMMAND "xv %s"

/**************************
 * The full path and name of the standard VMS "mail" command.
 *
 * The mail command will be spawned as a subprocess of lynx
 * and used to send replies and error messages.  It must be
 * defined here, and can be changed in lynx.cfg.
 * SYSTEM_MAIL must be able to accept a subject line through
 * the use of the /subject="SUBJECT" option.
 * If your mailer uses another syntax, some hacking of the
 * mailmsg() and reply_by_mail() functions in LYMail.c may
 * be required.
 */
#define SYSTEM_MAIL "mail"

/*************************
 * below is the argument for an sprintf command that will add
 * "IN%""ADDRESS""" to the Internet mail address given by the user.
 * It is structured for PMDF's IN%"INTERNET_ADDRESS" scheme.  The %s
 * is replaced with the address given by the user.  If you are using
 * a different Internet mail transport, change the IN appropriately
 * (e.g., to SMTP, MX, or WINS), here or in lynx.cfg.
 */
#define MAIL_ADRS "\"IN%%\"\"%s\"\"\""

/*************************
 * The foreign command for the ANU-NEWS client (presumably "NEWS").
 * which serves as a transparent vector for posting to newsgroups
 * from Lynx via the ANU-NEWS client's server.  The account running
 * Lynx must have access to the ANU-NEWS client, which in turn must
 * have posting privileges (the news server could also be ANU-NEWS,
 * or any other server to which the ANU-NEWS client has access).
 *
 * The ANU-NEWS software for VMS is available from ftp.cc.ukans.edu.
 *
 * Define INEWS as "none" if you do not have access to an ANU-NEWS
 * client with a server for posting to newsgroups from Lynx.
 */
#define INEWS "NEWS"

/*********************************
 * If USE_FIXED_RECORDS is set to TRUE here and/or in lynx.cfg, Lynx will
 * convert 'd'ownloaded binary files to FIXED 512 record format before saving
 * them to disk or acting on a DOWNLOADER option.  If set to FALSE, the
 * headers of such files will indicate that they are Stream_LF with Implied
 * Carriage Control, which is incorrect, and can cause downloading software
 * to get confused and unhappy.  If you do set it FALSE, you can use the
 * FIXED512.COM command file, which is included in this distribution, to do
 * the conversion externally.
 */
#define USE_FIXED_RECORDS	TRUE	/* convert binaries to FIXED 512 */

/********************************
 * If NO_ANONYMOUS_EMAIL is defined, Lynx will not offer to insert X-From
 * and X_Personal_Name lines in the body of email messages.  On VMS, the
 * actual From and Personal Name (if defined for the account) headers always
 * are those of the account running the Lynx image.  If the account is not
 * the one to which the recipient should reply, you can indicate the alternate
 * address and personal name via the X-From and X_Personal_Name entries, but
 * the recipient must explicitly send the reply to the X_From address, rather
 * than using the VMS REPLY command (which will use the actual From address).
 *
 * This symbol constant might be defined on Unix for security reasons that
 * don't apply on VMS.  There is no security reason for defining this on VMS,
 * but if you have no anonymous accounts (i.e., the From always will point to
 * the actual user's email address, you can define it to avoid the bother of
 * X-From and X_Personal_Name offers.
 */
/*#define NO_ANONYMOUS_EMAIL TRUE */

/*******************************************************************
 * Things you must change  UNIX specific
 *  Section 1b). 
 */
#else     /* UNIX */

/**************************
 * LYNX_CFG_FILE is the location and name of the default lynx
 * global configuration file.  It is sought and processed at
 * startup of Lynx, followed by a seek and processing of a
 * personal RC file (.lynxrc in the user's HOME directory,
 * created if the user saves values in the 'o'ptions menu).
 * You also can define the location and name of the global
 * configuration file via an environment variable, "LYNX_CFG",
 * which will override the "LYNX_CFG_FILE" definition here.
 * You can use '~' in either or both definitions if you want
 * lynx.cfg treated as a personal configuration file.  The
 * -cfg command line switch will override these definitions.
 * You can pass the compilation default via the Makefile.
 *
 * Note that any SUFFIX or VIEWER mappings in the configuration
 * files will be overidden by any suffix or viewer mappings
 * that are established as defaults in src/HTInit.c.
 */
#ifndef LYNX_CFG_FILE
#define LYNX_CFG_FILE "/etc/lynx.cfg"
#endif /* LYNX_CFG_FILE */

/**************************
 * The EXTENSION_MAP file allows you to map file suffix's to 
 * mime types.
 * These global and personal files override anything in
 * lynx.cfg or src/HTInit.c
 */
#define GLOBAL_EXTENSION_MAP "/etc/mime.types"
#define PERSONAL_EXTENSION_MAP ".mime.types"

/**************************
 * The MAILCAP file allows you to map file MIME types to 
 * external viewers.
 * These global and personal files override anything in
 * lynx.cfg or src/HTInit.c
 */
#define GLOBAL_MAILCAP "/etc/mailcap"
#define PERSONAL_MAILCAP ".mailcap"

/*********************
 * LOCAL_DOMAIN is used to determine if a user is local
 * to your campus or organization
 */
#define LOCAL_DOMAIN "ukans.edu"		/* CHANGE THIS! */

/**************************
 * the full path and name of the telnet command
 */
#define TELNET_COMMAND "telnet"

/**************************
 * the full path and name of the tn3270 command
 */
#define TN3270_COMMAND "tn3270"

/**************************
 * the full path and name of the rlogin command
 */
#define RLOGIN_COMMAND "rlogin"

/*************************
 * This define will be used for a default in src/HTInit.c.
 * Make it the full path and name of the xloadimage command.
 * Put 'echo' or something like it here if you don't have it.
 * It can be anything that will handle GIF, TIFF and other
 * popular image formats (xv does).
 * You must also have a "%s" for the filename; "&" for
 * background is optional
 */
#define XLOADIMAGE_COMMAND "xv %s &"

/*************************
 * The full path and name of the inews program
 *
 * A "mini" inews has been included in the utils directory.
 *
 * set empty or to "none" if you don't have or want it.
 */
#define INEWS "/usr/bin/inews"

/**************************
 * For UNIX systems this should be sendmail
 * sendmail should be in /usr/lib 
 *
 * You definitely want sendmail, not mail or elm or something else,
 * except in the case where MMDF is your mail agent.
 * For MMDF you should use submit (SCO)
 *
 * SYSTEM_MAIL must be defined here.  You can change it in lynx.cfg.
 *
 * If you do not use the recommended mailers, some hacking of
 * the mailmsg() and reply_by_mail() functions in LYMail.c, or
 * interposition of a script, may be required.
 */
#ifdef MMDF
#define SYSTEM_MAIL "/usr/mmdf/bin/submit" 
#else
#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__bsdi__)
#define SYSTEM_MAIL "/usr/sbin/sendmail"
#else /* everthing else: */
#define SYSTEM_MAIL "/usr/lib/sendmail" 
#endif /* __FreeBSD || __NetBSD__ || __bsdi__ */
#endif /* MMDF */

/**************************
 * A place to put temporary files, it's almost always "/tmp/" on
 * UNIX systems
 * This definition can be overridden at run time by setting a
 * "LYNX_TEMP_SPACE" environment symbol.
 */
#define TEMP_SPACE "/tmp/"

/********************************
 * Don't let the user enter his/hers email address when sending a message.
 * Anonymous mail makes it far too easy for a user to spoof someone elses
 * email address.
 * This requires that your mailer agent put in the From: field for you.

 * The default should be to uncomment this line but there probably are too
 * many mail agents out there that won't do the right thing if there is no
 * From: line.
 */
/* #define NO_ANONYMOUS_EMAIL TRUE */

/********************************
 * LIST_FORMAT defines the display for local files when LONG_LIST
 * is defined in the Makefile.  The default set here can be changed
 * in lynx.cfg.
 *
 * The percent items in the list are interpreted as follows:
 *
 *	%p	Unix-style permission bits
 *	%l	link count
 *	%o	owner of file
 *	%g	group of file
 *	%d	date of last modification
 *	%a	anchor pointing to file or directory
 *	%A	as above but don't show symbolic links
 *	%k	size of file in Kilobytes
 *	%K	as above but omit size for directories
 *
 * Anything between the percent and the letter is passed on to sprintf.
 * A double percent yields a literal percent on output.  Other characters
 * are passed through literally.
 *
 * If you want only the filename:  "    %a"
 *
 * If you want a brief output:     "    %4K %-12.12d %a"
 *
 * For the Unix "ls -l" format:    "    %p %4l %-8.8o %-8.8g %7s %-12.12d %a"
 */
#define LIST_FORMAT "    %p %4l %-8.8o %-8.8g %7s %-12.12d %a"

#endif /* VMS OR UNIX */

/*************************************************************
 *  Section 1c)   Every platform must change or verify these
 *
 */

/*****************************
 * STARTFILE is the default file if none is specified on the command line
 * or via a WWW_HOME environment variable.
 * 
 * note: STARTFILE must be a URL.  See the Lynx online help for more
 *       information on URL's
 */
#define STARTFILE "http://www.cc.ukans.edu/about_lynx/www_start.html"
/* #define STARTFILE "http://www.w3.org/default.html" */
/* #define STARTFILE "http://kufacts.cc.ukans.edu/cwis/kufacts_start.html" */

/*****************************
 * HELPFILE must be defined as a URL and must have a 
 * complete path if local:
 * file://localhost/PATH_TO/lynx_help/lynx_help_main.html
 *   Replace PATH_TO with the path to the lynx_help subdirectory
 *   for this distribution (use SHELL syntax including the device
 *   on VMS systems).
 * The default HELPFILE is:
 * http://kufacts.cc.ukans.edu/lynx_help/lynx_help_main.html
 *   This should be changed here or in lynx.cfg to the local path.
 */
/* #define HELPFILE "http://www.cc.ukans.edu/lynx_help/lynx_help_main.html" */
#define HELPFILE "file://localhost/usr/lib/lynx_help/lynx_help_main.html"

/*****************************
 * DEFAULT_INDEX_FILE is the default file retrieved when the
 * user presses the 'I' key when viewing any document.
 * An index to your CWIS can be placed here or a document containing
 * pointers to lots of interesting places on the web.
 */
#define DEFAULT_INDEX_FILE "http://www.w3.org/default.html"

/*******************************
 * If GOTOBUFFER is set to TRUE here or in lynx.cfg the last entered
 * goto URL, if any, will be offered as a default for reuse or editing
 * when the 'g'oto command is entered.  All previously used goto URLs
 * can be accessed for reuse or editing via a circular buffer invoked
 * with the Up-Arrow or Down-Arrow keys after entering the 'g'oto
 * command, whether or not a default is offered.
 */
#define GOTOBUFFER	  FALSE

/*****************************
 * JUMPFILE is the default local file checked for shortcut URL's when
 * the user presses the 'J' (JUMP) key.  The user will be prompted for
 * a shortcut entry (analogously to 'g'oto), and can enter one
 * or use '?' for a list of the shortcuts with associated links to
 * their actual URL's.  See the sample jumps files in the samples
 * subdirectory.  Make sure your jumps file includes a '?' shortcut
 * for a file://localhost URL to itself:
 *
 * <dt>?<dd><a href="file://localhost/path/jumps.html">This Shortcut List</a>
 *
 * If not defined here or in lynx.cfg, the JUMP command will invoke
 * the NO_JUMPFILE statusline message.  The prompt associated with the
 * default jumps file is defined as JUMP_PROMPT, below, and can be modified
 * in lynx.cfg.  Additional, alternate jumps files can be defined and
 * mapped to keystrokes, and alternate prompts can be set for them, in
 * lynx.cfg, but at least one default jumps file and associated prompt
 * should be established before adding others.
 *
 * On VMS, use Unix SHELL syntax (including a lead slash) to define it.
 *
 * Do not include "file://localhost" in the definition.
 */
/* #define JUMPFILE "/Lynx_Dir/jumps.html" */

/*******************************
 * The "not available" statusline message, and default prompt,
 * for Jumps.  The default prompt can be changed in lynx.cfg.
 */
#define NO_JUMPFILE "No jump file is currently available."
#define JUMP_PROMPT "Jump to (use '?' for list): "

/*******************************
 * If JUMPBUFFER is set to TRUE here or in lynx.cfg the last entered
 * jump shortcut, if any, will be offered as a default for reuse or
 * editing when the JUMP command is entered.  All previously used
 * shortcuts can be accessed for reuse or editing via a circular buffer
 * invoked with the Up-Arrow or Down-Arrow keys after entering the JUMP
 * command, whether or not a default is offered.  If you have multiple
 * jumps files and corresponding key mappings, each will have its own
 * circular buffer.
 */
#define JUMPBUFFER	  FALSE

/********************************
 * If PERMIT_GOTO_FROM_JUMP is defined, then a : or / in a jump target
 * will be treated as a full or partial URL (to be resolved versus the
 * startfile), and will be handled analogously to a 'g'oto command.
 * Such "random URLs" will be entered in the circular buffer for goto
 * URLs, not the buffer for jump targets (shortcuts).  If the target
 * is the single character ':', it will be treated equivalently to an
 * Up-Arrow or Down-Arrow following a 'g'oto command, for accessing the
 * circular buffer of goto URLs.
 */
/* #define PERMIT_GOTO_FROM_JUMP */

/*****************************
 * If LYNX_HOST_NAME is defined here and/or in lynx.cfg, it will be
 * treated as an alias for the local host name in checks for URLs on
 * the local host (e.g., when the -localhost switch is set), and this
 * host name, "localhost", and HTHostName (the fully qualified domain
 * name of the system on which Lynx is running) will all be passed as
 * local.  A different definition in lynx.cfg will override this one.
 */
/* #define LYNX_HOST_NAME "www.cc.ukans.edu" */

/********************************
* The DEFAULT_CACHE_SIZE specifies the number of WWW documents to be
* cached in memory at one time.
*
* This so-called cache size (actually, number) may be modified with the
* command line argument -cache=NUMBER
*
* On Unix, and VMS not compiled with VAXC, whenever the number is exceeded
* the oldest document will be removed from memory.
*
* On VMS compiled with VAXC, the DEFAULT_VIRTUAL_MEMORY_SIZE specifies the
* amount (bytes) of virtual memory that can be allocated and not yet be freed
* before previous documents are removed from memory.  If the values for both
* the DEFAULT_CACHE_SIZE and DEFAULT_VIRTUAL_MEMORY_SIZE are exceeded, then
* documents will be freed until one or the other is no longer exceeded.  The
* minimum allowed value for the DEFAULT_CACHE_SIZE is 2, for the current
* document and at least one to fetch, and there is no absolute maximum number
* of cached documents.  They will continue to be cached until the value of
* DEFAULT_VIRTUAL_MEMORY_SIZE is exceeded, at which point the oldest one(s)
* will be "deleted" (freed from memory) until the DEFAULT_VIRTUAL_MEMORY_SIZE
* no longer is exceeded, or the number of documents has been reduced to that
* specified by DEFAULT_CACHE_SIZE.
*
* The Unix and VMS but not VAXC implementations use the C library malloc's
* and calloc's for memory allocation, and procedures for taking the actual
* amount of cache into account still need to be developed.  They use only
* the DEFAULT_CACHE_SIZE value, and that specifies the absolute maximum
* number of documents to cache (rather than the maximum number only if
* DEFAULT_VIRTUAL_MEMORY_SIZE has been exceeded, as with VAXC/VAX).
*/
#define DEFAULT_CACHE_SIZE 10

#if defined(VMS) && defined(VAXC) && !defined(__DECC)
#define DEFAULT_VIRTUAL_MEMORY_SIZE 512000
#endif /* VMS && VAXC && !__DECC */

/********************************
 * If ALWAYS_RESUBMIT_FORMS is set TRUE, Lynx always will submit
 * forms, dumping any cache from a previous submission of the form
 * with the same content.  If FALSE, the user retains the option to
 * resubmit via the RESUBMIT command, and is informed of the option
 * via the statusline when positioned on a form submit button.
 *
 * The default defined here can be changed in lynx.cfg, and can be
 * toggled via the -resubmit_forms command line switch.
 */
#define ALWAYS_RESUBMIT_FORMS FALSE

/*****************************
 * PREFERRED_LANGUAGE is the language in MIME notation (e.g., "en",
 * "fr") which will be indicated by Lynx in its Accept-Language headers
 * as the preferred language.  If available, the document will be
 * transmitted in that language.  This definition can be overriden via
 * lynx.cfg.  Users also can change it via the 'o'ptions menu and save
 * that preference in their RC file. This may be a comma-separated list
 * of languages in decreasing preference.
 */
#define PREFERRED_LANGUAGE "en"

/*****************************
 * PREFERRED_CHARSET specifies the character set in MIME notation (e.g.,
 * "ISO-8859-2", "ISO-8859-5") which Lynx will indicate you prefer in
 * requests to http servers using an Accept-Charsets header.  The value
 * should NOT include "ISO-8859-1" or "US-ASCII", since those values are
 * always assumed by default.  If a file in that character set is available,
 * the server will send it.  Otherwise, the server will send the file in
 * ISO-8859-1 or US-ASCII.  Users can change or eliminate this definition
 * via the 'o'ptions menu and save that preference in their RC file.
 */
#define PREFERRED_CHARSET ""


/****************************************************************
 *   Section 2.   Things that you probably want to change or review
 *
 */

/*****************************
 * The following three definitions set the number of seconds for
 * pauses following statusline messages that would otherwise be
 * replaced immediately, and are more important than the unpaused
 * progress messages.  Those set by INFOSECS are also basically
 * progress messages (e.g., that a prompted input has been cancelled)
 * and should have the shortest pause.  Those set by MESSAGESECS are
 * informational (e.g., that a function is disabled) and should have
 * a pause of intermediate duration.  Those set by ALERTSECS typically
 * report a serious problem and should be paused long enough to read
 * whenever they appear (typically unexpectedly).  The default values
 * defined here can be modified via lynx.cfg, should longer pauses be
 * desired for braille-based access to Lynx.
 */
#define INFOSECS 1
#define MESSAGESECS 2
#define ALERTSECS 3

/*****************************
 * Enter the name of your anonymous account if you have one
 * as ANONYMOUS_USER.  UNIX systems will use a cuserid
 * or get_login call to determine if the current user is
 * the ANONYMOUS_USER.
 *
 * VMS systems cannot use this feature, so they must specify
 * anonymous accounts using the "-anonymous" command line option.
 *
 * Other systems may use the "-anonymous" option for multiple
 * accounts or precautionary reasons as well.
 *
 * It is very important to have this correctly defined if you 
 * have an anonymous account.  If you do not you will be putting 
 * yourself at GREAT security risk!
 *
 * Later on in this file you can specify privileges for the
 * anonymous account.
 */
#define ANONYMOUS_USER "" 

/******************************
 * SHOW_CURSOR controls whether or not the cursor is hidden
 * or appears over the link.  This is just the default, it
 * can be turned on with the -show_cursor command line option.
 * Showing the cursor is handy if you have really stupid terminals
 * that can't do bold and reverse video at the same time or at all.
 */
#define SHOW_CURSOR FALSE

/******************************
 * BOXVERT and BOXHORI control the layout of popup menus.  Set to 0 if your
 * curses supports line-drawing characters, set to '*' or any other character
 * to not use line-drawing (e.g., '|' for vertical and '-' for horizontal).
 */
#define BOXVERT '*'
/* #define BOXVERT 0 */
#define BOXHORI '*'
/* #define BOXHORI 0 */

/******************************
 * LY_UMLAUT controls the 7-bit expansion of characters with dieresis or
 * umlaut.  If defined, a digraph is displayed, e.g., auml --> ae
 * Otherwise, a single character is displayed,  e.g., auml --> a
 */
#define LY_UMLAUT

/*******************************
 * set to FALSE if you don't want users of your anonymous account
 * who are calling from inside your local domain
 * to be able to telnet back out
 */
#define CAN_ANONYMOUS_INSIDE_DOMAIN_TELNET	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from outside your
 * local domain to be able to telnet back out
 */
#define CAN_ANONYMOUS_OUTSIDE_DOMAIN_TELNET	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous account
 * who are calling from inside your local domain
 * to be able to read news
 */
#define CAN_ANONYMOUS_INSIDE_DOMAIN_READ_NEWS	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from outside your
 * local domain to be able to read news
 */
#define CAN_ANONYMOUS_OUTSIDE_DOMAIN_READ_NEWS	FALSE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from inside your local domain
 * to be able to use ftp
 */
#define CAN_ANONYMOUS_INSIDE_DOMAIN_FTP		TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from outside your local domain
 * to be able to use ftp
 */
#define CAN_ANONYMOUS_OUTSIDE_DOMAIN_FTP	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from inside your local domain 
 * to be able to use rlogin
 */
#define CAN_ANONYMOUS_INSIDE_DOMAIN_RLOGIN	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from outside your local domain
 * to be able to use rlogin
 */
#define CAN_ANONYMOUS_OUTSIDE_DOMAIN_RLOGIN	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to goto random URL's. (The 'g' command)
 */
#define CAN_ANONYMOUS_GOTO		TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to specify a port in 'g'oto commands
 * for telnet URL's.
 */
#define CAN_ANONYMOUS_GOTO_TELNET_PORT	FALSE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to jump to URL's (The 'J' command)
 * via the shortcut entries in your JUMPFILE.
 */
#define CAN_ANONYMOUS_JUMP	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to mail
 */
#define CAN_ANONYMOUS_MAIL	TRUE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to print
 */
#define CAN_ANONYMOUS_PRINT	FALSE

/*******************************
 * Execution links/scripts configuration.
 *
 * Execution links and scripts allow you to run
 * local programs by activating links within Lynx.
 *
 * An execution link is of the form:
 *
 *     lynxexec:<COMMAND>
 * or:
 *     lynxexec://<COMMAND>
 * or:
 *     lynxprog:<COMMAND>
 * or:
 *     lynxprog://<COMMAND>
 *
 * where <COMMAND> is a command that Lynx will run when the link is
 * activated.  The double-slash should be included if the command begins
 * with an '@', as for executing VMS command files.  Otherwise, the double-
 * slash can be omitted.
 * Use lynxexec for commands or scripts that generate a screen output which
 * should be held via a prompt to press <return> before returning to Lynx
 * for display of the current document.
 * Use lynxprog for programs such as mail which do require a pause before
 * Lynx restores the display of the current document.
 *
 * Execution scripts take the form of a standard
 * URL.  Extension mapping or MIME typing is used
 * to decide if the file is a script and should be
 * executed.  The current extensions are:
 * .csh, .ksh, and .sh on UNIX systems and .com on
 * VMS systems.  Any time a file of this type is
 * accessed Lynx will look at the user's options
 * settings to decide if the script can be executed.
 * Current options include: Only exec files that
 * reside on the local machine and are referenced
 * with a "file://localhost" URL, All execution
 * off, and all execution on.
 *
 * The following definitions will add execution
 * capabilities to Lynx.  You may define none, one
 * or both.
 *
 * I strongly recommend that you define neither one
 * of these since execution links/scripts can represent
 * very serious security risk to your system and its
 * users.  If you do define these I suggest that
 * you only allow users to execute files/scripts
 * that reside on your local machine. 
 *
 * YOU HAVE BEEN WARNED!
 *
 * Note: if you are enabling execution scripts you should
 * also see src/HTInit.c to verify/change the execution
 * script extensions and/or commands.
 */
/* #define EXEC_LINKS  */ 
/* #define EXEC_SCRIPTS  */ 

/**********
 * UNIX:
 * =====
 * CGI script support. Defining LYNXCGI_LINKS allows you to use the 
 *
 *   lynxcgi:path
 *
 * URL which allows lynx to access a cgi script directly without the need for
 * a http daemon. Redirection or mime support is not supported but just about
 * everything else is. If the path is not an executable file then the URL is
 * rewritten as file://localhost and passed to the file loader. This means that
 * if your http:html files are currently set up to use relative addressing, you
 * should be able to fire up your main page with lynxcgi:path and everything
 * should work as if you were talking to the http daemon.
 *
 * Note that you must use a LYNXCGI_PATH directive in your lynx.cfg file as
 * well in order for this to work.
 *
 * The cgi scripts are called with a fork()/execve() sequence so you don't
 * have to worry about people trying to abuse the code. :-)
 *
 *     George Lindholm (George.Lindholm@ubc.ca)
 *
 * VMS:
 * ====
 * Uncomment the following line to define LYNXCGI_LINK, and when
 * running Lynx, enter  lynxcgi:advice  as a G)oto URL.
 */
/* #define LYNXCGI_LINKS */

#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)

/**********
 * if ALLOW_USERS_TO_CHANGE_EXEC_WITHIN_OPTIONS 
 * is defined then the user will be able to change
 * the execution status within the options screen.
 */
/* #define ALLOW_USERS_TO_CHANGE_EXEC_WITHIN_OPTIONS */

/**********
 * if NEVER_ALLOW_REMOTE_EXEC is defined then local execution of
 * scripts or lynxexec and lynxprog URL's will only be implemented
 * from HTML files that were accessed via a "file://localhost/" URL,
 * and the options menu for "L)ocal executions links" will only
 * allow toggling between "ALWAYS OFF" and "FOR LOCAL FILES ONLY".
 */
/* #define NEVER_ALLOW_REMOTE_EXEC */

/*****************************
 * These are for executable shell scripts and links.
 * Set to FALSE unless you really know what you're
 * doing.
 *
 * This only applies if you are compiling with EXEC_LINKS or
 * EXEC_SCRIPTS defined.
 *
 * The first two settings:
 * LOCAL_EXECUTION_LINKS_ALWAYS_ON 
 * LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE
 * specify the DEFAULT setting of the users execution link
 * options, but the user may still change those options.
 * If you do not wish the user to be able to change the
 * execution link settings you may wish to use the commandline option:
 *    -restrictions=exec_frozen
 *
 * LOCAL_EXECUTION_LINKS_ALWAYS_ON will be FALSE
 * if NEVER_ALLOW_REMOTE_EXEC has been defined.
 *
 * if LOCAL_EXECUTION_LINKS_ALWAYS_OFF_FOR_ANONYMOUS is 
 * true all execution links will be disabled when the
 * -anonymous command line option is used.  Anonymous
 * users are not allowed to change the execution options
 * from within the Lynx options menu so you might be able
 * to use this option to enable execution links and set
 * LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE to TRUE to
 * give anonymous execution link capability without compromising
 * your system (see comments about TRUSTED_EXEC rules in
 * lynx.cfg for more information).
 *
 */
#define LOCAL_EXECUTION_LINKS_ALWAYS_ON          FALSE
#define LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE  FALSE
#define LOCAL_EXECUTION_LINKS_ALWAYS_OFF_FOR_ANONYMOUS FALSE

#endif /*  defined(EXEC_LINKS) || defined(EXEC_SCRIPTS) */

/*********************************
 *  MAIL_SYSTEM_ERROR_LOGGING will send a message to the owner of 
 *  the information if there is one, every time
 *  that a document cannot be accessed!
 *
 *  NOTE: This can generate A LOT of mail, be warned.
 */
#define MAIL_SYSTEM_ERROR_LOGGING   FALSE  /*mail a message for every error?*/

/*********************************
 * If CHECKMAIL is set to TRUE, the user will be informed (via a statusline
 * message) about the existence of any unread mail at startup of Lynx, and
 * will get statusline messages if subsequent new mail arrives.  If a jumps
 * file with a lynxprog URL for invoking mail is available, or your html
 * pages include an mail launch file URL, the user thereby can access mail
 * and read the messages.  The checks and statusline reports will not be
 * performed if Lynx has been invoked with the -restrictions=mail switch.
 *
 *  VMS USERS !!!
 * New mail is normally broadcast as it arrives, via "unsolicitied screen
 * broadcasts", which can be "wiped" from the Lynx display via the Ctrl-W
 * command.  You may prefer to disable the broadcasts and use CHECKMAIL
 * instead (e.g., in a public account which will be used by people who
 * are ignorant about VMS).
 */
#define CHECKMAIL	TRUE	/* report unread and new mail messages */

/*********************************
 * VI_KEYS can be turned on by the user in the options
 * screen or the .lynxrc file.  This is just the default.
 */
#define VI_KEYS_ALWAYS_ON           FALSE /* familiar h,j,k, & l */

/*********************************
 * EMACS_KEYS can be turned on by the user in the options
 * screen or the .lynxrc file.  This is just the default.
 */
#define EMACS_KEYS_ALWAYS_ON           FALSE /* familiar ^N, ^P, ^F, ^B */

/*********************************
 * DEFAULT_KEYPAD_MODE specifies whether by default the user
 * has numbers that work like arrows or else numbered links
 * DEFAULT KEYPAD MODE may be set to 
 *	LINKS_ARE_NUMBERED  or
 *	NUMBERS_AS_ARROWS
 */
#define DEFAULT_KEYPAD_MODE	       NUMBERS_AS_ARROWS

/********************************
 * The default search.
 * This is a default that can be overridden by the user!
 */
#define CASE_SENSITIVE_ALWAYS_ON    FALSE /* case sensitive user search */

/********************************
 * If NO_DOT_FILES is set TRUE here or in lynx.cfg, the user will not be
 * allowed to specify files beginning with a dot in reply to output filename
 * prompts, and files beginning with a dot (e.g., file://localhost/foo/.lynxrc)
 * will not be included in the directory browser's listings.  The setting here
 * will be overridden by the setting in lynx.cfg.  If FALSE, you can force it
 * to be treated as TRUE via -restrictions=dotfiles (or -anonymous, which sets
 * this and most other restrictions).
 *
 * If it's FALSE at startup of Lynx, the user can regulate it via the
 * 'o'ptions menu, and may save the preference in the RC file.
 */
#define NO_DOT_FILES    TRUE  /* disallow access to dot files */

/********************************
 * If MAKE_LINKS_FOR_ALL_IMAGES is TRUE, all images will be given links
 * which can be ACTIVATEd.  For inlines, the ALT or pseudo-ALT ("[INLINE]")
 * strings will be links for the resolved SRC rather than just text.  For
 * ISMAP or other graphic links, the ALT or pseudo-ALT ("[ISMAP]" or "[LINK]")
 * strings will have '-' and a link labeled "[IMAGE]" for the resolved SRC
 * appended.
 *
 * The default defined here can be changed in lynx.cfg, and the user can
 * use LYK_IMAGE_TOGGLE to toggle the feature on or off at run time.
 *
 * The default also can be toggled via an "-image_links" command line switch.
 */
#define MAKE_LINKS_FOR_ALL_IMAGES	FALSE /* inlines cast to links */

/********************************
 * If MAKE_PSEUDO_ALTS_FOR_INLINES is FALSE, inline images which do not
 * specify an ALT string will not have "[INLINE]" inserted as a pseudo-ALT,
 * i.e., they'll be treated as having ALT="".  If MAKE_LINKS_FOR_ALL_IMAGES
 * is defined or toggled to TRUE, however, the pseudo-ALTs will be created
 * for inlines, so that they can be used as links to the SRCs.
 *
 * The default defined here can be changed in lynx.cfg, and the user can
 * use LYK_INLINE_TOGGLE to toggle the feature on or off at run time.
 *
 * The default also can be toggled via a "-pseudo_inlines" command line
 * switch.
 */
#define MAKE_PSEUDO_ALTS_FOR_INLINES	TRUE /* Use "[INLINE]" pseudo-ALTs */

/********************************
 * If SUBSTITUTE_UNDERSCORES is FALSE, the _underline_ format will not be
 * used in dumps.
 *
 * The default defined here can be changed in lynx.cfg, and the user can
 * toggle the default via a "-underscore" command line switch.
 */
#define SUBSTITUTE_UNDERSCORES	TRUE /* Use _underline_ format in dumps */

/********************************
 * If QUIT_DEFAULT_YES is defined then when the QUIT command is entered,
 * any response other than n or N will confirm.  Comment this out if
 * you prefer the more conservative action of requiring an explicit
 * Y or y to confirm.
 */
#define QUIT_DEFAULT_YES

/********************************
 * These definitions specify files created or used in conjunction
 * with traversals.  See CRAWL.ANNOUNCE for more infomation.
 */
#define TRAVERSE_FILE "traverse.dat"
#define TRAVERSE_FOUND_FILE "traverse2.dat"
#define TRAVERSE_REJECT_FILE "reject.dat"
#define TRAVERSE_ERRORS "traverse.errors"


/****************************************************************
 *   Section 3.   Things that you should not change until you
 *  		  have a good knowledge of the program
 */

#define LYNX_NAME "Lynx"
#define LYNX_VERSION "2.4-FM"
#ifndef MAXINT
#define MAXINT 2147483647
#endif /* !MAXINT */

/* text strings for certain actions */
/* changing these text strings is a way to customize 
 * your environment to better suit your tastes
 */
#ifdef QUIT_DEFAULT_YES
#define QUIT "Are you sure you want to quit? [Y] "
#else
#define QUIT "Are you sure you want to quit? [N] "
#endif /* QUIT_DEFAULT_YES */
#define HELP \
 "Commands: Use arrow keys to move, '?' for help, 'q' to quit, '<-' to go back."
#define MOREHELP \
 "-- press space for more, use arrow keys to move, '?' for help, 'q' to quit."
#define MORE "-- press space for next page --"
#define FORM_LINK_TEXT_MESSAGE \
 "(Text entry field) Enter text.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_TEXT_UNM_MSG \
 "UNMODIFIABLE form text field.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_TEXT_SUBMIT_MESSAGE \
 "(Form field) Enter text.  Use <return> to submit, arrows or tab to move off."
#define FORM_LINK_TEXT_SUBMIT_UNM_MSG \
 "UNMODIFIABLE form field.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_TEXT_SUBMIT_MAILTO_MSG \
 "(mailto form field) Enter text.  Use <return> to submit, arrows to move off."
#define FORM_LINK_TEXT_SUBMIT_MAILTO_DIS_MSG \
 "(mailto form field) Mail is disallowed so you cannot submit."
#define FORM_LINK_PASSWORD_MESSAGE \
 "(Password entry field) Enter text.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_PASSWORD_UNM_MSG \
 "UNMODIFIABLE form password.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_CHECKBOX_MESSAGE \
 "(Checkbox Field)   Use right-arrow or <return> to toggle."
#define FORM_LINK_CHECKBOX_UNM_MSG \
 "UNMODIFIABLE form checkbox.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_SUBMIT_MESSAGE \
 "(Form submit button) Use right-arrow or <return> to submit ('x' for no cache)."
#define FORM_LINK_RESUBMIT_MESSAGE \
 "(Form submit button) Use right-arrow or <return> to submit."
#define FORM_LINK_SUBMIT_DIS_MSG \
 "DISABLED form submit button.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_SUBMIT_MAILTO_MSG \
 "(mailto form submit button) Use right-arrow or <return> to submit."
#define FORM_LINK_SUBMIT_MAILTO_DIS_MSG \
 "(mailto form submit button) Mail is disallowed so you cannot submit."
#define FORM_LINK_RESET_MESSAGE \
 "(Form reset button)   Use right-arrow or <return> to reset form to defaults."
#define FORM_LINK_RESET_DIS_MSG \
 "DISABLED form reset button.  Use UP or DOWN arrows or tab to move off."
#define FORM_LINK_OPTION_LIST_MESSAGE \
 "(Option list) Hit return and use arrow keys and return to select option."
#define FORM_LINK_OPTION_LIST_UNM_MSG \
 "UNMODIFIABLE option list.  Use return or arrow keys to review or leave."
#define NORMAL_LINK_MESSAGE \
 "(NORMAL LINK)   Use right-arrow or <return> to activate."
#define LINK_NOT_FOUND "The resource requested is not available at this time."
#define WWW_WAIT_MESSAGE "Getting %s"
#define ADVANCED_URL_MESSAGE "URL: %s"
#define WWW_FAIL_MESSAGE "Unable to access WWW file!!!"
#define WWW_INDEX_MESSAGE "This is a searchable index.  Use %s to search."
#define WWW_INDEX_MORE_MESSAGE \
 "--More--  This is a searchable index.  Use %s to search."
#define BAD_LINK_NUM_ENTERED "You have entered an invalid link number."
#define SOURCE_HELP \
 "Currently viewing document source.  Press '\\' to return to rendered version."
#define NOVICE_LINE_ONE \
 "  Arrow keys: Up and Down to move. Right to follow a link; Left to go back.  \n"
#define NOVICE_LINE_TWO \
 " H)elp O)ptions P)rint G)o M)ain screen Q)uit /=search [delete]=history list \n"
#define NOVICE_LINE_TWO_A \
 "  O)ther cmds  H)elp  K)eymap  G)oto  P)rint  M)ain screen  o)ptions  Q)uit  \n"
#define NOVICE_LINE_TWO_B \
 "  O)ther cmds  B)ack  E)dit  D)ownload ^R)eload ^W)ipe screen  search doc: / \n"
#define NOVICE_LINE_TWO_C \
 "  O)ther cmds  C)omment  History: <delete>  Bookmarks: V)iew, A)dd, R)emove  \n"
#define FORM_NOVICELINE_ONE \
 "            Enter text into the field by typing on the keyboard              "
#define FORM_NOVICELINE_TWO \
"    Ctrl-U to delete all text in field, [Backspace] to delete a character    "
#define RETURN_TO_LYNX "Press <return> to return to Lynx."

#ifdef DIRED_SUPPORT
#define DIRED_NOVICELINE \
 "  C)reate  D)ownload  E)dit  F)ull menu  M)odify  R)emove  T)ag  U)pload     \n"
#endif /* DIRED_SUPPORT */

#define MAXBASE 100       /* max length of base directory */
#define MAXHIGHLIGHT 160 /* max length of highlighted text */
#define MAXTARGET 130    /* max length of target string */
#define LINESIZE 1024    /* max length of line to read from file*/
#define MAXFNAME 1280	/* max filename length DDD/FILENAME.EXT */
#define MAXCOMMAND MAXFNAME /* max length of command should be the same */
#define MAXHIST  512	/* number of links we remember in history */
#define MAXLINKS 256	/* max links on one screen */

#ifndef VMS
/* Check these paths on Unix. */
#define	COMPRESS_PATH	"/bin/compress"
#define	UNCOMPRESS_PATH	"/bin/uncompress"
#define UUDECODE_PATH   "/usr/bin/uudecode"
#define	ZCAT_PATH	"/bin/zcat"
#define	GZIP_PATH	"/bin/gzip"
#define	ZIP_PATH	"/usr/bin/zip"
#define	UNZIP_PATH	"/usr/bin/unzip"
#define	INSTALL_PATH	"/usr/bin/install"
#define	MKDIR_PATH	"/bin/mkdir"
#define	MV_PATH		"/bin/mv"
#define	RM_PATH		"/bin/rm"
#define	TAR_PATH	"/bin/tar"
#define	TOUCH_PATH	"/usr/bin/touch"
#define COPY_PATH	"/bin/cp"
#define CHMOD_PATH	"/bin/chmod"
#endif /* !VMS */

#endif /* USERDEFS_H */
