# include <stdio.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hmkdir.h"

/*
 * NAME:	hmkdir->main()
 * DESCRIPTION:	implement hmkdir command
 */
int hmkdir_main(int argc, char *argv[])
{
  mountent *ent;
  hfsvol *vol;
  int i, result = 0;

  if (argc < 2)
    {
      fprintf(stderr, "Usage: %s hfs-path [...]\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(argv[0], ent = hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  for (i = 1; i < argc; ++i)
    {
      if (hfs_mkdir(vol, argv[i]) < 0)
	{
	  hfs_perror(argv[i]);
	  result = 1;
	}
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  return result;
}
