
/* Graphics routines for Maelstrom!  (By Sam Lantinga) */

#ifndef _framebuf_h
#define _framebuf_h

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>


#define NUM_COLORS	256	// Pseudo-color display. :)
typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
	} Color;


typedef struct {
	unsigned short width;
	unsigned short height;
	unsigned int   numops;
	unsigned char *ops;
	unsigned int   numpixels;
	unsigned char *pixels;
	} CSprite;

/* This class allocates a 640x480 frame-buffer and provides high-level
   routines to blit images into it.  Well, it also provides access to
   other drawing routines.
*/
class FrameBuf {

public:

	// Not a complete class -- only intended as a base class.
	FrameBuf(unsigned short width, unsigned short height) {
		DoFade = 1;
	}
	virtual ~FrameBuf() { }

	virtual int Alloc_Cmap(int polite, Color Cmap[]) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Alloc_Cmap)\n");
		return(0);
	}
	virtual int Alloc_Private_Cmap(Color Cmap[]) {
		fprintf(stderr, 
		"Unimplemented function (FrameBuf: Alloc_Private_Cmap)\n");
		return(0);
	}
	virtual void ReColor(unsigned char *data, int len);
	virtual unsigned char Map_Color(unsigned short red, 
				unsigned short green, unsigned short blue);
	virtual void Clear(void);
	virtual void DrawBGPoint(unsigned int x, unsigned int y, 
						unsigned char color);
	virtual void DrawPoint(unsigned int x, unsigned int y,
						unsigned char color);
	virtual void DrawLine(unsigned int X1, unsigned int Y1, 
			unsigned int X2, unsigned int Y2, unsigned char color);
	virtual void DrawRectangle(int X, int Y, int width, int height, 
						unsigned char color);
	virtual void FillRectangle(int X, int Y, int width, int height, 
						unsigned char color);
	virtual unsigned char * Grab_Area(int x, int y, int width, int height);
	virtual void Set_Area(int x, int y, int width, int height,
							unsigned char *area);
	virtual  void Set_BlitClip(int left, int top, int right, int bottom);
	virtual void Blit_BitMap(int x, int y, int width, int height,
				unsigned char *bdata, unsigned char color);
	virtual void UnBlit_BitMap(int x, int y, int width, int height,
							unsigned char *bdata);
	virtual void Blit_Title(int x, int y, int width, int height,
							unsigned char *data);
	virtual void Blit_Sprite(int x, int y, int width, int height,
				unsigned char *sdata, unsigned char *mdata);
	virtual void UnBlit_Sprite(int x, int y, int width, int height,
						unsigned char *mdata);
	virtual void ClipBlit_Sprite(int x, int y, int width, int height,
				unsigned char *sdata, unsigned char *mdata);
	virtual void UnClipBlit_Sprite(int x, int y, int width, int height,
							unsigned char *mdata);
	virtual CSprite * Compile_Sprite(int width, int height, 
				unsigned char *sdata, unsigned char *mdata);
	virtual void Blit_CSprite(int x, int y, CSprite *sprite);
	virtual void UnBlit_CSprite(int x, int y, CSprite *sprite);
	virtual void Free_CSprite(CSprite *sprite);
	virtual void Hide_Cursor(void) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Hide_Cursor)\n");
	}
	virtual void Show_Cursor(void) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Show_Cursor)\n");
	}
	virtual void SetFade(int dofade) {
		DoFade = dofade;
	}
	virtual void Fade(int steps) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Fade)\n");
	}
	virtual void RefreshArea(int x0, int y0, int width, int height) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: RefreshArea)\n");
	}
	virtual void Refresh(void) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Refresh)\n");
	}
	virtual void FlushEvents(void) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: FlushEvents)\n");
	}
	virtual int NumEvents(void) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: FlushEvents)\n");
		return(0);
	}
	virtual void GetEvent(XEvent *event) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: GetEvent)\n");
	}
	virtual int KeyToAscii(XEvent *event, char *buf, int buflen,
								KeySym *key) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: KeyToAscii)\n");
		return(0);
	}
	virtual void Flush(int sync) {
		fprintf(stderr, 
			"Unimplemented function (FrameBuf: Flush)\n");
	}

protected:
	/* Recompile a CSprite, taking clipping into account */
	virtual CSprite * ClipSprite(int x, int y, CSprite *sprite);

	unsigned char *shared_mem;	// The shared memory frame buffer
	unsigned char *backbuf;		// The background bits buffer
	unsigned long shared_len;	// The length of the frame buffer
	int WIDTH, HEIGHT;		// The width and height of the window
	int clip_left;			// Left of Blit clipping rectangle
	int clip_top;			// Top of Blit clipping rectangle
	int clip_right;			// Right of Blit clipping rectangle
	int clip_bottom;		// Bottom of Blit clipping rectangle

	unsigned long Black;		// The black pixel color 
	Color         Color_Map[NUM_COLORS];	// The colormap we actually use
	unsigned char Pixel_colors[NUM_COLORS];	// The pixel->color table

	int    hidden_cursor;		// Is the cursor hidden?
	int    DoFade;			// Do we actually perform fades?
};
#endif /* _framebuf_h */
