/* `mfile.h' -- Routines to do i/o via mmap() whenever possible, or use
   read()/write() otherwise.

   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Written by Fung-Chai Lim (fclim@acm.org).
   Most of the codes in here was snarfed from GNU grep-2.0,
   written by Mike Haertel.

   This file is part of GNU ecc.  */

#ifndef _MFILE_H
#define _MFILE_H

/*
#ifdef MAN

"Kludge!  MegaKludge to the Max!"
	-- Sonarman First Class Ronald ``Jonesy'' Jones.

This didn't turned out the way I was hoping for.  I'm not writing any manpages
for no kludge.  I've decided to insert it in the distribution, hoping that
Midas might lay his hand and ...

#endif MAN
*/

#include <sys/types.h>
#include <sys/stat.h>

enum MTYPE
{
  MREAD,
  MWRITE
};

#ifdef _PROTO_
#undef _PROTO_
#endif
#ifdef VOID
#undef VOID
#endif
#if __STDC__
#define _PROTO_(args)	args
#define VOID		void
#else
#define _PROTO_(args)	()
#define VOID		char
#endif

struct mfile
{
  const char *fname;
  VOID *buffer;
  VOID *beg;		/* Current position of data */
  VOID *save;		/* Start of save region */
  VOID *lim;		/* Limit of mmap region */
  int is_mapped;
  int fd;
  int buffer_size;	/* Total buffer size */
  int save_size;	/* Size of save region */
  int wbytes;		/* Total size of file */
  int offset;
  struct stat st;
  int prot;
  int flags;
  enum MTYPE mode;
};

struct mfile *mopen _PROTO_ ((const char *const fname, int fd,
                              enum MTYPE mode));
int mclose _PROTO_ ((struct mfile *file));
int mfill _PROTO_ ((struct mfile *file, int bytes));
int mflush _PROTO_ ((struct mfile *file));

void *mbuf _PROTO_ ((struct mfile *file));
void mread _PROTO_ ((struct mfile *file, int bytes));
void mwrite _PROTO_ ((struct mfile *file, int bytes));

#define mbuf(mfile)		((mfile)->beg)

#define mread(file, bytes) \
  do { \
    (file)->beg += (bytes); \
  } while (0)

#define mwrite(file, bytes) \
  do { \
    (file)->wbytes += bytes; \
    (file)->beg += bytes; \
  } while (0)
  
#endif	/* _MFILE_H */
