write_fstab () {
    cat > /target/etc/fstab <<EOF
# /etc/fstab: static file system information.
#
# <file system>     <mount point>   <type>  <options>   <dump>  <pass>
$Root               /               ext2    defaults    0       1
EOF
    if [ $? -ne 0 ]; then return 1; fi

    if [ ! -z "$Swap" -a "$swap" != "None" ]; then
        echo \
         "$Swap               none            swap    sw          0       0" \
         >> /target/etc/fstab
        if [ $? -ne 0 ]; then return 1; fi
    fi

    echo "proc                /proc           proc    defaults    0       0" \
     >> /target/etc/fstab
    if [ $? -ne 0 ]; then return 1; fi

    < /etc/mtab sed -n '/target\//p' | sed -e 's/target\///' -e 's/ /   /g' \
     -e 's/ 0   0/  0   2/' -e 's/  rw  /   defaults    /' >> /target/etc/fstab
    if [ $? -ne 0 ]; then return 1; fi

    return 0;
}
