/*
 * ps.h		Copyright (c) 1992 Branko Lankester
 * Modified heavily by Michael K. Johnson
 * Modified even more by Charles Blake
 */
#include <stdio.h>
#include <sys/types.h>
#include <linux/sched.h>

#define	MAXCMD	1024	/* max # bytes to write from the command line */

struct ps_statm {
    int size, resident, share, trs, lrs, drs, dt;
};

struct ps_proc {
    char	cmdline[256], user[10], cmd[40], state, ttyc[4];
    int		uid, pid, ppid, pgrp, session, tty, tpgid, utime, stime,
		cutime, cstime, priority, nice, start_time, signal, blocked,
		sigignore, sigcatch;
    unsigned	flags, min_flt, cmin_flt, maj_flt, cmaj_flt, timeout,
		it_real_value, vsize, rss, rss_rlim, start_code, end_code,
		start_stack, kstk_esp, kstk_eip, wchan;
    struct ps_statm statm;
    struct ps_proc *next;
};

struct ps_proc_head {
    struct ps_proc* head;
    int             count;
};

char *   find_func();
       
void     dev_to_tty(char *tty, int dev);
int      tty_to_dev(char *tty);
char *   dev3(char *ttyname);
       
char *   wchan(unsigned int);
char *   status();
       
void *   xcalloc(void *pointer, int size);
       
int      mult_lvl_cmp(void* a, void* b);
int      node_mult_lvl_cmp(void* a, void* b);
void     dump_keys(void);
       
unsigned print_str    (FILE* file, char *s, unsigned max);
unsigned print_strlist(FILE* file, char **strs, char* sep, unsigned max);

/* a, u, x, m, and r correspond to those command line options: if the
 * variable is set, then the corresponding command line option was
 * chosen. */
struct ps_proc_head * take_snapshot(char a, char u, char x, char m, char r,
                                    uid_t uid, int ctty);
struct ps_proc_head * refresh_snapshot(struct ps_proc_head *ph, char a, char u,
                                       char x, char m, char r, uid_t uid, int ctty);
struct ps_proc_head * get_process(pid_t pid, int m);
struct ps_proc_head * get_processes(pid_t *pids, int m);
void                  free_psproc(struct ps_proc *this);

char *                user_from_uid(int uid);
int                   open_psdb(void);
void                  close_psdb(void);
char *                status(struct ps_proc *task);

