dnl### Useful functions.
dnl Usage: LYX_ERROR(file,library)  Displays an error message indication that
dnl  'file' cannot be found because 'lib' may be uncorrectly installed.
AC_DEFUN(LYX_ERROR,[AC_WARN([Can't find $1. Please check that the $2 library
is correctly installed on your system.
(see the section 'Problems' in the INSTALL file)])
lyx_error=yes])
dnl
dnl
dnl Usage: LYX_CHECK_ERRORS  Displays a warning message if a LYX_ERROR
dnl   has occured previously. 
AC_DEFUN(LYX_CHECK_ERRORS,[
test x$lyx_error = xyes && AC_WARN([
*** Some important files or library have been flagged as missing
*** by configure. Please check the warning messages before running 'make'.
*** If you correct your configuration or use new options for configure, 
*** remember to issue a 'make clean' before re-running configure.])])
dnl
dnl
dnl Usage: LYX_WITH_DIR(dir-name,desc,dir-var-name,default-value)  Adds a
dnl  --with-'dir-name' option (described by 'desc') and puts the resulting
dnl  directory name in 'dir-var-name'.
AC_DEFUN(LYX_WITH_DIR,[
  AC_ARG_WITH($1,[  --with-$1        specify $2])
  AC_MSG_CHECKING([for $2])
  if test -z "$with_$3"; then
     AC_CACHE_VAL(lyx_cv_$3, lyx_cv_$3=$4)
  else
    for dir in $with_$3 ; do
      test ! -d "$dir" && AC_ERROR([\`$dir' is not a directory])
    done
    lyx_cv_$3=$with_$3
  fi
  AC_MSG_RESULT($lyx_cv_$3)])
dnl
dnl
dnl
dnl Usage LYX_PATH_TEX  Searches for TeX root and puts the result in variable 
dnl  TEXMF. NOT USED ANYMORE
dnl AC_DEFUN(LYX_PATH_TEX,[
dnl   AC_ARG_WITH(texmf,[  --with-texmf            specify TeX root directory])
dnl   AC_MSG_CHECKING([for TeX])
dnl   if test -z "$with_texmf"; then
dnl      AC_CACHE_VAL(lyx_cv_texmf,[
dnl       for lyx_dir in \
dnl          ${prefix}/lib \
dnl          /usr/lib \
dnl          /usr/local \
dnl          /usr/local/lib \
dnl          /usr/local/share \
dnl          /opt ; do
dnl         test -d $lyx_dir/texmf && lyx_cv_texmf=$lyx_dir/texmf;
dnl       done])
dnl   else
dnl     test ! -d "$with_texmf" && AC_ERROR(proper usage is --with-texmf=DIRECTORY)
dnl     lyx_cv_texmf=$with_texmf
dnl   fi
dnl   TEXMF=$lyx_cv_texmf
dnl   if test "x$TEXMF" = x ; then
dnl     AC_MSG_RESULT(no)
dnl     TEXMF=NONE
dnl     AC_WARN([Unable to find TeX. Please use the --with-texsty-dir flag.])
dnl   else
dnl     AC_MSG_RESULT($TEXMF)
dnl   fi])
dnl
dnl
dnl
AC_DEFUN(LYX_HPUX,
[AC_CACHE_CHECK(for HP-UX,ac_cv_hpux,[
os=`uname -s | tr '[A-Z]' '[a-z]'`
ac_cv_hpux=no
test "$os" = hp-ux && ac_cv_hpux=yes])
if test "$ac_cv_hpux" = yes; then
 test "x$GXX" = xyes && CXXFLAGS="$CXXFLAGS -fpcc-struct-return"
fi])
dnl
dnl
dnl
AC_DEFUN(LYX_SUNOS4,
[AC_CACHE_CHECK(for SunOS 4.x,ac_cv_sunos4,[
changequote(, )
os=`uname -a | tr '[A-Z]' '[a-z]'|sed -e 's/^\([^ ]*\) [^ ]* \([0-9]\)\..*/\1\2/'`
changequote([, ])
ac_cv_sunos4=no
test "$os" = sunos4 && ac_cv_sunos4=yes])
if test "$ac_cv_sunos4" = yes; then
 test "x$GXX" = xyes && lyx_sun_headers=yes
fi])
dnl
dnl
dnl
dnl Usage LYX_VERSION   Sets `lyx_version' to the version of LyX being built,
dnl   displays it and sets variable `lyx_devel' to yes or no depending whether
dnl   the version is a development release or not. 
AC_DEFUN(LYX_VERSION,[
changequote(, )
lyx_version=`grep '#define *VERSION' version.h | 
             sed -e 's/^.*"\([0-9.]*\)[^0-9.].*$/\1/' 2>/dev/null`
echo "Configuring LyX version $lyx_version"
if echo "$lyx_version" | grep '[0-9]*\.[0-9]*[13579]\.[0-9]*' >/dev/null ; then
  lyx_devel_version=yes
  echo "WARNING: This is a development version. Expect bugs."
else
  lyx_devel_version=no
fi
changequote([, ])
test $lyx_devel_version = yes && AC_DEFINE(DEVEL_VERSION)
AC_SUBST(lyx_version)])
dnl Check for signal system type
dnl This is not at all complete check yet, but it have to do for the moment.
dnl There is three systems detected, SYSV, 43BSD and POSIX
dnl There is two name collisions not resolved in terms of side-effect, they are
dnl signal (SYSV and 43BSD) and sigpause (SYSV and 43BSD).

AC_DEFUN(AC_SYS_SIGNAL,
[
   dnl Tell what we are looking for
   AC_MSG_CHECKING(which signal system is being used)

   dnl Make possibly cached check
   AC_CACHE_VAL(ac_cv_sys_signal,
   [
      dnl Default value
      ac_cv_sys_signal=unknown

      dnl Check for SYSV signal (good old unix.... way before things got complex again :)

      dnl Check the SysV signal hook function
      AC_EGREP_HEADER(signal, signal.h, sysv_signal=yes, sysv_signal=no)

      dnl Check the SysV signal hook & mask function
      AC_EGREP_HEADER(sigset, signal.h, sysv_sigset=yes, sysv_sigset=no)

      dnl Check the SysV signal mask helpers
      AC_EGREP_HEADER(sighold, signal.h, sysv_sighold=yes, sysv_sighold=no)
      AC_EGREP_HEADER(sigrelse, signal.h, sysv_sigrelse=yes, sysv_sigrelse=no)
      AC_EGREP_HEADER(sigignore, signal.h, sysv_sigignore=yes, sysv_sigignore=no)
      AC_EGREP_HEADER(sigpause, signal.h, sysv_sigpause=yes, sysv_sigpause=no)

      dnl Summarize Check
      sysv_mask_helpers=no
      if test $sysv_sighold = yes -a $sysv_sigrelse = yes -a $sysv_sigignore = yes -a $sysv_sigpause = yes; then
         sysv_mask_helpers=yes
      fi
      if test $sysv_signal = yes -a $sysv_sigset = yes -a $sysv_mask_helpers = yes; then
         ac_cv_sys_signal=SYSV
      fi

      dnl Check for 4.3BSD signal system

      dnl Check the 4.3BSD signal hook function
      AC_EGREP_HEADER(signal, signal.h, _43bsd_signal=yes, _43bsd_signal=no)

      dnl Check the 4.3BSD signal hook function
      AC_EGREP_HEADER(sigvec, signal.h, _43bsd_sigvec=yes, _43bsd_sigvec=no)

      dnl Check the 4.3BSD signal pause
      AC_EGREP_HEADER(sigpause, signal.h, _43bsd_sigpause=yes, _43bsd_sigpause=no)

      dnl Check the 4.3BSD signal masker
      AC_EGREP_HEADER(sigsetmask, signal.h, _43bsd_sigsetmask=yes, _43bsd_sigsetmask=no)
      AC_EGREP_HEADER(sigblock, signal.h, _43bsd_sigblock=yes, _43bsd_sigblock=no)

      dnl Check the 4.3BSD signal mask helpers
      AC_EGREP_HEADER(sigmask, signal.h, _43bsd_sigmask=yes, _43bsd_sigmask=no)

      dnl Check the 4.3BSD unique features
      AC_EGREP_HEADER(sigstack, signal.h, _43bsd_sigstack=yes, _43bsd_sigstack=no)
      AC_EGREP_HEADER(sigreturn, signal.h, _43bsd_sigreturn=yes, _43bsd_sigreturn=no)

      dnl Summarize Check
      _43bsd_maskers=no
      if test $_43bsd_sigsetmask = yes -a $_43bsd_sigblock = yes -a $_43bsd_sigmask = yes -a $_43bsd_sigstack = yes -a $_43bsd_sigreturn = yes; then
         _43bsd_maskers=yes
      fi
      if test $_43bsd_signal = yes -a $_43bsd_sigvec = yes -a $_43bsd_sigpause = yes -a _43bsd_maskers ; then
         ac_cv_sys_signal=43BSD
      fi

      dnl Check for POSIX signal system

      dnl Check the POSIX signal hook function
      AC_EGREP_HEADER(sigaction, signal.h, posix_sigaction=yes, posix_sigaction=no)

      dnl Check the POSIX signal pause
      AC_EGREP_HEADER(sigsuspend, signal.h, posix_sigsuspend=yes, posix_sigsuspend=no)

      dnl Check the POSIX signal masker
      AC_EGREP_HEADER(sigprocmask, signal.h, posix_sigprocmask=yes, posix_sigprocmask=no)

      dnl Check the POSIX signal mask helpers
      AC_EGREP_HEADER(sigaddset, signal.h, posix_sigaddset=yes, posix_sigaddset=no)
      AC_EGREP_HEADER(sigdelset, signal.h, posix_sigdelset=yes, posix_sigdelset=no)
      AC_EGREP_HEADER(sigemptyset, signal.h, posix_sigemptyset=yes, posix_sigemptyset=no)
      AC_EGREP_HEADER(sigfillset, signal.h, posix_sigfillset=yes, posix_sigfillset=no)
      AC_EGREP_HEADER(sigismember, signal.h, posix_sigismember=yes, posix_sigismember=no)

      dnl Check the POSIX signal unique feature
      AC_EGREP_HEADER(sigpending, signal.h, posix_sigpending=yes, posix_sigpending=no)

      dnl Summarize check
      if test $posix_sigaction = yes -a $posix_sigpending = yes -a $posix_sigprocmask = yes -a $posix_sigsuspend = yes -a $posix_sigaddset = yes -a $posix_sigdelset = yes -a $posix_sigemptyset = yes -a $posix_sigismember = yes; then
         ac_cv_sys_signal=POSIX
      fi
   ])

   dnl Define separate flags
   if test $ac_cv_sys_signal = "POSIX"; then
      AC_DEFINE(HAVE_SIGNAL_POSIX)
   else
      if test $ac_cv_sys_signal = "43BSD"; then
         AC_DEFINE(HAVE_SIGNAL_43BSD)
      else
         if test $ac_cv_sys_signal = "SYSV"; then
            AC_DEFINE(HAVE_SIGNAL_SYSV)
         fi
      fi
   fi

   dnl Define common flag
   AC_DEFINE(HAVE_SIGNAL, $ac_cv_sys_signal)

   dnl Show result
   AC_MSG_RESULT($ac_cv_sys_signal)
])

