/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/* Module de commande du construction d'index */
/* adapte pour interface motif */

/* Module indmenu.c */
#include "thot_gui.h"
#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "appdialogue.h"

#include "indmsg.h"
#include "libmsg.h"
#include "message.h"
#include "dialog.h"
#include "constind.h"
#include "typeind.h"


#define THOT_EXPORT extern

#include "edit_tv.h"
#include "appdialogue_tv.h"
#undef THOT_EXPORT
#define THOT_EXPORT
#include "index_tv.h"

static int          AConstruire;
static boolean      Repagination;
static boolean      Fusion;
static boolean      DelDesc;
static boolean      DelMarque;
static int          BaseIndDlg;

/* procedures importees de l'editeur */
#include "appli_f.h"
#include "tree_f.h"
#include "config_f.h"
#include "structcreation_f.h"
#include "views_f.h"
#include "viewapi_f.h"
#include "appdialogue_f.h"
#include "exceptions_f.h"
#include "indcree_f.h"
#include "indcharge_f.h"
#include "indmenu_f.h"
#include "indpres_f.h"
#include "indtable_f.h"
#include "indtri_f.h"
#include "changeabsbox_f.h"
#include "structselect_f.h"
#include "content_f.h"
#include "memory_f.h"
#include "applicationapi_f.h"
#include "docs_f.h"
#include "paginate_f.h"

/*----------------------------------------------------------------------
   IndexLoadResources : connecte les ressources de l'index et initialise     
  ----------------------------------------------------------------------*/
void                IndexLoadResources ()
{
   if (ThotLocalActions[T_indexcopy] == NULL)
     {
	Ind_indpar ();		/* initialise le repertoire a la valeur de INDEXPAR */
	INDEX = TtaGetMessageTable ("inddialogue", INDEX_MSG_MAX);
	BaseIndDlg = TtaSetCallback (CallbackIndex, MAX_MENU_INDEX);
	/* initialisations */
	Fusion = FALSE;
	Repagination = FALSE;
	DelDesc = FALSE;
	DelMarque = FALSE;
	/* connection des ressources */
	TteConnectAction (T_indexcopy, (Proc) Ind_CopyRefCR);
	TteConnectAction (T_indexnew, (Proc) Ind_Creation);
	TteConnectAction (T_indexverif, (Proc) Ind_VerifMarque);
	TteConnectAction (T_indexschema, (Proc) ChargerIndexExt);
     }
}


/*----------------------------------------------------------------------
   TtcIndex : Commande standard de construction des index           
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcIndex (Document doc, View view)
#else  /* __STDC__ */
void                TtcIndex (doc, view)
Document            doc;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   Name                extension;

   pDoc = LoadedDocument[doc - 1];
   IndexLoadResources ();
   if (pDoc != NULL)
     {
	/* verifier si ce document possede les extensions Index */
	/* s'il ne la possede pas, alors on essaye de la charger */
	pDocu = pDoc;
	extension[0] = '\0';
	if (Act_TestLoadExtension (pDoc, "ExtIndex", extension) >= 0)
	   Indexer (pDoc);
     }
}

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Indexer (PtrDocument pDoc)
#else  /* __STDC__ */
void                Indexer (pDoc)
PtrDocument         pDoc;

#endif /* __STDC__ */
{
   PtrTextBuffer       pBu1;
   PtrSSchema          pSS;
   int                 TypeCherche;
   int                 lgmot;
   char                buffTitre[200];

   int                 nbtable, nbchoix, Indx;
   PtrElement          pEl, pC, pFeuille;
   char               *buftitre;
   char                BufMenu[MAX_TXT_LEN];
   int                 X, Y, W, H;
   int                 vue;

   /* creer le menu des tables a construire */
   pFirstTable = NULL;
   Indx = 0;
   /* compter les tables demandees dans options */
   pEl = Ind_table (1);
   nbtable = 0;

   if (pEl == NULL)
      /* demander - par defaut - une table d'index de titre INDEX */
     {
	pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc),
						  "ExtIndex");
	TypeCherche = GetElemWithException (1216, pSS);
	/* creer le premier element associe Option */
	pEl = CreateFirstAssocElement (pDoc, TypeCherche, pSS);
	/* initialiser le titre de cet index (Titre_Index = 1275) */
	TypeCherche = GetElemWithException (1275, pSS);
	/* pointeur sur un FillContent a initialiser avec un elt texte */
	pC = pEl->ElFirstChild->ElFirstChild;
	pFeuille = NewSubtree (CharString + 1, pSS, pDoc, pEl->ElAssocNum,
			       TRUE, TRUE, TRUE, TRUE);
	/* inserer la feuille de texte */
	InsertOption (pC, &pFeuille, pDoc);
	pFeuille->ElTerminal = TRUE;
	pFeuille->ElVolume = 0;
	pFeuille->ElLanguage = pEl->ElLanguage;
	/* creation d'un buffer pour element texte */
	CreateTextBuffer (pFeuille);
	/* copie INDEX dans cettefeuille */
	pBu1 = pFeuille->ElText;
	lgmot = strlen (TtaGetMessage (INDEX, ID_Titre));
	strcpy (pBu1->BuContent, TtaGetMessage (INDEX, ID_Titre));
	pBu1->BuContent[lgmot] = '\0';
	pFeuille->ElTextLength = lgmot;
	pFeuille->ElVolume = pFeuille->ElTextLength;
	pFeuille->ElText->BuLength = lgmot;
	/* ajoute le volume de l'element a celui de ses ascendants */
	if (pFeuille->ElVolume != 0)
	  {
	     pC = pFeuille->ElParent;
	     while (pC != NULL)
	       {
		  pC->ElVolume = pC->ElVolume + pFeuille->ElVolume;
		  pC = pC->ElParent;
	       }
	  }
	/* modifier le document */
	CreateAllAbsBoxesOfEl (pEl->ElParent, pDoc);
	AbstractImageUpdated (pDoc);
	RedisplayDocViews (pDoc);
	DocumentModified (pDoc, pEl);
	/* chargement d'extension */
	/* => pas encore de marque => pas de construction de table */
     }
   else
     {
	while (pEl != NULL)
	  {
	     nbtable++;
	     buftitre = Ind_TitreDansMenu (pEl->ElFirstChild);
	     sprintf (&BufMenu[Indx], "%s%s", "B", buftitre);
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     pEl = Ind_table (nbtable + 1);
	  }			/* end of while */
	if (nbtable > 1)	/* plusieurs tables a construire */
	  {			/* ajouter au menu le choix : construire TOUTES les tables */
	     sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (INDEX, ID_Tout));
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     nbchoix = nbtable + 1;
	  }
	else
	   nbchoix = nbtable;
	if (nbchoix > 0)
	  {
	     /* creer le formulaire CONSTRUIRE LES TABLES */
	     TtaNewForm (BaseIndDlg + IndexFormConstruire,  0,
		   TtaGetMessage (INDEX, ID_Construire), 1, 4, 'L', D_DONE);
	     /* creer le menu : liste des tables a construire */
	     TtaNewSubmenu (BaseIndDlg + IndexMenuQuoi, BaseIndDlg + IndexFormConstruire, 0,
			    NULL, nbchoix, BufMenu, NULL, FALSE);
	     /* par defaut : la table 1 */
	     AConstruire = 0;
	     TtaSetMenuForm (BaseIndDlg + IndexMenuQuoi, AConstruire);
	     /* creer le sous-menu des Options dans le formulaire CONSTRUIRE */
	     Indx = 0;
	     sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (INDEX, ID_Repaginate));
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (INDEX, ID_Fusion));
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (INDEX, ID_Descripteur));
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (INDEX, ID_Marque));
	     Indx += strlen (&BufMenu[Indx]) + 1;
	     TtaNewToggleMenu (BaseIndDlg + IndexMenuOptions, BaseIndDlg + IndexFormConstruire,
			       TtaGetMessage (LIB, TMSG_OPTIONS), 4,
			       BufMenu, NULL, FALSE);
	     /* selectionner la 1e option : Repagination */
	     TtaSetToggleMenu (BaseIndDlg + IndexMenuOptions, -1, FALSE);
	     /* compose le titre "Construction des index de ..." */
	     strcpy (buffTitre, TtaGetMessage (INDEX, ID_Indexer));
	     strcat (buffTitre, pDoc->DocDName);
	     TtaChangeFormTitle (BaseIndDlg + IndexFormConstruire, buffTitre);
	     /* afficher le formulaire de CONSTRUCTION */
	     TtaShowDialogue (BaseIndDlg + IndexFormConstruire, FALSE);
	     /* attendre le retour de ce formulaire */
	     TtaWaitShowDialogue ();

	     /* des tables d'index ont ete crees : il faut les afficher */
	     if (pFirstTable != NULL)
	       {		/* afficher toutes les tables */
		  if (pDoc->DocAssocFrame[pFirstTable->ElAssocNum - 1] != 0)
		     /* la vue Indexs est ouverte, on la reconstruit */
		    {
		       pEl = pFirstTable;
		       while (pEl != NULL && pEl->ElTypeNumber == pFirstTable->ElTypeNumber)
			 {
			    CreateAllAbsBoxesOfEl (pEl, pDoc);	/* table par table */
			    AbstractImageUpdated (pDoc);
			    RedisplayDocViews (pDoc);
			    pEl = NextElement (pEl);
			 }	/* end of while */
		    }
		  else
		     /* on ouvre la vue Index */
		    {
		       ConfigGetViewGeometry (pDoc, "Index_tables", &X, &Y, &W, &H);
		       vue = CreateAbstractImage (pDoc, 0,
					pFirstTable->ElParent->ElTypeNumber,
						pFirstTable->ElStructSchema,
						  1, TRUE, NULL);
		       OpenCreatedView (pDoc, vue, TRUE, X, Y, W, H);
		    }		/* end of else */

		  if (Repagination)
		     PaginateView (pDoc, pFirstTable->ElAssocNum - 1, TRUE);
		  if (indexisok != -1)	/* ne pas FAC le message d'erreur eventuel */
		     TtaDisplaySimpleMessage (INFO, INDEX, INDEX_FIN_OK);	/* termine' */
	       }
	  }
     }				/* end of else */
}				/* end proc Indexer */



/*----------------------------------------------------------------------
   CallbackIndex                                                     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                CallbackIndex (int Ref, int TypeData, char *Data)
#else  /* __STDC__ */
void                CallbackIndex (Ref, TypeData, Data)
int                 Ref;
int                 TypeData;
char               *Data;

#endif /* __STDC__ */
{

   int                 nbtable, i, maxcle;
   int                 TypeRenvoi;
   PtrSSchema          pSS;
   PtrElement          pEl;

   switch (Ref - BaseIndDlg)
	 {
	    case IndexMenuOptions:
	       switch ((int) Data)
		     {
			case 0:
			   Repagination = !Repagination;
			   break;
			case 1:
			   Fusion = !Fusion;
			   break;
			case 2:
			   DelDesc = !DelDesc;
			   break;
			case 3:
			   DelMarque = !DelMarque;
			   break;
		     }
	       break;
	    case IndexMenuQuoi:
	       AConstruire = (int) Data;
	       break;
	    case IndexFormConstruire:
	       if ((int) Data == 1)
		 {
		    nbtable = Ind_NbTable ();
		    if (DelDesc)
		      {
			 i = Ind_SupDesc (pDocu);
			 TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_SUP_DESC), i);
		      }
		    if (DelMarque)
		      {
			 i = Ind_SupMarque (pDocu);
			 TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_SUP_MARQUE), i);
		      }
		    if (Repagination)
		       PaginateDocument (pDocu);
		    /* calculer le nb max entrees = nb Marques + nb Renvois */
		    pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDocu),
							      "ExtIndex");
		    TypeRenvoi = (int) GetElemWithException (1215, pSS);
		    pEl = FirstAssociatedElement (pDocu, TypeRenvoi, pSS);
		    i = 0;
		    while (pEl != NULL)
		      {
			 pEl = pEl->ElNext;
			 i++;
		      }
		    maxcle = pDocu->DocMaxPairIdent + i;
		    /* allouer une table pTri */
		    pTri = (PtrTabTri *) TtaGetMemory (maxcle * sizeof (int));

		    if (pTri == NULL)
		       TtaDisplaySimpleMessage (INFO, INDEX, INDEX_DEBORDEMENT);
		    else
		       indexisok = (AConstruire == nbtable)
			  ? Ind_creertoutindex (Fusion)
			  : Ind_creerindex (AConstruire + 1, TRUE, Fusion);
		    /* liberer la table pTri */
		    TtaFreeMemory ((char *) pTri);
		 }
	       TtaDestroyDialogue (BaseIndDlg + IndexFormConstruire);
	       break;

	 }			/* end of switch (Ref) */
}				/* end of CallbackIndex */
