/*
    CTHUGHA-L							translate.h
	
*/

#ifndef __TRANSLATE_H__
#define __TRANSLATE_H__

#include "cth_buffer.h"
#include "options.h"

int init_translate();
void translate();
int change_translate(int to);		/* select a new translate-function */
int select_translate();
int exit_translate();

extern int use_translations;		/* allow translations */
typedef int * trans_map;
#define MAX_TRANS	256
extern opt_data translations[MAX_TRANS];
extern int nr_translations;
extern trans_map * active_translation;		/* translation used */
extern char translate_first[256];		/* first translation */
extern int done_translation;			/* trans. already done for
						   this iteration */

typedef struct {				/* header for tab-files */
    long id;					/* "HDKB" to identify file */
    char description[40];			/* asciiz */
    short size_x;			
    short size_y;
} tab_header;

extern int trans_stretch;			/* allow stretching */

#endif
