#include "cthugha.h"
#include "options.h"
#include "sound.h"
#include "display.h"
#include "keys.h"
#include "action.h"

void options_dialog() {
    char str[2000];
    static int sel = 0;
    int key;
    int value = 0;
    const int options = 7;

    do {
	sprintf(str,
		"Cthugha Options\n"
		"---------------\n"
		"%cMinimal Time btw. Change: %7d msec%c\n"
		"%c+ Random Time btw. Change:%7d msec%c\n"
		"%cQuiet Time:               %7d msec%c\n"
		"%cSilence Time:             %7d msec%c\n"
		"%cSilence Level:            %7d     %c\n"
		"%cBeat Level:               %7d     %c\n"
		"%cChange after number Beats:%7d     %c\n"
		"%cLittle Changes:           %7s     %c\n",
		(sel == 0)?'>':' ', sound_wait_min,	(sel == 0)?'<':' ',
		(sel == 1)?'>':' ', sound_wait_random,	(sel == 1)?'<':' ',
		(sel == 2)?'>':' ', sound_wait_quiet,	(sel == 2)?'<':' ',
		(sel == 3)?'>':' ', sound_quiet_change, (sel == 3)?'<':' ',
		(sel == 4)?'>':' ', sound_minnoise,	(sel == 4)?'<':' ',
		(sel == 5)?'>':' ', sound_peaklevel,	(sel == 5)?'<':' ',
		(sel == 6)?'>':' ', sound_wait_beat,	(sel == 6)?'<':' ',
		(sel == 7)?'>':' ', change_little?"yes":" no", (sel==7)?'<':' '
		);
	
	
	display_print(str, 0,1);

	display_sound();
	smooth_setpalette();

	while( (key = getkey()) != Z_NOKEY) {
	    value = 0;
	    switch( key ) {
	    case Z_UP:			/* move cursor up */
		if( -- sel < 0)
		    sel = options;
		break;
	    case Z_DOWN:		/* move curse down */
		if ( ++ sel > options)
		    sel = 0;
		break;
	    case Z_RIGHT:		/* increase value */
		value = (sel < 4) ? 49 : 9;
	    case Z_PLUS: 
		value += 1;
		switch( sel) {
		case 0:
		    sound_wait_min += value;
		    break;
		case 1:
		    sound_wait_random += value;
		    break;
		case 2:
		    sound_wait_quiet += value;
		    break;
		case 3:
		    sound_quiet_change += value;
		    break;
		case 4:
		    sound_minnoise += value;
		    if( sound_minnoise > 255) 
			sound_minnoise = 255;
		    break;
		case 5:
		    sound_peaklevel += value;
		    if( sound_peaklevel > 255)
			sound_peaklevel = 255;
		    break;
		case 6:
		    sound_wait_beat += value;
		    break;
		case 7:
		    change_little = 1 - change_little;
		    break;
		}
		break;
	    case Z_LEFT:		/* decrease value */
		value = (sel < 4) ? 49 : 9;
	    case Z_MINUS: 
		value += 1;
		switch( sel) {
		case 0:
		    sound_wait_min -= value;
		    if ( sound_wait_min < 0)
			sound_wait_min = 0;
		    break;
		case 1:
		    sound_wait_random -= value;
		    if ( sound_wait_random < 0)
			sound_wait_random = 0;
		    break;
		case 2:
		    sound_wait_quiet -= value;
		    if ( sound_wait_quiet < 0)
			sound_wait_quiet = 0;
		    break;
		case 3:
		    sound_quiet_change -= value;
		    if ( sound_quiet_change < 0)
			sound_quiet_change = 0;
		    break;
		case 4:
		    sound_minnoise -= value;
		    if ( sound_minnoise < 0)
			sound_minnoise = 0;
		    break;
		case 5:
		    sound_peaklevel -= value;
		    if ( sound_peaklevel < 0)
			sound_peaklevel = 0;
		    break;
		case 6:
		    sound_wait_beat -= value;
		    if ( sound_wait_beat < 0)
			sound_wait_beat = 0;
		    break;
		case 7:
		    change_little = 1 - change_little;
		    break;
		}
		break;
	    case Z_ESC:				/* Exit on 'q' and ESC */
		display_print(NULL, 0,1);
		return;
	    }
	}
    } while(1);
    return;
}

