/*
    CTHUGHA-L							display.h
	
    Funktions to access the Screen.
	- general stuff
	- screen-functions
	- palette-functions
	- text-functions
*/

#ifndef __DISPLAY_H__
#define __DISPLAY_H__

#ifdef CTH_console
    #include <vga.h>
    #include <vgagl.h>
#endif

#include <time.h>

#include "cth_buffer.h"
#include "options.h"

/* 
 *  General stuff 
 */
int init_ncurses();						
int init_display();				/* initialize VGA */
int alloc_image();				/* alloc X11-image */
int init_graph_mode();				/* activate graphics-mode */
int exit_graph_mode();				/* return to text-mode */
int exit_display();				/* clean-up */
int exit_ncurses();
int free_image();				/* free X11-image */

int resize_display(int new_width, int new_height);

extern int screen_width;			/* size of screen */
extern int screen_height;
extern unsigned char *	active_buffer;		/* buffer next on screen */
extern unsigned char *	passive_buffer;		/* buffer current on screen */
extern int display_tile_x;			/* tile buffers on scrn */
extern int display_tile_y;
extern int display_mode;			/* graphic mode */
extern int display_direct;			/* draw directly to screen */
extern unsigned char * display_mem;
extern int display_frames;			/* counter for speed-tests */
extern time_t display_start;
extern int display_mit_shm;			/* use MIT-SHM if possible */
extern int display_on_root;			/* display on root window */
extern int window_width;
extern int window_height;
extern int bpp;					/* bits per pixel */
extern int bypp;				/* bytes per pixel */
extern unsigned int bitmap_colors[256];		/* "compiled" palette */
extern int rev_byte_order;
extern int draw_mode;				/* how drawing is done */
#define DM_direct	0
#define DM_mapped1	1
#define DM_mapped2	2
#define DM_mapped4	3

/* 
 *  STUFF about screen-functions
 */
int display();					/* bring the changes to scr. */
int change_update_screen(int to);		/* select new screen-fkt */
int select_screen();				/* select what screen-fkts are
						   used */
extern int (*update_screen)(void);		/* pointer to display-fun */
extern opt_data screens[];			/* possible screen-functions */
extern int nr_screens;				/* number of screen-fun */
extern char screen_first[256];			/* Start with this func. */
extern int display_syncwait;			/* Wait for sync on display */

/* 
 *  Stuff about palettes
 */
int load_palettes();				/* initializiation */
int init_palettes();
int exit_palettes();
#define MAX_PALETTES	512			/* max. nr. of palettes */
typedef unsigned char palette[256][3];		/* one Palette: 256 entries, 
						   each 3 bytes */
extern opt_data	palettes[MAX_PALETTES];		/* All palettes */
extern int nr_palettes;				/* number of palettes */
extern palette * active_palette;		/* palette current in use */
extern char palette_first[256];			/* Start with this palette */
int change_palette(int to, int immed);		/* select new palette */
int select_palette();
int update_palette();
extern int display_internal_pal;		/* disable internal pal. */
extern int display_external_pal;		/*  disable external pal. */
void cth_setpalette(palette pal, int immed);
void smooth_setpalette();
extern int display_private_cmap;		/* use a private colormap */

/* 
 *  Stuff about text-display
 */
int display_print(char * text, int line, int reset);	/* display a message */
#define MAX_TEXT_DISPLAY	2000		/* max. nr. of chars to disp */
extern int display_text_line;			/* display at line */
extern char display_text[MAX_TEXT_DISPLAY+1];	/* text to display */
extern int display_font_color;			/* color used to display t. */
extern int display_text_on_screen;		/* text is currently on scrn */

int display_selection(opt_data * what, int nr, void * old, char * title);
int display_do_selection();

/* 
 *  Stuff for PCX
 */
typedef unsigned char * pcx;			/* Memory for loaded picture */
#define MAX_PCX	256
int init_pcx();					/* initalize pcx */
int change_pcx(int to);				/* select new pcx */
int select_pcx();
int show_pcx(int upp_left, int correct_color);
void smooth_setpalette(void);
extern int display_use_pcx;			/* allow pcx-usage */
extern opt_data pcxs[MAX_PCX];			/* pcx-buffers */
extern int nr_pcx;				/* number of pcx loaded */
extern pcx * active_pcx;
extern char pcx_first[256];
extern int pcx_count;				/* counter for pcx-display */
int pcx_palettes[MAX_PCX];			/* index to corresp. palette */

extern char display_prt_file[256];		/* filename used by PrtScrn */
int save_buffer();
int save_display();

#endif


