/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Llib/error.scm                                                    */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t _notify_error___error_188( obj_t, obj_t, obj_t, obj_t );
extern obj_t close_input_port( obj_t );
DEFINE_STRING( string1217___error, aux1718, "", 0 );
DEFINE_STRING( string1223___error, aux1719, "^", 1 );
extern obj_t string_to_bstring( char * );
obj_t __error_notifier____error_43 = BUNSPEC;
extern obj_t the_failure( obj_t, obj_t, obj_t );
extern obj_t warning___error( obj_t );
static obj_t sigill_error_handler___error_101( obj_t );
extern obj_t _type_error_msg___error_185( obj_t, obj_t, obj_t );
DEFINE_STRING( string1225___error, aux1720, "# *** ERROR:bigloo:", 19 );
static obj_t sigsegv_error_handler___error_53( obj_t );
DEFINE_STRING( string1224___error, aux1721, "# *** WARNING:bigloo:", 21 );
DEFINE_STRING( string1243___error, aux1722, "*** WARNING:bigloo:", 19 );
static obj_t *__cnst;
DEFINE_STRING( string1239___error, aux1723, "' provided.", 11 );
static obj_t lambda1148_local1213( obj_t, obj_t, obj_t, obj_t );
extern obj_t current_output_port;
extern bool_t bigloo_strcmp( obj_t, obj_t );
extern obj_t error___error( obj_t, obj_t, obj_t );
DEFINE_STRING( string1226___error, aux1724, "# ", 2 );
DEFINE_STRING( string1221___error, aux1725, ":", 1 );
static obj_t tvectors_declarations____error_145();
DEFINE_STRING( string1218___error, aux1732, "File \"", 6 );
extern obj_t current_error_port;
DEFINE_STRING( string1219___error, aux1733, "\", line ", 8 );
obj_t __trace_stack_depth____error_68 = BUNSPEC;
extern obj_t dump_trace_stack( obj_t, long );
extern obj_t initialization___error();
extern obj_t initialization___r4_input_6_10_2();
extern long get_write_length___r4_output_6_10_3_33();
extern obj_t _remove_error_handler____error_91( obj_t );
extern obj_t fprint___r4_output_6_10_3( obj_t, obj_t );
DEFINE_STRING( string1229___error, aux1734, "[stdin]", 7 );
extern obj_t set_write_length____r4_output_6_10_3_231( long );
DEFINE_STRING( string1220___error, aux1735, ", character ", 12 );
extern obj_t notify_error___error_79( obj_t, obj_t, obj_t );
extern obj_t make_string( long, unsigned char );
extern obj_t error_location___error_27( obj_t, obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1231___error, aux1736, "`segmentation violation' exception", 34 );
static obj_t _sigsegv_error_handler___error_73( obj_t, obj_t );
extern obj_t string_to_symbol( char * );
extern obj_t newline___r4_output_6_10_3( obj_t );
DEFINE_STRING( string1235___error, aux1737, "arithmetic procedure", 20 );
obj_t __warning____error_23 = BUNSPEC;
static obj_t nice_fname___error_199( obj_t );
extern obj_t display___r4_output_6_10_3( obj_t, obj_t );
extern obj_t signal___unix( int, obj_t );
DEFINE_STRING( string1236___error, aux1738, "`floating point' exception", 26 );
DEFINE_STRING( string1241___error, aux1739, "error", 5 );
static obj_t sigfpe_error_handler___error_53( obj_t );
static obj_t _sigbus_error_handler___error_220( obj_t, obj_t );
extern obj_t type_error_msg___error_34( obj_t, obj_t );
static obj_t fix_tabulation____error_157( obj_t, obj_t, obj_t );
extern obj_t _error___error( obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1238___error, aux1740, "' expected, `", 13 );
extern obj_t _warning___error( obj_t, obj_t );
extern obj_t read_line___r4_input_6_10_2_179( obj_t );
extern obj_t open_input_file___r4_ports_6_10_1_217( obj_t, obj_t );
static obj_t _sigfpe_error_handler___error_141( obj_t, obj_t );
DEFINE_STRING( string1230___error, aux1741, "bigloo", 6 );
extern obj_t _error_location_file___error_37( obj_t, obj_t, obj_t );
extern obj_t add_error_handler____error_177( obj_t, obj_t );
DEFINE_STRING( string1237___error, aux1742, "`", 1 );
extern obj_t exit___error( long );
DEFINE_STRING( string1240___error, aux1743, "*** ERROR:bigloo:", 17 );
static obj_t do_warn_location___error_83( obj_t, long, obj_t, obj_t, long, obj_t );
extern obj_t reader_reset____reader_111();
DEFINE_STRING( string1234___error, aux1744, "`illegal instruction' exception", 31 );
extern obj_t remove_error_handler____error_182();
DEFINE_STRING( string1232___error, aux1745, "reached", 7 );
extern obj_t string_append___r4_strings_6_7_48( obj_t );
DEFINE_STRING( string1242___error, aux1746, "Not an error handler", 20 );
extern obj_t _add_error_handler____error_22( obj_t, obj_t, obj_t );
extern obj_t error_location_file___error_127( obj_t, obj_t );
extern obj_t _the_c_failure___error( obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1216___error = BUNSPEC;
static obj_t initialize_constants____error_137();
extern obj_t _warning_location___error_194( obj_t, obj_t, obj_t, obj_t );
extern obj_t _error_location___error_121( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1222___error, aux1747, "#", 1 );
DEFINE_STRING( string1227___error, aux1748, " -- ", 4 );
DEFINE_STRING( string1228___error, aux1749, "[string]", 8 );
extern obj_t warning_location___error_232( obj_t, obj_t, obj_t );
extern obj_t c_substring( obj_t, long, long );
extern obj_t the_c_failure( char *, char *, obj_t );
static obj_t initialize_imported_modules____error_54();
extern obj_t pwd___unix();
static obj_t _sigill_error_handler___error_139( obj_t, obj_t );
extern obj_t _exit___error( obj_t, obj_t );
extern obj_t _the_failure___error( obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1233___error, aux1750, "`bus error' exception", 21 );
static obj_t require_initialization____error_227 = BUNSPEC;
static obj_t __error_handler____error_55 = BUNSPEC;
static obj_t sigbus_error_handler___error_153( obj_t );
obj_t __debug____error_22 = BUNSPEC;

DEFINE_EXPORT_PROCEDURE( remove_error_handler__env___error_114, aux1751, _remove_error_handler____error_91, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( type_error_msg_env___error_70, aux1752, _type_error_msg___error_185, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( notify_error_env___error_195, aux1753, _notify_error___error_188, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( error_env___error_216, aux1754, _error___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( warning_location_env___error_237, aux1755, va_generic_entry, _warning_location___error_194, -3 );
DEFINE_STATIC_PROCEDURE( sigfpe_error_handler_env___error_162, aux1756, _sigfpe_error_handler___error_141, 0L, 1 );
DEFINE_STATIC_PROCEDURE( sigbus_error_handler_env___error_80, aux1758, _sigbus_error_handler___error_220, 0L, 1 );
DEFINE_STATIC_PROCEDURE( sigill_error_handler_env___error_108, aux1759, _sigill_error_handler___error_139, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( error_location_env___error_117, aux1761, _error_location___error_121, 0L, 5 );
DEFINE_STATIC_PROCEDURE( sigsegv_error_handler_env___error_162, aux1762, _sigsegv_error_handler___error_73, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( exit_env___error_233, aux1763, _exit___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( error_location_file_env___error_127, aux1764, _error_location_file___error_37, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( the_c_failure_env___error_41, aux1765, _the_c_failure___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( add_error_handler__env___error_173, aux1766, _add_error_handler____error_22, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( warning_env___error_56, aux1767, va_generic_entry, _warning___error, -1 );
DEFINE_EXPORT_PROCEDURE( the_failure_env___error_115, aux1768, _the_failure___error, 0L, 3 );

obj_t initialization___error()
{if(CBOOL(require_initialization____error_227)){require_initialization____error_227 = BFALSE;
initialize_imported_modules____error_54();
tvectors_declarations____error_145();
initialize_constants____error_137();
require_initialization____error_227 = BFALSE;
__debug____error_22 = BINT(0);
__warning____error_23 = BTRUE;
__trace_stack_depth____error_68 = BINT(10);
__error_handler____error_55 = BNIL;
__error_notifier____error_43 = BUNSPEC;
signal___unix(SIGFPE, sigfpe_error_handler_env___error_162);
signal___unix(SIGILL, sigill_error_handler_env___error_108);
signal___unix(SIGBUS, sigbus_error_handler_env___error_80);
signal___unix(SIGSEGV, sigsegv_error_handler_env___error_162);
return BUNSPEC;
} else {return BUNSPEC;
}}

obj_t initialize_imported_modules____error_54()
{initialization___r4_input_6_10_2();
return BUNSPEC;
}

obj_t initialize_constants____error_137()
{symbol1216___error = string_to_symbol("DONE");
return BUNSPEC;
}

obj_t tvectors_declarations____error_145()
{return BUNSPEC;
}

obj_t exit___error(long n_791)
{exit(n_791);
return BINT(n_791);
}

obj_t _exit___error(obj_t env_1322, obj_t n_1323)
{return exit___error((long)CINT(n_1323));
}

obj_t add_error_handler____error_177(obj_t handler_794, obj_t escape_795)
{{obj_t aux1104_796;
aux1104_796 = MAKE_PAIR(handler_794, escape_795);
{obj_t obj2_1145;
obj2_1145 = __error_handler____error_55;
return (__error_handler____error_55 = MAKE_PAIR(aux1104_796, obj2_1145),
BUNSPEC);
}}}

obj_t _add_error_handler____error_22(obj_t env_1324, obj_t handler_1325, obj_t escape_1326)
{return add_error_handler____error_177(handler_1325, escape_1326);
}

obj_t remove_error_handler____error_182()
{{bool_t test1694_1726;
{obj_t obj_1146;
obj_1146 = __error_handler____error_55;
test1694_1726 = PAIRP(obj_1146);
}if(test1694_1726){obj_t pair_1147;
pair_1147 = __error_handler____error_55;
__error_handler____error_55 = CDR(pair_1147);
} else {BUNSPEC;
}}return __error_handler____error_55;
}

obj_t _remove_error_handler____error_91(obj_t env_1327)
{return remove_error_handler____error_182();
}

obj_t error___error(obj_t proc_797, obj_t message_798, obj_t object_799)
{FAILURE(proc_797,message_798,object_799);}

obj_t _error___error(obj_t env_1328, obj_t proc_1329, obj_t message_1330, obj_t object_1331)
{return error___error(proc_1329, message_1330, object_1331);
}

obj_t warning___error(obj_t args_800)
{if(CBOOL(__warning____error_23)){{obj_t aux1105_801;
aux1105_801 = current_output_port;
FLUSH_OUTPUT_PORT(aux1105_801);
}{obj_t aux1106_802;
aux1106_802 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1106_802, BNIL));
}{obj_t aux1110_803;
aux1110_803 = current_error_port;
display___r4_output_6_10_3(string1243___error, MAKE_PAIR(aux1110_803, BNIL));
}if(NULLP(args_800)){BUNSPEC;
} else {{obj_t aux1111_804;
aux1111_804 = current_error_port;
{obj_t aux1112_805;
aux1112_805 = CAR(args_800);
fprint___r4_output_6_10_3(aux1111_804, MAKE_PAIR(aux1112_805, BNIL));
}}{obj_t l1003_807;
{obj_t aux1116_811;
aux1116_811 = CDR(args_800);
{bool_t aux1681_1712;
l1003_807 = aux1116_811;
lname1004_806:
if(PAIRP(l1003_807)){{obj_t a_808;
a_808 = CAR(l1003_807);
{obj_t aux1113_809;
aux1113_809 = current_error_port;
display___r4_output_6_10_3(a_808, MAKE_PAIR(aux1113_809, BNIL));
}}{obj_t aux1115_810;
aux1115_810 = CDR(l1003_807);
{obj_t l1003_1719;
l1003_1719 = aux1115_810;
l1003_807 = l1003_1719;
goto lname1004_806;
}}} else {aux1681_1712 = ((bool_t)1);
}BBOOL(aux1681_1712);
}}}}{obj_t aux1117_812;
aux1117_812 = current_error_port;
return newline___r4_output_6_10_3(MAKE_PAIR(aux1117_812, BNIL));
}} else {return BUNSPEC;
}}

obj_t _warning___error(obj_t env_1332, obj_t args_1333)
{return warning___error(args_1333);
}

obj_t warning_location___error_232(obj_t fname_813, obj_t location_814, obj_t args_815)
{if(CBOOL(__warning____error_23)){bool_t test1634_1666;
{obj_t string2_1154;
string2_1154 = string1228___error;
test1634_1666 = bigloo_strcmp(fname_813, string2_1154);
}if(test1634_1666){return warning___error(args_815);
} else {bool_t test1637_1669;
{obj_t string2_1156;
string2_1156 = string1229___error;
test1637_1669 = bigloo_strcmp(fname_813, string2_1156);
}if(test1637_1669){return warning___error(args_815);
} else {obj_t port_1157;
port_1157 = open_input_file___r4_ports_6_10_1_217(fname_813, BNIL);
if(INPUT_PORTP(port_1157)){obj_t line_string_1160_32;
long line_num_1161_222;
{obj_t aux1173_1159;
aux1173_1159 = read_line___r4_input_6_10_2_179(port_1157);
line_string_1160_32 = aux1173_1159;
line_num_1161_222 = 1;
loop_1158:
if(EOF_OBJECTP(line_string_1160_32)){close_input_port(port_1157);
return warning___error(args_815);
} else {bool_t test1649_1680;
{long aux1157_1162;
aux1157_1162 = INPUT_PORT_FILEPOS(port_1157);
test1649_1680 = (aux1157_1162>=(long)CINT(location_814));
}if(test1649_1680){close_input_port(port_1157);
{long aux1159_1163;
{long aux1160_1164;
{long aux1162_1165;
aux1162_1165 = STRING_LENGTH(line_string_1160_32);
{long aux1164_1166;
{long aux1166_1167;
aux1166_1167 = INPUT_PORT_FILEPOS(port_1157);
aux1164_1166 = (aux1166_1167-(long)CINT(location_814));
}aux1160_1164 = (aux1162_1165-aux1164_1166);
}}aux1159_1163 = (aux1160_1164+1);
}return do_warn_location___error_83(fname_813, line_num_1161_222, location_814, line_string_1160_32, aux1159_1163, args_815);
}} else {long old_pos_1168_172;
old_pos_1168_172 = INPUT_PORT_FILEPOS(port_1157);
{obj_t aux1168_1169;
aux1168_1169 = read_line___r4_input_6_10_2_179(port_1157);
{long aux1169_1170;
aux1169_1170 = (line_num_1161_222+1);
{long line_num_1696_207;
obj_t line_string_1695_16;
line_string_1695_16 = aux1168_1169;
line_num_1696_207 = aux1169_1170;
line_num_1161_222 = line_num_1696_207;
line_string_1160_32 = line_string_1695_16;
goto loop_1158;
}}}}}}} else {return warning___error(args_815);
}}}} else {return BUNSPEC;
}}

obj_t _warning_location___error_194(obj_t env_1334, obj_t fname_1335, obj_t location_1336, obj_t args_1337)
{return warning_location___error_232(fname_1335, location_1336, args_1337);
}

obj_t the_failure(obj_t proc_816, obj_t message_817, obj_t object_818)
{reader_reset____reader_111();
{bool_t test1604_1641;
{obj_t obj_1184;
obj_1184 = __error_handler____error_55;
test1604_1641 = PAIRP(obj_1184);
}if(test1604_1641){obj_t handler_819;
obj_t escape_820;
{obj_t aux1608_1643;
{obj_t pair_1185;
pair_1185 = __error_handler____error_55;
aux1608_1643 = CAR(pair_1185);
}handler_819 = CAR(aux1608_1643);
}{obj_t aux1612_1646;
{obj_t pair_1187;
pair_1187 = __error_handler____error_55;
aux1612_1646 = CAR(pair_1187);
}escape_820 = CDR(aux1612_1646);
}{bool_t test1615_1649;
{obj_t obj_1189;
obj_1189 = __error_handler____error_55;
test1615_1649 = PAIRP(obj_1189);
}if(test1615_1649){obj_t pair_1190;
pair_1190 = __error_handler____error_55;
__error_handler____error_55 = CDR(pair_1190);
} else {BUNSPEC;
}}__error_handler____error_55;
{bool_t test1619_1652;
if(PROCEDUREP(handler_819)){long aux1119_821;
aux1119_821 = PROCEDURE_ARITY(handler_819);
test1619_1652 = (aux1119_821==4);
} else test1619_1652 = ((bool_t)0);
if(test1619_1652){return PROCEDURE_ENTRY(handler_819)(handler_819, escape_820, proc_816, message_817, object_818, BEOA);
} else {notify_error___error_79(string1241___error, string1242___error, handler_819);
return BINT(-1);
}}} else {notify_error___error_79(proc_816, message_817, object_818);
return BINT(-1);
}}}

obj_t _the_failure___error(obj_t env_1338, obj_t proc_1339, obj_t message_1340, obj_t object_1341)
{return the_failure(proc_1339, message_1340, object_1341);
}

obj_t the_c_failure(char * proc_824, char * message_825, obj_t object_826)
{return the_failure(string_to_bstring(proc_824), string_to_bstring(message_825), object_826);
}

obj_t _the_c_failure___error(obj_t env_1342, obj_t proc_1343, obj_t message_1344, obj_t object_1345)
{return the_c_failure(BSTRING_TO_STRING(proc_1343), BSTRING_TO_STRING(message_1344), object_1345);
}

obj_t notify_error___error_79(obj_t proc_827, obj_t mes_828, obj_t obj_829)
{{bool_t test1564_1603;
{obj_t obj_1193;
obj_1193 = __error_notifier____error_43;
test1564_1603 = PROCEDUREP(obj_1193);
}if(test1564_1603){return PROCEDURE_ENTRY(__error_notifier____error_43)(__error_notifier____error_43, proc_827, mes_828, obj_829, BEOA);
} else {{obj_t aux1124_830;
aux1124_830 = current_output_port;
FLUSH_OUTPUT_PORT(aux1124_830);
}{obj_t aux1125_831;
aux1125_831 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1125_831, BNIL));
}{long old_length_832_124;
old_length_832_124 = get_write_length___r4_output_6_10_3_33();
set_write_length____r4_output_6_10_3_231(80);
{obj_t aux1128_833;
aux1128_833 = current_error_port;
display___r4_output_6_10_3(string1240___error, MAKE_PAIR(aux1128_833, BNIL));
}{obj_t aux1129_834;
aux1129_834 = current_error_port;
fprint___r4_output_6_10_3(aux1129_834, MAKE_PAIR(proc_827, MAKE_PAIR(string1221___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(mes_828, MAKE_PAIR(string1227___error, MAKE_PAIR(obj_829, BNIL)))))));
}{bool_t test1585_1622;
{bool_t test1586_1623;
{obj_t obj_1195;
obj_1195 = __debug____error_22;
test1586_1623 = INTEGERP(obj_1195);
}if(test1586_1623)test1585_1622 = ((long)CINT(__debug____error_22)>0);
 else test1585_1622 = ((bool_t)0);
}if(test1585_1622){obj_t depth_1198;
{bool_t test1590_1627;
{obj_t obj_1199;
obj_1199 = __trace_stack_depth____error_68;
test1590_1627 = INTEGERP(obj_1199);
}if(test1590_1627){depth_1198 = __trace_stack_depth____error_68;
} else {depth_1198 = BINT(10);
}}{obj_t aux1103_1200;
aux1103_1200 = current_error_port;
dump_trace_stack(aux1103_1200, (long)CINT(depth_1198));
}} else {BUNSPEC;
}}return set_write_length____r4_output_6_10_3_231(old_length_832_124);
}}}}

obj_t _notify_error___error_188(obj_t env_1346, obj_t proc_1347, obj_t mes_1348, obj_t obj_1349)
{return notify_error___error_79(proc_1347, mes_1348, obj_1349);
}

obj_t type_error_msg___error_34(obj_t from_835, obj_t to_836)
{{obj_t aux1131_837;
aux1131_837 = SYMBOL_TO_STRING(to_836);
{obj_t aux1132_838;
aux1132_838 = SYMBOL_TO_STRING(from_835);
return string_append___r4_strings_6_7_48(MAKE_PAIR(string1237___error, MAKE_PAIR(aux1131_837, MAKE_PAIR(string1238___error, MAKE_PAIR(aux1132_838, MAKE_PAIR(string1239___error, BNIL))))));
}}}

obj_t _type_error_msg___error_185(obj_t env_1350, obj_t from_1351, obj_t to_1352)
{return type_error_msg___error_34(from_1351, to_1352);
}

obj_t sigfpe_error_handler___error_53(obj_t n_848)
{FAILURE(string1235___error,string1236___error,string1232___error);}

obj_t _sigfpe_error_handler___error_141(obj_t env_1314, obj_t n_1315)
{return sigfpe_error_handler___error_53(n_1315);
}

obj_t sigill_error_handler___error_101(obj_t n_850)
{FAILURE(string1230___error,string1234___error,string1232___error);}

obj_t _sigill_error_handler___error_139(obj_t env_1316, obj_t n_1317)
{return sigill_error_handler___error_101(n_1317);
}

obj_t sigbus_error_handler___error_153(obj_t n_852)
{FAILURE(string1230___error,string1233___error,string1232___error);}

obj_t _sigbus_error_handler___error_220(obj_t env_1318, obj_t n_1319)
{return sigbus_error_handler___error_153(n_1319);
}

obj_t sigsegv_error_handler___error_53(obj_t n_854)
{FAILURE(string1230___error,string1231___error,string1232___error);}

obj_t _sigsegv_error_handler___error_73(obj_t env_1320, obj_t n_1321)
{return sigsegv_error_handler___error_53(n_1321);
}

obj_t error_location___error_27(obj_t proc_855, obj_t message_856, obj_t object_857, obj_t fname_858, obj_t location_859)
{if(STRINGP(fname_858)){if(INTEGERP(location_859)){bool_t test1523_1575;
{obj_t string2_1204;
string2_1204 = string1228___error;
test1523_1575 = bigloo_strcmp(fname_858, string2_1204);
}if(test1523_1575){FAILURE(proc_855,message_856,object_857);} else {bool_t test1528_1578;
{obj_t string2_1206;
string2_1206 = string1229___error;
test1528_1578 = bigloo_strcmp(fname_858, string2_1206);
}if(test1528_1578){FAILURE(proc_855,message_856,object_857);} else {__error_notifier____error_43 = error_location_file___error_127(fname_858, location_859);
FAILURE(proc_855,message_856,object_857);}}} else {FAILURE(proc_855,message_856,object_857);}} else {FAILURE(proc_855,message_856,object_857);}}

obj_t _error_location___error_121(obj_t env_1353, obj_t proc_1354, obj_t message_1355, obj_t object_1356, obj_t fname_1357, obj_t location_1358)
{return error_location___error_27(proc_1354, message_1355, object_1356, fname_1357, location_1358);
}

obj_t error_location_file___error_127(obj_t file_name_860_238, obj_t location_861)
{{obj_t port_862;
port_862 = open_input_file___r4_ports_6_10_1_217(file_name_860_238, BNIL);
if(INPUT_PORTP(port_862)){obj_t line_string_864_56;
obj_t line_num_865_236;
{obj_t aux1147_875;
aux1147_875 = read_line___r4_input_6_10_2_179(port_862);
line_string_864_56 = aux1147_875;
line_num_865_236 = BINT(1);
loop_863:
if(EOF_OBJECTP(line_string_864_56)){close_input_port(port_862);
return BFALSE;
} else {bool_t test1483_1544;
{long aux1133_866;
aux1133_866 = INPUT_PORT_FILEPOS(port_862);
test1483_1544 = (aux1133_866>=(long)CINT(location_861));
}if(test1483_1544){close_input_port(port_862);
{obj_t aux1134_867;
{long aux1137_868;
{long aux1138_869;
aux1138_869 = STRING_LENGTH(line_string_864_56);
{long aux1142_870;
{long aux1143_871;
aux1143_871 = INPUT_PORT_FILEPOS(port_862);
aux1142_870 = (aux1143_871-(long)CINT(location_861));
}aux1137_868 = (aux1138_869-aux1142_870);
}}aux1134_867 = BINT((aux1137_868+1));
}{obj_t lambda1148_1371;
lambda1148_1371 = make_fx_procedure(lambda1148_local1213, 3, 5);
PROCEDURE_SET(lambda1148_1371, 0, aux1134_867);
PROCEDURE_SET(lambda1148_1371, 1, line_string_864_56);
PROCEDURE_SET(lambda1148_1371, 2, file_name_860_238);
PROCEDURE_SET(lambda1148_1371, 3, line_num_865_236);
PROCEDURE_SET(lambda1148_1371, 4, location_861);
{return lambda1148_1371;
}}}} else {long old_pos_872_97;
old_pos_872_97 = INPUT_PORT_FILEPOS(port_862);
{obj_t aux1145_873;
aux1145_873 = read_line___r4_input_6_10_2_179(port_862);
{long aux1146_874;
aux1146_874 = ((long)CINT(line_num_865_236)+1);
{obj_t line_num_1567_214;
obj_t line_string_1566_239;
line_string_1566_239 = aux1145_873;
line_num_1567_214 = BINT(aux1146_874);
line_num_865_236 = line_num_1567_214;
line_string_864_56 = line_string_1566_239;
goto loop_863;
}}}}}}} else {return BFALSE;
}}}

obj_t _error_location_file___error_37(obj_t env_1359, obj_t file_name_1360_136, obj_t location_1361)
{return error_location_file___error_127(file_name_1360_136, location_1361);
}

obj_t lambda1148_local1213(obj_t env_1362, obj_t proc_1368, obj_t msg_1369, obj_t obj_1370)
{{obj_t aux1134_1363;
obj_t line_string_1364_10;
obj_t file_name_1365_45;
obj_t line_num_1366_226;
obj_t location_1367;
aux1134_1363 = PROCEDURE_REF(env_1362, 0);
line_string_1364_10 = PROCEDURE_REF(env_1362, 1);
file_name_1365_45 = PROCEDURE_REF(env_1362, 2);
line_num_1366_226 = PROCEDURE_REF(env_1362, 3);
location_1367 = PROCEDURE_REF(env_1362, 4);
{obj_t proc_1219;
obj_t msg_1220;
obj_t obj_1221;
proc_1219 = proc_1368;
msg_1220 = msg_1369;
obj_1221 = obj_1370;
__error_notifier____error_43 = BFALSE;
{obj_t aux1151_1222;
aux1151_1222 = current_output_port;
FLUSH_OUTPUT_PORT(aux1151_1222);
}{obj_t aux1152_1223;
aux1152_1223 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1152_1223, BNIL));
}{long old_length_1224_6;
obj_t space_string_1225_55;
old_length_1224_6 = get_write_length___r4_output_6_10_3_33();
if(((long)CINT(aux1134_1363)>0)){long aux1156_1226;
aux1156_1226 = ((long)CINT(aux1134_1363)-1);
{int k_1234;
obj_t char_1235;
k_1234 = (int)(aux1156_1226);
char_1235 = MAKE_PAIR(BCHAR(((unsigned char)' ')), BNIL);
if(NULLP(char_1235)){space_string_1225_55 = make_string((long)(k_1234), ((unsigned char)' '));
} else {obj_t aux1017_1236;
aux1017_1236 = CAR(char_1235);
space_string_1225_55 = make_string((long)(k_1234), (unsigned char)CCHAR(aux1017_1236));
}}} else {space_string_1225_55 = string1217___error;
}fix_tabulation____error_157(aux1134_1363, line_string_1364_10, space_string_1225_55);
{obj_t aux1196_1238;
aux1196_1238 = current_error_port;
{obj_t aux1197_1239;
aux1197_1239 = nice_fname___error_199(file_name_1365_45);
fprint___r4_output_6_10_3(aux1196_1238, MAKE_PAIR(string1218___error, MAKE_PAIR(aux1197_1239, MAKE_PAIR(string1219___error, MAKE_PAIR(line_num_1366_226, MAKE_PAIR(string1220___error, MAKE_PAIR(location_1367, MAKE_PAIR(string1221___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1222___error, MAKE_PAIR(line_string_1364_10, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1222___error, MAKE_PAIR(space_string_1225_55, MAKE_PAIR(string1223___error, BNIL)))))))))))))));
}}set_write_length____r4_output_6_10_3_231(80);
{obj_t aux1154_1227;
aux1154_1227 = current_error_port;
fprint___r4_output_6_10_3(aux1154_1227, MAKE_PAIR(string1225___error, MAKE_PAIR(proc_1219, BNIL)));
}{obj_t aux1155_1228;
aux1155_1228 = current_error_port;
fprint___r4_output_6_10_3(aux1155_1228, MAKE_PAIR(string1226___error, MAKE_PAIR(msg_1220, MAKE_PAIR(string1227___error, MAKE_PAIR(obj_1221, BNIL)))));
}{bool_t test1458_1525;
{bool_t test1459_1526;
{obj_t obj_1240;
obj_1240 = __debug____error_22;
test1459_1526 = INTEGERP(obj_1240);
}if(test1459_1526)test1458_1525 = ((long)CINT(__debug____error_22)>0);
 else test1458_1525 = ((bool_t)0);
}if(test1458_1525){obj_t depth_1243;
{bool_t test1464_1530;
{obj_t obj_1244;
obj_1244 = __trace_stack_depth____error_68;
test1464_1530 = INTEGERP(obj_1244);
}if(test1464_1530){depth_1243 = __trace_stack_depth____error_68;
} else {depth_1243 = BINT(10);
}}{obj_t aux1103_1245;
aux1103_1245 = current_error_port;
dump_trace_stack(aux1103_1245, (long)CINT(depth_1243));
}} else {BUNSPEC;
}}return set_write_length____r4_output_6_10_3_231(old_length_1224_6);
}}}}

obj_t do_warn_location___error_83(obj_t fname_923, long line_924, obj_t char_925, obj_t string_926, long marker_927, obj_t args_928)
{{obj_t aux1177_929;
aux1177_929 = current_output_port;
FLUSH_OUTPUT_PORT(aux1177_929);
}{obj_t aux1179_930;
aux1179_930 = current_error_port;
newline___r4_output_6_10_3(MAKE_PAIR(aux1179_930, BNIL));
}{long old_length_931_248;
obj_t space_string_932_182;
old_length_931_248 = get_write_length___r4_output_6_10_3_33();
if((marker_927>0)){long aux1190_943;
aux1190_943 = (marker_927-1);
{int k_1253;
obj_t char_1254;
k_1253 = (int)(aux1190_943);
char_1254 = MAKE_PAIR(BCHAR(((unsigned char)' ')), BNIL);
if(NULLP(char_1254)){space_string_932_182 = make_string((long)(k_1253), ((unsigned char)' '));
} else {obj_t aux1017_1255;
aux1017_1255 = CAR(char_1254);
space_string_932_182 = make_string((long)(k_1253), (unsigned char)CCHAR(aux1017_1255));
}}} else {space_string_932_182 = string1217___error;
}fix_tabulation____error_157(BINT(marker_927), string_926, space_string_932_182);
{obj_t aux1196_1257;
aux1196_1257 = current_error_port;
{obj_t aux1197_1258;
aux1197_1258 = nice_fname___error_199(fname_923);
fprint___r4_output_6_10_3(aux1196_1257, MAKE_PAIR(string1218___error, MAKE_PAIR(aux1197_1258, MAKE_PAIR(string1219___error, MAKE_PAIR(BINT(line_924), MAKE_PAIR(string1220___error, MAKE_PAIR(char_925, MAKE_PAIR(string1221___error, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1222___error, MAKE_PAIR(string_926, MAKE_PAIR(BCHAR(((unsigned char)'\n')), MAKE_PAIR(string1222___error, MAKE_PAIR(space_string_932_182, MAKE_PAIR(string1223___error, BNIL)))))))))))))));
}}{obj_t aux1182_933;
aux1182_933 = current_error_port;
display___r4_output_6_10_3(string1224___error, MAKE_PAIR(aux1182_933, BNIL));
}if(NULLP(args_928)){BUNSPEC;
} else {{obj_t aux1183_934;
aux1183_934 = current_error_port;
{obj_t aux1184_935;
aux1184_935 = CAR(args_928);
fprint___r4_output_6_10_3(aux1183_934, MAKE_PAIR(aux1184_935, BNIL));
}}{obj_t l1005_937;
{obj_t aux1188_941;
aux1188_941 = CDR(args_928);
{bool_t aux1371_1461;
l1005_937 = aux1188_941;
lname1006_936:
if(PAIRP(l1005_937)){{obj_t a_938;
a_938 = CAR(l1005_937);
{obj_t aux1185_939;
aux1185_939 = current_error_port;
display___r4_output_6_10_3(a_938, MAKE_PAIR(aux1185_939, BNIL));
}}{obj_t aux1187_940;
aux1187_940 = CDR(l1005_937);
{obj_t l1005_1468;
l1005_1468 = aux1187_940;
l1005_937 = l1005_1468;
goto lname1006_936;
}}} else {aux1371_1461 = ((bool_t)1);
}BBOOL(aux1371_1461);
}}}}{obj_t aux1189_942;
aux1189_942 = current_error_port;
return newline___r4_output_6_10_3(MAKE_PAIR(aux1189_942, BNIL));
}}}

obj_t fix_tabulation____error_157(obj_t marker_947, obj_t src_948, obj_t dst_949)
{{long read_951;
{long aux1194_955;
aux1194_955 = ((long)CINT(marker_947)-1);
read_951 = aux1194_955;
loop_950:
if((read_951==-1)){return symbol1216___error;
} else {bool_t test1297_1406;
{unsigned char aux1191_952;
aux1191_952 = STRING_REF(src_948, read_951);
{unsigned char char2_1270;
char2_1270 = ((unsigned char)'\t');
test1297_1406 = (aux1191_952==char2_1270);
}}if(test1297_1406){{unsigned char char_1273;
char_1273 = ((unsigned char)'\t');
STRING_SET(dst_949, read_951, char_1273);
}{long aux1192_953;
aux1192_953 = (read_951-1);
{long read_1411;
read_1411 = aux1192_953;
read_951 = read_1411;
goto loop_950;
}}} else {long aux1193_954;
aux1193_954 = (read_951-1);
{long read_1413;
read_1413 = aux1193_954;
read_951 = read_1413;
goto loop_950;
}}}}}}

obj_t nice_fname___error_199(obj_t fname_969)
{{obj_t pwd_970;
{obj_t vpwd_980;
{char * string_1278;
string_1278 = "PWD";
if(getenv(string_1278)){vpwd_980 = string_to_bstring(getenv(string_1278));
} else {vpwd_980 = BFALSE;
}}if(STRINGP(vpwd_980)){pwd_970 = vpwd_980;
} else {pwd_970 = pwd___unix();
}}if(STRINGP(pwd_970)){long lend_971;
long lenf_972;
lend_971 = STRING_LENGTH(pwd_970);
lenf_972 = STRING_LENGTH(fname_969);
if((lenf_972<lend_971)){return fname_969;
} else {long r_974;
r_974 = 0;
loop_973:
if((r_974==lend_971)){bool_t test1268_1387;
if((r_974<lenf_972)){unsigned char aux1200_975;
aux1200_975 = STRING_REF(fname_969, r_974);
{unsigned char char2_1290;
char2_1290 = ((unsigned char)'/');
test1268_1387 = (aux1200_975==char2_1290);
}} else test1268_1387 = ((bool_t)0);
if(test1268_1387){long aux1201_976;
aux1201_976 = (r_974+1);
return c_substring(fname_969, aux1201_976, lenf_972);
} else {return c_substring(fname_969, r_974, lenf_972);
}} else {bool_t test1278_1395;
{unsigned char aux1204_977;
aux1204_977 = STRING_REF(fname_969, r_974);
{unsigned char aux1207_978;
aux1207_978 = STRING_REF(pwd_970, r_974);
test1278_1395 = (aux1204_977==aux1207_978);
}}if(test1278_1395){long aux1208_979;
aux1208_979 = (r_974+1);
{long r_1400;
r_1400 = aux1208_979;
r_974 = r_1400;
goto loop_973;
}} else {return c_substring(fname_969, r_974, lenf_972);
}}}} else {return fname_969;
}}}

